<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstitutionPriveJeunesse extends Model
{
    use HasFactory;

    protected $table = 'institution_prive_jeunesse';

    protected $primaryKey = 'id_inst';

    protected $keyType = 'int';
    public $incrementing = true;

     public $timestamps = true;

    protected $fillable = [
        'id_formulaire',
        'id_statut',
        'type_espace_id',
        'nbr_chambre',
        'nbr_salles',
        'capacite_accueil_hebergement',
        'capacite_accueil_sous_tente',
        'capacite_accueil_espace_animation',
        //'services_inst_id',
        'nom_projet',
        'nature_projet_id',
        'nbr_emplois',
        'directeur_etabl_id',
        'commentaire_motif',
        'remarques',
        'heberg_rest',
        'heberg_stage_activ',
        'camping',
        'activ_educative',
        'voyage',
        'evenement',
        'autre',
    ];

    protected $casts = [
        'heberg_rest' => 'boolean',
        'heberg_stage_activ' => 'boolean',
        'camping' => 'boolean',
        'activ_educative' => 'boolean',
        'voyage' => 'boolean',
        'evenement' => 'boolean',
        'autre' => 'boolean',
    ];

    // Relations possibles

    public function investissements()
    {
        return $this->hasMany(Investissement::class, 'id_inst', 'id_inst');
    }
    public function formulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut', 'id_statut');
    }

    public function typeEspace()
    {
        return $this->belongsTo(TypeEspaceInstitution::class, 'type_espace_id', 'id_type');
    }

    public function serviceInstitution()
    {
        return $this->belongsTo(ServiceInstitution::class, 'services_inst_id', 'id_service');
    }

    public function natureProjet()
    {
        return $this->belongsTo(NatureProjet::class, 'nature_projet_id', 'id_nature_p');
    }

    public function directeur()
    {
        return $this->belongsTo(DirecteurEtablissement::class, 'directeur_etabl_id', 'id_directeur');
    }
	public function statutHistories()
{
    // using institution_id in the history table
    return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'institution_id', 'id_inst')
                ->orderBy('created_at', 'desc');
}
}
