<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Immobilier extends Model
{
    protected $table = 'immobilier';
    protected $primaryKey = 'id_imm';

    protected $fillable = [
        'usage_ar',
        'user_id',
        'adresse_imm',
        'gouvernorat_id',
        'delegation_id',
        'id_statut',
        'type_imm_id',
        'usage_id',
        'id_type_formulaire',
        'document_propriete',
        'superfici_m2',
        'salle_exercice',
        'nbr_salle_exercice',
        'superface_salle_exercice',
        'piscine',
        'nbr_piscine',
        'superface_piscine',
        'vestiaire',
        'nbr_vestiaire',
        'superface_vestiaire',
        'unitaires_sanitaire',
        'superface_unitaires_sanitaire',
        'stockage_conservation',
        'superface_stockage_conservation',
        'espace_exterieur',
        'superface_espace_exterieur',
        'garage',
        'superface_garage',
        'autres_surfaces',
        'commentaire_motif',
        'id_document_formulaire'
    ];

    protected $casts = [
        'salle_exercice' => 'boolean',
        'piscine' => 'boolean',
        'vestiaire' => 'boolean',
        'unitaires_sanitaire' => 'boolean',
        'stockage_conservation' => 'boolean',
        'espace_exterieur' => 'boolean',
        'garage' => 'boolean',
        'superfici_m2' => 'integer',
        'nbr_salle_exercice' => 'integer',
        'superface_salle_exercice' => 'integer',
        'nbr_piscine' => 'integer',
        'superface_piscine' => 'integer',
        'nbr_vestiaire' => 'integer',
        'superface_vestiaire' => 'integer',
        'superface_unitaires_sanitaire' => 'integer',
        'superface_stockage_conservation' => 'integer',
        'superface_espace_exterieur' => 'integer',
        'superface_garage' => 'integer',
        'autres_surfaces' => 'integer',
    ];
    
    public function user()
    {
        return $this->belongsTo(\App\Models\Utilisateur::class, 'user_id');
    }

     public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id', 'id');
    }

    public function gouvernorat()
    {
        return $this->belongsTo(\App\Models\Gouvernorat::class, 'gouvernorat_id');
    }

    public function delegation()
    {
        return $this->belongsTo(\App\Models\Delegation::class, 'delegation_id');
    }

    public function statut()
    {
        return $this->belongsTo(\App\Models\TpStatut::class, 'id_statut', 'id_statut');
    }

    public function typeImmobilier()
    {
        return $this->belongsTo(\App\Models\TypeImmobilier::class, 'type_imm_id');
    }

    public function usage()
    {
        return $this->belongsTo(\App\Models\Usage::class, 'usage_id');
    }

    public function typeFormulaire()
    {
        return $this->belongsTo(\App\Models\TypeFormulaire::class, 'id_type_formulaire', 'id_type');
    }

        public function debutActivite()
    {
        return $this->hasOne(\App\Models\DebutActivite::class, 'immobilier_id', 'id_imm');
    }

    public function documentsFormulaires()
    {
        return $this->hasMany(DocumentsFormulaire::class, 'immobilier_id', 'id_imm');
    }
	    public function statutHistories()
    {
        return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'immobilier_id', 'id_imm')
                    ->orderBy('created_at', 'desc');
    }
}
