<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HistoriqueReservationRestauration extends Model
{
    protected $table = 'historique_reservation_restauration';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'reservation_id',
        'historique_reservation_id',
        'restauration_id',
        'tarif',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class, 'reservation_id', 'id_reserv');
    }

    public function historiqueReservation()
    {
        return $this->belongsTo(HistoriqueReservation::class, 'historique_reservation_id', 'id');
    }

    public function restauration()
    {
        return $this->belongsTo(RestaurationAuberge::class, 'restauration_id', 'id_rest');
    }
}
