<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HistoriqueReservation extends Model
{
    protected $table = 'historique_reservation';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'reservation_id',
        'date_arrive',
        'date_depart',
        'date_reserv',
        'nbr_personnes',
        'nbr_f',
        'nbr_h',
        'total_price',
        'user_id',
        'statut_id',
        'id_auberge',
        'remarque',
        'commentaire_motif',
        'action'
    ];


    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id');
    }

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'id_auberge');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'statut_id');
    }

    public function reservation()
    {
        return $this->belongsTo(Reservation::class, 'reservation_id');
    }

    
    public function chambres()
    {
        return $this->hasMany(HistoriqueChambre::class, 'historique_reservation_id', 'id');
    }

    public function restaurations()
    {
        return $this->belongsToMany(
            RestaurationAuberge::class,
            'historique_reservation_restauration',
                'historique_reservation_id',
                'restauration_id'
            )->withPivot('tarif'); 
    }

    public function historiqueChambres()
{
    return $this->hasMany(HistoriqueChambre::class, 'historique_reservation_id', 'id');
}



}
