<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HistoriqueChambre extends Model
{
    use HasFactory;
    protected $table = 'historique_chambres';
    protected $primaryKey = 'id';
    public $timestamps = true; 

    protected $fillable = [
        'reservation_id',
        'historique_reservation_id',
        'chambre_tente_id',
        'male_personnes',
        'female_personnes',
        'total_personnes',
        'date_arrive',
        'date_depart',
        'action',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class, 'reservation_id', 'id_reserv');
    }

    public function historiqueReservation()
    {
        return $this->belongsTo(HistoriqueReservation::class, 'historique_reservation_id', 'id');
    }

    public function chambreTente()
    {
        return $this->belongsTo(ReservationChambreTente::class, 'chambre_tente_id', 'id');
    }

    

}
