<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DocumentsFormulaireFinancement extends Model
{
    protected $table = 'documents_formulaire';
    protected $primaryKey = 'id_doc';

    protected $fillable = [
        'id_user',
        'copie_cahier_des_charges',
        'copie_originale',
        'facture',
        'contrat',
        'fichier_arrivage',
        'fichier_colisage',
        'copie_registre_fiscal',
        'copie_registre_national_institutions',
        'copie_certificat_propriete',
        'engagement',
        'exemple_projet',
        'id_statut',
        'commentaire_motif',
        'commentaire_acceptation',
        'commentaire_avis',
        'id_formulaire',
        'id_type_formulaire',
        'adresse_projet',
        'nom_projet',
    ];

    // Relations

    public function utilisateur(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Utilisateur::class, 'id_user', 'id');
    }

    public function statut(): BelongsTo
    {
        return $this->belongsTo(\App\Models\TpStatut::class, 'id_statut', 'id_statut');
    }

    public function formulaire(): BelongsTo
    {
        return $this->belongsTo(\App\Models\TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function typeFormulaire(): BelongsTo
    {
        return $this->belongsTo(\App\Models\TypeFormulaire::class, 'id_type_formulaire', 'id_type');
    }
}
