<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Disponibilite extends Model
{
    use HasFactory;

    protected $table = 'disponibilite';
    protected $primaryKey = 'id_dispo';
    protected $fillable = [
        'date', 'est_dispo', 'chambre_id', 'lit_num', 'sexe'
    ];

    public function chambre()
    {
        return $this->belongsTo(ChambreTente::class, 'chambre_id', 'id_chambre_tente');
    }
}
