<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DescGouvr extends Model
{
    use HasFactory;

    protected $table = 'desc_gouvr'; 

    protected $primaryKey = 'id_desc'; 

    public $timestamps = false; 

    protected $fillable = [
        'image_gouv',
        'desc1','desc1_fr','desc1_en',
        'image1',
        'desc2','desc2_fr','desc2_en',
        'image2',
        'desc3','desc3_fr','desc3_en',
        'image3',
        'id_gouv',
        'id_user'
    ];

    public function gouvernorat()
    {
        return $this->belongsTo(Gouvernorat::class, 'id_gouv', 'id_gouver');
    }
    
    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }
}
