<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DemandeManifestation extends Model
{
    protected $table = 'demandes_manifestation';

    protected $primaryKey = 'id_demande';

    protected $fillable = [
        'sujet',
        'sport_type',
        'event_name',
        'objectifs',
        'commentaire_motif',
        'commentaire_motif2',
        'commentaire_motif3',
        'type_formulaire_id',
        'user_id',
        'id_type',
        'organisme_non_sportif_id',
        'role',
        'periode_min',
        'periode_max',
        'lieu',
        'statut_id',
        'statut2_id',
        'file',
    ];

    public function getNumDossierAttribute()
    {
        $idPad = str_pad($this->id_demande, 3, '0', STR_PAD_LEFT);
        $cin = $this->utilisateur->num_cin ?? $this->utilisateur->cin ?? '000000000';
        $cinPad = str_pad(preg_replace('/\D+/', '', $cin), 9, '0', STR_PAD_LEFT);
        $year = $this->created_at ? $this->created_at->format('Y') : now()->format('Y');

        return "{$idPad}-{$cinPad}-{$year}";
    }
    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id');
    }
    public function typeFormulaire(): BelongsTo
    {
        return $this->belongsTo(TypeFormulaire::class, 'type_formulaire_id', 'id_type');
    }
    public function typeDocument(): BelongsTo
    {
        return $this->belongsTo(TypeDocument::class, 'id_type', 'id_type_doc');
    }
    public function organismeNonSportif(): BelongsTo
    {
        return $this->belongsTo(OrganismeNonSportif::class, 'organisme_non_sportif_id');
    }
     public function attachements()
    {
        return $this->hasMany(Attachement::class, 'id_demande', 'id_demande');
    }   
    public function evenementSportifs()
    {
        return $this->hasMany(EvenementSportif::class, 'demande_id', 'id_demande');
    }

    public function assuranceFile()
    {
        return $this->hasOne(Attachement::class, 'id_demande', 'id_demande')
                    ->where('id_type_attach', 2);
    }

    public function techniqueFile()
    {
        return $this->hasOne(Attachement::class, 'id_demande', 'id_demande')
                    ->where('id_type_attach', 7);
    }

    public function accordFile()
    {
        return $this->hasOne(Attachement::class, 'id_demande', 'id_demande')
                    ->where('id_type_attach', 8);
    }

    public function demandeFile()
    {
        return $this->hasOne(Attachement::class, 'id_demande', 'id_demande')
                    ->where('id_type_attach', 9);
    }
    

    public function statut()
    {
        return $this->belongsTo(\App\Models\TpStatut::class, 'id_type', 'id_statut');
    }

    public function statut2()
    {
        return $this->belongsTo(\App\Models\TpStatut::class, 'statut_id', 'id_statut');
    }

    public function statut3()
    {
        return $this->belongsTo(\App\Models\TpStatut::class, 'statut2_id', 'id_statut');
    }

    public function getFileUrlAttribute()
    {
        if (empty($this->file)) {
            return null;
        }
        return \Storage::disk('public')->url($this->file);
    }
    public function statutHistories()
{
    return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'demande_manifestation_id', 'id_demande')
                ->orderBy('created_at', 'desc');
}

}
