<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DebutActivite extends Model
{
    protected $table = 'debut_activites';
    protected $primaryKey = 'id_debut';

    protected $fillable = [
        'immobilier_id',
        'date_debut_activite',
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
        'id_type_formulaire',
        'commentaire_motif',
        'id_statut',
        'etat_formulaire', 
    ];

    protected $casts = [
    'date_debut_activite' => 'datetime', 
];

    public function immobilier()
    {
        return $this->belongsTo(\App\Models\Immobilier::class, 'immobilier_id', 'id_imm');
    }

    public function utilisateur()
{
    return $this->hasOneThrough(
        \App\Models\Utilisateur::class, 
        \App\Models\Immobilier::class,  
        'id_imm',      
        'id',          
        'immobilier_id',
        'user_id'
    );
}

    public function statutHistories()
    {
        return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'debut_activite_id', 'id_debut')
                    ->orderBy('created_at', 'desc');
    }

public function statut()
{
    return $this->belongsTo(TpStatut::class, 'id_statut'); // 'id_statut' = colonne FK
}
}
