<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ConcoursExtOptional extends Model
{
    protected $table = 'concours_ext_optional';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'concours_ext_id',
        'diplome','universite','promotion','date_equivalence','moyenne_generale',
        'ext_1','ext_2','ext_3'
    ];

    public function concours()
    {
        return $this->belongsTo(ConcoursExt::class, 'concours_ext_id', 'id');
    }
}
