<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Concours extends Model
{
    use HasFactory;

    protected $table = 'concours';

    protected $fillable = [
        'titre_ar',
		'titre_fr',
		'titre_en',
        'etat',        // e.g. draft, published, closed
        'date_debut',
        'date_fin',
        'id_user',
    ];

    protected $casts = [
        'date_debut' => 'date',
        'date_fin'   => 'date',
    ];

    /**
     * The user who created the concours (optional).
     */
    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }

    /**
     * Fields associated with this concours (field_definitions).
     * Pivot table: concours_field (concours_id, field_definition_id)
     */
    public function fields()
    {
        return $this->belongsToMany(FieldDefinition::class, 'concours_field', 'concours_id', 'field_definition_id')
                    ->withTimestamps();
                    // ->withPivot('is_visible','is_required') // if you later add per-concours overrides
    }

    /**
     * Candidates registered for / linked to this concours.
     * Pivot table: concours_candidate (concours_id, candidate_id)
     */
    public function candidates()
    {
        return $this->belongsToMany(Candidate::class, 'concours_candidate', 'concours_id', 'candidate_id')
                    ->withTimestamps();
    }

    /** Simple scope to get only published/active contests */
    public function scopeActive($query)
    {
        return $query->where('etat', 'published');
    }

    /** Human label for etat */
    public function getEtatLabelAttribute()
    {
        return match($this->etat) {
            'draft' => 'مسودة',
            'published' => 'منشور',
            'closed' => 'مغلق',
            default => $this->etat,
        };
    }
	
}
