<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Builder extends Model
{
    use HasFactory;

    protected $table = 'builder';
    protected $primaryKey = 'id_builder';

    protected $fillable = [
        'titre_ar',
        'titre_fr',
        'titre_en',
        'id_user',
    ];

    // Relation : Builder appartient à un utilisateur
    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }

    // Relation : Builder possède plusieurs contenus
    public function contenus()
    {
        return $this->hasMany(BuilderContenu::class, 'id_builder', 'id_builder');
	}
	
	   public function guides()
	{
		return $this->hasMany(Guide::class, 'builder_id', 'id_builder');
	}
}
