<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Auberge extends Model
{
    protected $table = 'auberge';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'nom_ar',
        'nom_fr',
        'nom_en',
        'contact_tel',
        'contact_email',
        'type_id',
        'gouver_id',
        'delegation_id',
        'epa',
        'id_milieu_auberge',
        'fax',
        'nom_directeur',
        'tel_directeur',
        'espace_boisson',
        'piscine',
        
        'capacite_batiment',
        'nb_chambres',
        'nb_salles_multi',
        'nb_salles_sport',
        'nb_terrains',
        'types_espaces_sport',
        'espaces_culturels',
        'nb_salles_formation',
        'capacite_exterieure',
        'hebergement',
        'nb_residents',
        'salle_manger',
        'capacite_salle_manger',
        'nb_employes',
        'nb_cadres',
        'nb_agents',
        'autres_services',
        'service_hebergement',
        'service_repas',
        'service_transport',
        'service_lavage',
        'service_securite',
        'adresse',
        'code_postal',
        'nb_chambres_single',
        'nb_chambres_double',
        'nb_chambres_triple',
        'nb_chambres_quadra',
        'nb_chambres_plus',
        'nb_salles_de_bain',
        'nb_salles_de_bain_comm',
        'nb_chambres_tv',
        'nb_chambres_clim',
        'nb_chambres_frigo',
        'capacite_tentes',
        'cuisine_fonct',
        'lieux_culturels',
        'image',
        'description_ar',
        'description_fr',
        'description_en',
        'latitude',
        'longitude',
        'prix_lit',
		'x',
		'y',
		'map_link'
    ];

    public function gouvernorat()
    {
        return $this->belongsTo(Gouvernorat::class, 'gouver_id', 'id_gouver');
    }

    public function delegation()
    {
        return $this->belongsTo(Delegation::class, 'delegation_id', 'id_delegation');
    }
	
	public function utilisateurs()
	{
		return $this->hasMany(Utilisateur::class, 'auberge_id', 'id');
	}

    public function sports()
    {
        return $this->belongsToMany(TpSportsAuberge::class, 'auberge_sports', 'id_auberge', 'id_sport' );
    }

    public function services()
    {
        return $this->belongsToMany(TpServiceAuberge::class, 'auberge_service','id_auberge','id_service'
        );
    }

    public function restaurations()
    {
        return $this->hasMany(RestaurationAuberge::class, 'auberge_id');
    }

    public function avis()
    {
        return $this->hasMany(Avis::class, 'auberge_id', 'id');
    }
    
    public function chambres()
    {
        return $this->hasMany(ChambreTente::class, 'auberge_id', 'id');
    }

    public function espaces()
    {
        return $this->hasMany(EspaceAuberge::class, 'id_auberge', 'id');
    }

    public function terrains()
    {
        return $this->hasMany(TerrainSportifAuberge::class, 'id_auberge', 'id');
    }

    public function services_auberge()
    {
        return $this->hasMany(ServiceAuberge::class, 'id_auberge', 'id');
    }

public function reservations()
{
    return $this->hasMany(Reservation::class, 'id_auberge', 'id');
}

}

