<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AthleteIndividuel extends Model
{
    use HasFactory;

    protected $table = 'athletes_individuels';

    protected $primaryKey = 'id_accos';

    protected $keyType = 'int'; 
    public $incrementing = true;

    public $timestamps = true;

    protected $fillable = [
        'nom_prenom_sportif',
        'num_athlete_h',
        'num_athlete_f',
        'accompagnants',
        'total',
        'event_id',
    ];

    public function evenement()
    {
        return $this->belongsTo(EvenementSportif::class, 'event_id', 'id_even');
    }
}
