<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Association extends Model
{
    protected $table = 'association';

    protected $primaryKey = 'id_association';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'nom_association',
        'adresse',
        'code_postal',
        'tel',
        'fax',
        'date_creation',
        'num_visa',
        'date_visa',
        'num_identification_fiscale',
        'num_compte_courant',
        'banque',
        'adresse_mail',
        'adresse_site_internet',
        'nom_president_association',
        'tel_personnel',
        'num_membre_bureau_national_a',
        'objectifs_association',
        'num_bureaux_regionaux',
        'num_total_membre',
        'id_formulaire'
    ];

    protected $casts = [
        'num_membre_bureau_national_a' => 'integer',
        'num_bureaux_regionaux' => 'integer',
        'num_total_membre' => 'integer'
    ];

    public function formulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function demandes()
    {
        return $this->hasMany(DemandeFinancement::class, 'association_id', 'id_association');
    }

    public function projets()
    {
        return $this->hasMany(Projet::class, 'id_association', 'id_association');
    }
}
