<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\DocumentsFinancementList;

class StatutDocumentChanged extends Mailable
{
    use Queueable, SerializesModels;

    public $docList;

    public function __construct(DocumentsFinancementList $docList)
    {
        $this->docList = $docList;
    }

    public function build()
    {
        return $this->subject('تحديث حالة ملفك للتمويل العمومي')
                    ->view('emails.statut_document_changed')
                    ->with([
                        'statut' => $this->docList->id_statut1,
                        'motif'  => $this->docList->commentaire_motif1,
                        'user'   => $this->docList->user,
                    ]);
    }
}
