<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\DocumentsFinancementList;

class Statut2DocumentChanged extends Mailable
{
    use Queueable, SerializesModels;

    public $docList;

    public function __construct(DocumentsFinancementList $docList)
    {
        $this->docList = $docList;
    }

    public function build()
    {
        return $this->subject('تحديث حالة ملفك للتمويل العمومي')
                    ->view('emails.statut2_document_changed')
                    ->with([
                        'statut' => $this->docList->id_statut2,
                        'motif'  => $this->docList->commentaire_motif2,
                        'user'   => $this->docList->user,
                    ]);
    }
}
