<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SalleSportStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;
    public $user;
    public $dateDebut;
    public $commentaire;
    public $immobilier_id; // ← Ajouter

    public function __construct($type, $user, $dateDebut = null, $commentaire = null, $immobilier_id = null)
    {
        $this->type = $type;
        $this->user = $user;
        $this->dateDebut = $dateDebut;
        $this->commentaire = $commentaire;
        $this->immobilier_id = $immobilier_id; // ← Passer ici
    }

    public function build()
    {
        return $this->subject('Réponse à votre demande de salle de sport')
                    ->markdown('emails.salle_sport.statut');
    }
}
