<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class JeuneEnfantStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type; 
    public $user;
    public $data; 

    public function __construct($type, $user, $data = null)
    {
        $this->type = $type;
        $this->user = $user;
        $this->data = $data;
    }

    public function build()
    {
        $subject = $this->type === 'accepte'
            ? 'تم قبول مشروعك'
            : 'تم رفض مشروعك';

        return $this->to($this->user->email) 
                    ->subject($subject)
                    ->markdown('emails.jeune_enfant.statut');
    }
}

