<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DocumentStatusMail extends Mailable
{
    use Queueable, SerializesModels;

    public $utilisateur;
    public $statut;
    public $messageStatus;
    public $numeroDossier;

    public function __construct($utilisateur, $id_statut, $messageStatus, $numeroDossier = null)
    {
        $this->utilisateur = $utilisateur;
        $this->id_statut = $id_statut;
        $this->messageStatus = $messageStatus;
        $this->numeroDossier = $numeroDossier;
    }

    public function build()
    {
        return $this->subject('تحديث حالة ملف الإعفاء الجبائي رقم ' . $this->numeroDossier)
                    ->view('emails.document_status')
                    ->with([
                        'utilisateur' => $this->utilisateur,
                        'messageStatus' => $this->messageStatus,
                        'numeroDossier' => $this->numeroDossier,
                    ]);
    }

    /*public function __construct($utilisateur, $statut, $messageStatus)
    {
        $this->utilisateur = $utilisateur;
        $this->statut = $statut;
        $this->messageStatus = $messageStatus;
    }

    public function build()
    {
        return $this->subject('تحديث حالة ملف الإعفاء الجبائي')
                    ->markdown('emails.document_status');
    }*/
}
