<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DebutActiviteStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;
    public $user;
    public $commentaire;

    public function __construct($type, $user, $commentaire = null)
    {
        $this->type = $type;
        $this->user = $user;
        $this->commentaire = $commentaire;
    }

    public function build()
    {
        return $this->subject('Réponse à votre demande de debut activite')
                    ->markdown('emails.salle_sport.debut_activite');
    }
}
