<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\Utilisateur;

class AccountConfirmationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;

    public function __construct(Utilisateur $user)
    {
        $this->user = $user;
    }

    public function build()
    {
        return $this->subject('تأكيد حسابك — وزارة الشباب والرياضة')
                    ->view('emails.utilisateurs.account_confirmation')
                    ->with([
                        'name' => $this->user->nom_prenom,
                        'code' => $this->user->confirmation_code,
                    ]);
    }
}
