<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RoleMiddleware
{
    public function handle(Request $request, Closure $next, $roles = null)
{
    $user = Auth::guard('admin')->user(); // Utiliser le guard admin explicitement

    // Si non connecté
    if (!$user) {
        return redirect()->route('login'); // route existante
    }

    // Liste des rôles interdits
    $forbiddenRoles = [2, 3];

    // Vérifie le rôle
    if (isset($user->id_roles) && in_array($user->id_roles, $forbiddenRoles)) {
        abort(403, '⛔ Accès non autorisé');
    }

    return $next($request);
}



}
