<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckPermission
{
    public function handle($request, Closure $next, $permission)
    {
        $user = Auth::user();

        if (!$user) {
			abort(403, '🚫 الوصول مرفوض - المستخدم غير مصادق.');
		}

		if (!$user->hasPermission($permission)) {
			abort(403, '🚫 ليس لديك الصلاحية للوصول إلى هذه الصفحة.');
		}

        return $next($request);
    }
}

