<?php

namespace App\Http\Controllers;

use App\Models\TropheeSportif;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class TropheeSportifController extends Controller
{
    public function index(Request $request)
	{
		$search = trim($request->get('search'));
		$words = $search ? preg_split('/\s+/', $search) : [];

		$trophee_sportif = TropheeSportif::when($words, function ($query) use ($words) {
			foreach ($words as $word) {
				$word = str_replace(['\\', '%', '_'], ['\\\\', '\\%', '\\_'], $word);

				$query->where(function ($q) use ($word) {
					$q->where('title', 'LIKE', "%{$word}%")
					  ->orWhere('title_en', 'LIKE', "%{$word}%")
					  ->orWhere('title_fr', 'LIKE', "%{$word}%");
				});
			}
		})
		->orderBy('created_at','desc')
		->paginate(10)
		->appends(['search' => $search]); // يحافظ على البحث أثناء التنقل بين الصفحات

		return view('backoffice.trophee_sportif.index', compact('trophee_sportif'));
	}


    public function create()
    {
        return view('backoffice.trophee_sportif.create');
    }

    private function youtubeEmbedUrl($url)
    {
        if (preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $url, $m)) {
            return 'https://www.youtube.com/embed/' . $m[2];
        }
        return null;
    }


    public function store(Request $request)
    {
        $data = $request->validate([
        'date' => 'required|date',
        'title' => 'required|string|max:255',
        'title_fr' => 'required|string|max:255',
        'title_en' => 'required|string|max:255',
        'content' => 'required|string',
        'content_fr' => 'required|string',
        'content_en' => 'required|string',
        'resume_ar' => 'required|string|max:1000',
        'resume_fr' => 'required|string|max:1000',
        'resume_en' => 'required|string|max:1000',
        'image' => 'nullable|image|max:2048',
        'youtube_url' => 'nullable|url',
        'published' => 'sometimes|boolean',
    ], [
        'date.required' => 'الرجاء تحديد التاريخ.',
        'title.required' => 'الرجاء إدخال العنوان بالعربية.',
        'title_fr.required' => 'الرجاء إدخال العنوان بالفرنسية.',
        'title_en.required' => 'الرجاء إدخال العنوان بالإنجليزية.',
        'content.required' => 'الرجاء إدخال المحتوى بالعربية.',
        'content_fr.required' => 'الرجاء إدخال المحتوى بالفرنسية.',
        'content_en.required' => 'الرجاء إدخال المحتوى بالإنجليزية.',
        'resume_ar.required' => 'الرجاء إدخال الملخّص بالعربية.',
        'resume_fr.required' => 'الرجاء إدخال الملخّص بالفرنسية.',
        'resume_en.required' => 'الرجاء إدخال الملخّص بالإنجليزية.',
        'image.image' => 'يجب أن يكون الملف صورة.',
        'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت.',
        'youtube_url.url' => 'الرجاء إدخال رابط YouTube صالح.',
        'published.boolean' => 'قيمة النشر غير صحيحة.',
    ]);


        if ($request->hasFile('image')) {			$imageContent = file_get_contents($request->file('image')->getRealPath());			$data['image'] = $imageContent;		}

        $data['published'] = $request->input('published', 0);
        $data['slug'] = Str::slug($data['title']) . '-' . Str::random(6);
        $data['id_user'] = auth()->id();

        TropheeSportif::create($data);

        return redirect()->route('trophee_sportif.index')->with('success', 'تم إنشاء التتويج الرياضي بنجاح.');
    }

    public function show(TropheeSportif $trophee_sportif)
    {
        $embed = $this->youtubeEmbedUrl($trophee_sportif->youtube_url);
        return view('backoffice.trophee_sportif.show', compact('trophee_sportif', 'embed'));
    }

    public function edit(TropheeSportif $trophee_sportif)
    {
        return view('backoffice.trophee_sportif.edit', compact('trophee_sportif'));
    }

    public function update(Request $request, TropheeSportif $trophee_sportif)
    {
        $data = $request->validate([
        'date' => 'required|date',
        'title' => 'required|string|max:255',
        'title_fr' => 'required|string|max:255',
        'title_en' => 'required|string|max:255',
        'content' => 'required|string',
        'content_fr' => 'required|string',
        'content_en' => 'required|string',
        'resume_ar' => 'required|string|max:1000',
        'resume_fr' => 'required|string|max:1000',
        'resume_en' => 'required|string|max:1000',
        'image' => 'nullable|image|max:2048',
        'youtube_url' => 'nullable|url',
        'published' => 'sometimes|boolean',
    ], [
        'date.required' => 'الرجاء تحديد التاريخ.',
        'title.required' => 'الرجاء إدخال العنوان بالعربية.',
        'title_fr.required' => 'الرجاء إدخال العنوان بالفرنسية.',
        'title_en.required' => 'الرجاء إدخال العنوان بالإنجليزية.',
        'content.required' => 'الرجاء إدخال المحتوى بالعربية.',
        'content_fr.required' => 'الرجاء إدخال المحتوى بالفرنسية.',
        'content_en.required' => 'الرجاء إدخال المحتوى بالإنجليزية.',
        'resume_ar.required' => 'الرجاء إدخال الملخّص بالعربية.',
        'resume_fr.required' => 'الرجاء إدخال الملخّص بالفرنسية.',
        'resume_en.required' => 'الرجاء إدخال الملخّص بالإنجليزية.',
        'image.image' => 'يجب أن يكون الملف صورة.',
        'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت.',
        'youtube_url.url' => 'الرجاء إدخال رابط YouTube صالح.',
        'published.boolean' => 'قيمة النشر غير صحيحة.',
    ]);

        				if ($request->hasFile('image')) {			$imageContent = file_get_contents($request->file('image')->getRealPath());			$data['image'] = $imageContent;		} else {			$data['image'] = $trophee_sportif->image;		}
        $data['id_user'] = auth()->id();
        $data['published'] = $request->input('published', 0);
        $trophee_sportif->update($data);

        return redirect()->route('trophee_sportif.index')->with('success', 'تم تحديث التتويج الرياضي بنجاح.');
    }

    public function destroy(TropheeSportif $trophee_sportif)
    {
        if ($trophee_sportif->image && Storage::disk('public')->exists($trophee_sportif->image)) {
            Storage::disk('public')->delete($trophee_sportif->image);
        }
        $trophee_sportif->delete();

        return redirect()->route('trophee_sportif.index')->with('success', 'تم حذف التتويج الرياضي بنجاح.');
    }


}
