<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use App\Models\Utilisateur;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class SlidersController extends Controller
{
    public function index(Request $request)
	{
		$search = trim($request->get('search'));
		$words = $search ? preg_split('/\s+/', $search) : [];

		$sliders = Slider::with('utilisateur')
			->when($words, function ($query) use ($words) {
				foreach ($words as $word) {
					// Échapper caractères spéciaux pour LIKE
					$word = str_replace(['\\', '%', '_'], ['\\\\', '\\%', '\\_'], $word);

					$query->where(function ($q) use ($word) {
						$q->where('titre_ar', 'LIKE', "%{$word}%")
						  ->orWhere('titre_fr', 'LIKE', "%{$word}%")
						  ->orWhere('titre_en', 'LIKE', "%{$word}%");
					});
				}
			})
			->orderBy('created_at', 'desc')
			->paginate(10)
			->appends(['search' => $search]);

		return view('backoffice.sliders.index', compact('sliders'));
	}


    public function create()
    {
        return view('backoffice.sliders.create');
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'titre_ar' => 'required|string|max:200',
            'titre_fr' => 'required|string|max:200',
            'titre_en' => 'required|string|max:200',
            'soustitre_ar' => 'nullable|string|max:100',
            'soustitre_fr' => 'nullable|string|max:100',
            'soustitre_en' => 'nullable|string|max:100',

            'titre_bouton_ar' => 'nullable|string|max:100',
            'lien_bouton_ar' => 'nullable|url|max:255',
            'titre_bouton_fr' => 'nullable|string|max:100',
            'lien_bouton_fr' => 'nullable|url|max:255',
            'titre_bouton_en' => 'nullable|string|max:100',
            'lien_bouton_en' => 'nullable|url|max:255',

            'titre_bouton2_ar' => 'nullable|string|max:100',
            'lien_bouton2_ar' => 'nullable|url|max:255',
            'titre_bouton2_fr' => 'nullable|string|max:100',
            'lien_bouton2_fr' => 'nullable|url|max:255',
            'titre_bouton2_en' => 'nullable|string|max:100',
            'lien_bouton2_en' => 'nullable|url|max:255',

            'image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
        ], [
        'titre_ar.required' => 'الرجاء إدخال العنوان بالعربية',
        'titre_fr.required' => 'الرجاء إدخال العنوان بالفرنسية',
        'titre_en.required' => 'الرجاء إدخال العنوان بالإنجليزية',
        'image.image' => 'الملف يجب أن يكون صورة',
        'image.mimes' => 'نوع الصورة يجب أن يكون jpeg, png, jpg أو webp',
        'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت',
    ]);


        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $imagePath = null;
        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('uploads/sliders', 'public');
        }

        Slider::create([
            'titre_ar' => $request->titre_ar,
            'titre_fr' => $request->titre_fr,
            'titre_en' => $request->titre_en,
            'soustitre_ar' => $request->soustitre_ar,
            'soustitre_fr' => $request->soustitre_fr,
            'soustitre_en' => $request->soustitre_en,

            'titre_bouton_ar' => $request->titre_bouton_ar,
            'lien_bouton_ar' => $request->lien_bouton_ar,
            'titre_bouton_fr' => $request->titre_bouton_fr,
            'lien_bouton_fr' => $request->lien_bouton_fr,
            'titre_bouton_en' => $request->titre_bouton_en,
            'lien_bouton_en' => $request->lien_bouton_en,

            'titre_bouton2_ar' => $request->titre_bouton2_ar,
            'lien_bouton2_ar' => $request->lien_bouton2_ar,
            'titre_bouton2_fr' => $request->titre_bouton2_fr,
            'lien_bouton2_fr' => $request->lien_bouton2_fr,
            'titre_bouton2_en' => $request->titre_bouton2_en,
            'lien_bouton2_en' => $request->lien_bouton2_en,

            'image' => $imagePath,
            'id_user' => Auth::id(),
        ]);

        return redirect()->route('sliders.index')->with('success', 'تمت إضافة الصورة بنجاح');
    }

    public function edit($id)
    {
        $slider = Slider::findOrFail($id);
        return view('backoffice.sliders.edit', compact('slider'));
    }

    public function update(Request $request, $id)
    {
        $slider = Slider::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'titre_ar' => 'required|string|max:200',
            'titre_fr' => 'required|string|max:200',
            'titre_en' => 'required|string|max:200',
            'soustitre_ar' => 'nullable|string|max:100',
            'soustitre_fr' => 'nullable|string|max:100',
            'soustitre_en' => 'nullable|string|max:100',

            'titre_bouton_ar' => 'nullable|string|max:100',
            'lien_bouton_ar' => 'nullable|url|max:255',
            'titre_bouton_fr' => 'nullable|string|max:100',
            'lien_bouton_fr' => 'nullable|url|max:255',
            'titre_bouton_en' => 'nullable|string|max:100',
            'lien_bouton_en' => 'nullable|url|max:255',

            'titre_bouton2_ar' => 'nullable|string|max:100',
            'lien_bouton2_ar' => 'nullable|url|max:255',
            'titre_bouton2_fr' => 'nullable|string|max:100',
            'lien_bouton2_fr' => 'nullable|url|max:255',
            'titre_bouton2_en' => 'nullable|string|max:100',
            'lien_bouton2_en' => 'nullable|url|max:255',

            'image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
        ], [
        'titre_ar.required' => 'الرجاء إدخال العنوان بالعربية',
        'titre_fr.required' => 'الرجاء إدخال العنوان بالفرنسية',
        'titre_en.required' => 'الرجاء إدخال العنوان بالإنجليزية',
        'image.image' => 'الملف يجب أن يكون صورة',
        'image.mimes' => 'نوع الصورة يجب أن يكون jpeg, png, jpg أو webp',
        'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت',
    ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        if ($request->hasFile('image')) {
            if ($slider->image && file_exists(public_path('storage/' . $slider->image))) {
                unlink(public_path('storage/' . $slider->image));
            }
            $slider->image = $request->file('image')->store('uploads/sliders', 'public');
        }

        $slider->update([
            'titre_ar' => $request->titre_ar,
            'titre_fr' => $request->titre_fr,
            'titre_en' => $request->titre_en,
            'soustitre_ar' => $request->soustitre_ar,
            'soustitre_fr' => $request->soustitre_fr,
            'soustitre_en' => $request->soustitre_en,

            'titre_bouton_ar' => $request->titre_bouton_ar,
            'lien_bouton_ar' => $request->lien_bouton_ar,
            'titre_bouton_fr' => $request->titre_bouton_fr,
            'lien_bouton_fr' => $request->lien_bouton_fr,
            'titre_bouton_en' => $request->titre_bouton_en,
            'lien_bouton_en' => $request->lien_bouton_en,

            'titre_bouton2_ar' => $request->titre_bouton2_ar,
            'lien_bouton2_ar' => $request->lien_bouton2_ar,
            'titre_bouton2_fr' => $request->titre_bouton2_fr,
            'lien_bouton2_fr' => $request->lien_bouton2_fr,
            'titre_bouton2_en' => $request->titre_bouton2_en,
            'lien_bouton2_en' => $request->lien_bouton2_en,
            'id_user' => Auth::id(),
        ]);

        return redirect()->route('sliders.index')->with('success', 'تم تحديث شريط الصور بنجاح');
    }

    public function destroy($id)
    {
        $slider = Slider::findOrFail($id);

        if ($slider->image && file_exists(public_path('storage/' . $slider->image))) {
            unlink(public_path('storage/' . $slider->image));
        }

        $slider->delete();

        return redirect()->route('sliders.index')->with('success', 'تم حذف الصورة بنجاح');
    }

}
