<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use App\Models\News;

class NewsController extends Controller
{

	public function index(Request $request)
	{
		$search = trim($request->get('search'));
		$words = $search ? preg_split('/\s+/', $search) : [];

		$news = News::when($words, function ($query) use ($words) {
			foreach ($words as $word) {
				// Échapper caractères spéciaux pour LIKE
				$word = str_replace(['\\', '%', '_'], ['\\\\', '\\%', '\\_'], $word);

				$query->where(function ($q) use ($word) {
					$q->where('title', 'LIKE', "%{$word}%")
					  ->orWhere('title_en', 'LIKE', "%{$word}%")
					  ->orWhere('title_fr', 'LIKE', "%{$word}%");
				});
			}
		})
		->orderBy('created_at','desc')
		->paginate(10)
		->appends(['search' => $search]); // يحافظ على البحث أثناء الانتقال بين الصفحات

		return view('backoffice.news.index', compact('news'));
	}



    public function create()
    {
        return view('backoffice.news.create');
    }

    private function youtubeEmbedUrl($url)
    {
        if (preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $url, $m)) {
            return 'https://www.youtube.com/embed/' . $m[2];
        }
        return null;
    }


    /*public function store(Request $request)
    {
        $data = $request->validate([
        'date' => 'required|date',
        'title' => 'required|string|max:255',
        'title_fr' => 'required|string|max:255',
        'title_en' => 'required|string|max:255',
        'content' => 'required|string',
        'content_fr' => 'required|string',
        'content_en' => 'required|string',
        'resume_ar' => 'required|string|max:1000',
        'resume_fr' => 'required|string|max:1000',
        'resume_en' => 'required|string|max:1000',
        'image' => 'nullable|image|max:2048',
        'youtube_url' => 'nullable|url',
        'published' => 'sometimes|boolean',
    ], [
        'date.required' => 'الرجاء تحديد التاريخ.',
        'title.required' => 'الرجاء إدخال العنوان بالعربية.',
        'title_fr.required' => 'الرجاء إدخال العنوان بالفرنسية.',
        'title_en.required' => 'الرجاء إدخال العنوان بالإنجليزية.',
        'content.required' => 'الرجاء إدخال المحتوى بالعربية.',
        'content_fr.required' => 'الرجاء إدخال المحتوى بالفرنسية.',
        'content_en.required' => 'الرجاء إدخال المحتوى بالإنجليزية.',
        'resume_ar.required' => 'الرجاء إدخال الملخّص بالعربية.',
        'resume_fr.required' => 'الرجاء إدخال الملخّص بالفرنسية.',
        'resume_en.required' => 'الرجاء إدخال الملخّص بالإنجليزية.',
        'image.image' => 'يجب أن يكون الملف صورة.',
        'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت.',
        'youtube_url.url' => 'الرجاء إدخال رابط YouTube صالح.',
        'published.boolean' => 'قيمة النشر غير صحيحة.',
    ]);


        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('', 'public');
            $data['image'] = $path;
        }

        $data['published'] = $request->input('published', 0);
        $data['slug'] = Str::slug($data['title']) . '-' . Str::random(6);
        $data['id_user'] = auth()->id();
        News::create($data);

        return redirect()->route('news.index')->with('success', 'تم إنشاء الخبر بنجاح.');
    }*/
	
	public function store(Request $request)
	{
		$data = $request->validate([
			'date' => 'required|date',
			'title' => 'required|string|max:255',
			'title_fr' => 'required|string|max:255',
			'title_en' => 'required|string|max:255',
			'content' => 'required|string',
			'content_fr' => 'required|string',
			'content_en' => 'required|string',
			'resume_ar' => 'required|string|max:1000',
			'resume_fr' => 'required|string|max:1000',
			'resume_en' => 'required|string|max:1000',
			'image' => 'nullable|image|max:2048',
			'youtube_url' => 'nullable|url',
			'published' => 'sometimes|boolean',
		], [
			'date.required' => 'الرجاء تحديد التاريخ.',
			'title.required' => 'الرجاء إدخال العنوان بالعربية.',
			'title_fr.required' => 'الرجاء إدخال العنوان بالفرنسية.',
			'title_en.required' => 'الرجاء إدخال العنوان بالإنجليزية.',
			'content.required' => 'الرجاء إدخال المحتوى بالعربية.',
			'content_fr.required' => 'الرجاء إدخال المحتوى بالفرنسية.',
			'content_en.required' => 'الرجاء إدخال المحتوى بالإنجليزية.',
			'resume_ar.required' => 'الرجاء إدخال الملخّص بالعربية.',
			'resume_fr.required' => 'الرجاء إدخال الملخّص بالفرنسية.',
			'resume_en.required' => 'الرجاء إدخال الملخّص بالإنجليزية.',
			'image.image' => 'يجب أن يكون الملف صورة.',
			'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت.',
			'youtube_url.url' => 'الرجاء إدخال رابط YouTube صالح.',
			'published.boolean' => 'قيمة النشر غير صحيحة.',
		]);

		if ($request->hasFile('image')) {
			$imageContent = file_get_contents($request->file('image')->getRealPath());
			$data['image'] = $imageContent;
		}

		$data['published'] = $request->input('published', 0);
		$data['slug'] = Str::slug($data['title']) . '-' . Str::random(6);
		$data['id_user'] = auth()->id();

		News::create($data);

		return redirect()->route('news.index')->with('success', 'تم إنشاء الخبر بنجاح.');
	}


    public function show(News $news)
    {
        $embed = $this->youtubeEmbedUrl($news->youtube_url);
        return view('backoffice.news.show', compact('news', 'embed'));
    }

    public function edit(News $news)
    {
        return view('backoffice.news.edit', compact('news'));
    }

    /*public function update(Request $request, News $news)
    {
        $data = $request->validate([
        'date' => 'required|date',
        'title' => 'required|string|max:255',
        'title_fr' => 'required|string|max:255',
        'title_en' => 'required|string|max:255',
        'content' => 'required|string',
        'content_fr' => 'required|string',
        'content_en' => 'required|string',
        'resume_ar' => 'required|string|max:1000',
        'resume_fr' => 'required|string|max:1000',
        'resume_en' => 'required|string|max:1000',
        'image' => 'nullable|image|max:2048',
        'youtube_url' => 'nullable|url',
        'published' => 'sometimes|boolean',
    ], [
        'date.required' => 'الرجاء تحديد التاريخ.',
        'title.required' => 'الرجاء إدخال العنوان بالعربية.',
        'title_fr.required' => 'الرجاء إدخال العنوان بالفرنسية.',
        'title_en.required' => 'الرجاء إدخال العنوان بالإنجليزية.',
        'content.required' => 'الرجاء إدخال المحتوى بالعربية.',
        'content_fr.required' => 'الرجاء إدخال المحتوى بالفرنسية.',
        'content_en.required' => 'الرجاء إدخال المحتوى بالإنجليزية.',
        'resume_ar.required' => 'الرجاء إدخال الملخّص بالعربية.',
        'resume_fr.required' => 'الرجاء إدخال الملخّص بالفرنسية.',
        'resume_en.required' => 'الرجاء إدخال الملخّص بالإنجليزية.',
        'image.image' => 'يجب أن يكون الملف صورة.',
        'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت.',
        'youtube_url.url' => 'الرجاء إدخال رابط YouTube صالح.',
        'published.boolean' => 'قيمة النشر غير صحيحة.',
    ]);

        if ($request->hasFile('image')) {
            if ($news->image && Storage::disk('public')->exists($news->image)) {
                Storage::disk('public')->delete($news->image);
            }
            $path = $request->file('image')->store('', 'public');
            $data['image'] = $path;
        }
        $data['id_user'] = auth()->id();
        $data['published'] = $request->input('published', 0);
        $news->update($data); 

        return redirect()->route('news.index')->with('success', 'تم تحديث الخبر بنجاح.');
    }*/
	
	public function update(Request $request, News $news) 
	{
		$data = $request->validate([
			'date' => 'required|date',
			'title' => 'required|string|max:255',
			'title_fr' => 'required|string|max:255',
			'title_en' => 'required|string|max:255',
			'content' => 'required|string',
			'content_fr' => 'required|string',
			'content_en' => 'required|string',
			'resume_ar' => 'required|string|max:1000',
			'resume_fr' => 'required|string|max:1000',
			'resume_en' => 'required|string|max:1000',
			'image' => 'nullable|image|max:2048',
			'youtube_url' => 'nullable|url',
			'published' => 'sometimes|boolean',
		], [
			'date.required' => 'الرجاء تحديد التاريخ.',
			'title.required' => 'الرجاء إدخال العنوان بالعربية.',
			'title_fr.required' => 'الرجاء إدخال العنوان بالفرنسية.',
			'title_en.required' => 'الرجاء إدخال العنوان بالإنجليزية.',
			'content.required' => 'الرجاء إدخال المحتوى بالعربية.',
			'content_fr.required' => 'الرجاء إدخال المحتوى بالفرنسية.',
			'content_en.required' => 'الرجاء إدخال المحتوى بالإنجليزية.',
			'resume_ar.required' => 'الرجاء إدخال الملخّص بالعربية.',
			'resume_fr.required' => 'الرجاء إدخال الملخّص بالفرنسية.',
			'resume_en.required' => 'الرجاء إدخال الملخّص بالإنجليزية.',
			'image.image' => 'يجب أن يكون الملف صورة.',
			'image.max' => 'حجم الصورة يجب ألا يتجاوز 2 ميغابايت.',
			'youtube_url.url' => 'الرجاء إدخال رابط YouTube صالح.',
			'published.boolean' => 'قيمة النشر غير صحيحة.',
		]);

		if ($request->hasFile('image')) {
			$imageContent = file_get_contents($request->file('image')->getRealPath());
			$data['image'] = $imageContent;
		} else {
			$data['image'] = $news->image;
		}

		$data['id_user'] = auth()->id();
		$data['published'] = $request->input('published', 0);

		$news->update($data);

		return redirect()->route('news.index')->with('success', 'تم تحديث الخبر بنجاح.');
	}


    public function destroy(News $news)
    {
        if ($news->image && Storage::disk('public')->exists($news->image)) {
            Storage::disk('public')->delete($news->image);
        }
        $news->delete();

        return redirect()->route('news.index')->with('success', 'تم حذف الخبر بنجاح.');
    }


}
