<?php

namespace App\Http\Controllers\Investissement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebutActivite;
use App\Models\Immobilier;use App\Models\Identite_personnel;
use App\Models\Utilisateur;
use Illuminate\Support\Facades\Storage;
use App\Mail\DebutActiviteStatutMail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use App\Notifications\DebutActiviteStatutNotification;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use App\Models\ImmobilierStatutHistory;
use App\Models\TpStatut;
use Illuminate\Support\Facades\Auth;
class DebutActiviteController extends Controller
{
    public function index(Request $request)
    {
        /*$debutActivites = DebutActivite::with('immobilier.utilisateur')
            ->orderByDesc('created_at')
            ->paginate(10);*/
$query = DebutActivite::with('immobilier.utilisateur')->orderByDesc('created_at');     if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {        $query->whereDate('date_debut_activite', $request->date);    }        if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {        $type = $request->type_identite;        if ($type == 1 && $request->filled('cin')) {            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('cin', $request->cin));        }        if ($type == 2 && $request->filled('passport')) {            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('passport', $request->passport));        }        if ($type == 3 && $request->filled('num_fiscal')) {            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));        }    }    $debutActivites = $query->paginate(10)->withQueryString();    $typesIdentite = Identite_personnel::all();
        return view('backoffice.investissement.gestion_salle_sport.debut_activite.index', compact('debutActivites', 'typesIdentite'));
    }

    public function create(Request $request)
    {
        $immobilier_id = $request->query('immobilier_id', null);
        return view('backoffice.investissement.gestion_salle_sport.debut_activite.create', compact('immobilier_id'));
    }

    public function exportExcel(Request $request)
{
    $query = DebutActivite::with('immobilier.utilisateur', 'statut')->orderByDesc('created_at');

    // Filtrer comme dans index
    if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {
        $query->whereDate('date_debut_activite', $request->date);
    }

    if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;
        if ($type == 1 && $request->filled('cin')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('cin', $request->cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('passport', $request->passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));
        }
    }

    $debutActivites = $query->get();

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    // Header
    $sheet->fromArray([
        ['المعرف', 'اسم المستخدم', 'تاريخ بداية النشاط', 'الحالة']
    ], null, 'A1');
    $sheet->getStyle('A1:D1')->getFont()->setBold(true);

    // Data
    $row = 2;
    foreach ($debutActivites as $activite) {
        $sheet->setCellValue('A'.$row, $activite->id_debut);
        $sheet->setCellValue('B'.$row, $activite->immobilier && $activite->immobilier->utilisateur 
            ? $activite->immobilier->utilisateur->nom_prenom : '---');
        $sheet->setCellValue('C'.$row, $activite->date_debut_activite ? $activite->date_debut_activite->format('Y-m-d') : '---');
        $sheet->setCellValue('D'.$row, $activite->statut->statut_ar ?? 'في الانتظار');
        $row++;
    }

    foreach (range('A', 'D') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);
    $fileName = 'debut_activite.xlsx';

    return response()->streamDownload(function () use ($writer) {
        $writer->save('php://output');
    }, $fileName);
}

public function exportPdf(Request $request)
{
    $query = DebutActivite::with('immobilier.utilisateur', 'statut')->orderByDesc('created_at');

    // Filtrage comme dans index
    if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {
        $query->whereDate('date_debut_activite', $request->date);
    }

    if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;
        if ($type == 1 && $request->filled('cin')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('cin', $request->cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('passport', $request->passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));
        }
    }

    $debutActivites = $query->get();

    $html = view('backoffice.investissement.gestion_salle_sport.exports.debut_activite_pdf', compact('debutActivites'))->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('debut_activite.pdf', 'S'))
        ->header('Content-Type', 'application/pdf');
}

    public function store(Request $request)
    {
        $validated = $request->validate([
            'immobilier_id' => 'required|exists:immobilier,id_imm',
'date_debut_activite' => 'required|date',            
'preuve_propriete_location' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'plan_architectural' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'declaration_investissement' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'identification' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'extrait_registre_national_entreprise' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'certificat_prevention' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'contrat_assurance' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'approbation_autorite_minicipale' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);

        $uploads = [];
        foreach ([
            'preuve_propriete_location',
            'plan_architectural',
            'declaration_investissement',
            'identification',
            'extrait_registre_national_entreprise',
            'certificat_prevention',
            'contrat_assurance',
            'approbation_autorite_minicipale',
        ] as $fileField) {

        if ($request->hasFile($fileField)) {
            $file = $request->file($fileField);
            $originalName = $file->getClientOriginalName();
            $filename = pathinfo($originalName, PATHINFO_FILENAME);
            $extension = $file->getClientOriginalExtension();

            // Générer un nom unique en ajoutant un timestamp
            $uniqueName = $filename. '.' . $extension;

            // Stocker le fichier dans public/uploads/debut_activite
            $uploads[$fileField] = $file->storeAs('uploads/debut_activite', $uniqueName, 'public');
        }
    }

        DebutActivite::create([
            'immobilier_id' => $request->immobilier_id,
            'date_debut_activite' => $request->date_debut_activite,
            'preuve_propriete_location' => $uploads['preuve_propriete_location'] ?? null,
            'plan_architectural' => $uploads['plan_architectural'] ?? null,
            'declaration_investissement' => $uploads['declaration_investissement'] ?? null,
            'identification' => $uploads['identification'] ?? null,
            'extrait_registre_national_entreprise' => $uploads['extrait_registre_national_entreprise'] ?? null,
            'certificat_prevention' => $uploads['certificat_prevention'] ?? null,
            'contrat_assurance' => $uploads['contrat_assurance'] ?? null,
            'approbation_autorite_minicipale' => $uploads['approbation_autorite_minicipale'] ?? null,
            'etat_formulaire' => 'remplir',
            'id_type_formulaire' => 2,
            'id_statut' => 2,
        ]);

        return redirect()->route('admin.debut_activite.index')->with('success', 'تم تسجيل بداية النشاط بنجاح ');
    }

public function verifierIdentite(Request $request)
{
    $request->validate([
        'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
        'identifiant' => 'required|string',
        'immobilier_id' => 'required|exists:immobilier,id_imm'
    ]);

    $idType = $request->id_type_identite;
    $identifiant = $request->identifiant;
    $immobilier_id = $request->immobilier_id;

    $immobilier = Immobilier::with('utilisateur','gouvernorat')->find($immobilier_id);
    if(!$immobilier) return response()->json(['success' => false]);

    $user = $immobilier->utilisateur;
    $match = false;

    if($idType == 1 && $user->cin == $identifiant) $match = true;
    if($idType == 2 && $user->passport == $identifiant) $match = true;
    if($idType == 3 && $user->num_fiscal == $identifiant) $match = true;

    if($match) {
        return response()->json([
            'success' => true,
            'user' => $user,
            'immobilier' => [
                'id_imm' => $immobilier->id_imm,
                'gouvernorat_nom_ar' => $immobilier->gouvernorat->nom_ar ?? null
            ]
        ]);
    }

    return response()->json(['success' => false]);
}

public function edit($id)
{
    $debutActivite = DebutActivite::with([
        'immobilier.utilisateur',
        'immobilier.gouvernorat',
        'statutHistories.fromStatut',
        'statutHistories.toStatut',
        'statutHistories.changer',
    ])->findOrFail($id);

    $immobilier_id = $debutActivite->immobilier_id;
    $statuts = TpStatut::orderBy('id_statut')->get();

    return view('backoffice.investissement.gestion_salle_sport.debut_activite.edit', compact(
        'debutActivite', 'immobilier_id', 'statuts'
    ));
}


    
public function update(Request $request, $id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Validation
    $validated = $request->validate([
        'immobilier_id' => 'required|exists:immobilier,id_imm',
        //'date_debut_activite' => 'required|date|after_or_equal:' . now()->addDays(15)->toDateString(),
        'date_debut_activite' => 'required|date',
        'id_statut' => 'nullable',
        'commentaire_motif' => 'nullable|string|max:255',
        'preuve_propriete_location' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'plan_architectural' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'declaration_investissement' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'identification' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'extrait_registre_national_entreprise' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'certificat_prevention' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'contrat_assurance' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'approbation_autorite_minicipale' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
    ]);
$oldStatut = (int) $debutActivite->id_statut;
$newStatut = isset($request->id_statut) ? (int) $request->id_statut : $oldStatut;

    $comment = null;
    // prefer the explicit fields if present (trim and ignore empty strings)
    if ($request->filled('commentaire_refus')) {
        $comment = trim($request->input('commentaire_refus'));
    } elseif ($request->filled('commentaire_status')) {
        $comment = trim($request->input('commentaire_status'));
    } elseif ($request->filled('commentaire_motif')) {
        $comment = trim($request->input('commentaire_motif'));
    }
    // Normalize empty => null
    if ($comment === '') $comment = null;

    // Gestion des fichiers uploadés
    $uploads = [];
	foreach ([
		'preuve_propriete_location',
		'plan_architectural',
		'declaration_investissement',
		'identification',
		'extrait_registre_national_entreprise',
		'certificat_prevention',
		'contrat_assurance',
		'approbation_autorite_minicipale',
	] as $fileField) {
		if ($request->hasFile($fileField)) {
			$file = $request->file($fileField);
			$content = file_get_contents($file->getRealPath());
			$uploads[$fileField] = $content;
		}
	}


    // Préparer les données à mettre à jour
    $updateData = [
        'immobilier_id' => $request->immobilier_id,
        'date_debut_activite' => $request->date_debut_activite,
        'id_statut' => $request->id_statut ?? $debutActivite->id_statut, 
        'commentaire_motif' => $comment ?? $debutActivite->commentaire_motif,
        'etat_formulaire' => in_array($request->id_statut, [1, 3]) ? 'reponse' : $debutActivite->etat_formulaire,
    ];

    // Merge fichiers uploadés
    $updateData = array_merge($updateData, $uploads);

    // Mise à jour de l'enregistrement
    $debutActivite->update($updateData);
if ($oldStatut !== $newStatut) {
    ImmobilierStatutHistory::create([
        'immobilier_id'      => $debutActivite->immobilier_id,
        'debut_activite_id'  => $debutActivite->id_debut,
        'from_statut_id'     => $oldStatut ?: null,
        'to_statut_id'       => $newStatut ?: null,
        'changed_by'         => Auth::id() ?? null,
        'commentaire'        => $comment,
   
    ]);
}
    // Envoi du mail selon le statut
    $user = $debutActivite->immobilier->utilisateur;
    if ($request->id_statut == 3 && $request->commentaire_motif) {
        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
        );
    } elseif ($request->id_statut == 1) {
        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('accepte', $user)
        );
    }

    return redirect()->route('admin.debut_activite.index')
                     ->with('success', 'تم تحديث بيانات بداية النشاط بنجاح');
}


public function download($id, $field)
{
    $debutActivite = \App\Models\DebutActivite::findOrFail($id);
    $fileContent = $debutActivite->$field;

    if (!$fileContent) {
        abort(404);
    }

    // Détecter le type MIME du fichier
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mime = $finfo->buffer($fileContent);

    // Déterminer l'extension pour le nom du fichier
    $extension = '';
    switch ($mime) {
        case 'application/pdf':
            $extension = 'pdf';
            break;
        case 'image/jpeg':
            $extension = 'jpg';
            break;
        case 'image/png':
            $extension = 'png';
            break;
        default:
            $extension = 'bin';
            break;
    }

    return response($fileContent)
           ->header('Content-Type', $mime)
           ->header('Content-Disposition', 'inline; filename="'.$field.'.'.$extension.'"');
}






        public function toggleStatut(Request $request, $id)
    {
        $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

        $debutActivite->id_statut = $request->id_statut;

        if (in_array($request->id_statut, [1, 3])) {
            $debutActivite->etat_formulaire = 'reponse';
        }

        $user = $debutActivite->immobilier->utilisateur;

        if ($request->id_statut == 3 && $request->commentaire_motif) {
            $debutActivite->commentaire_motif = $request->commentaire_motif;

            Mail::to($user->email)->send(
                new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
            );

            $user->notify(new DebutActiviteStatutNotification('refuse', $request->commentaire_motif));

        } elseif ($request->id_statut == 1) {
            $dateDebut = Carbon::now()->addDays(15);

            Mail::to($user->email)->send(
                new DebutActiviteStatutMail('accepte', $user, $dateDebut)
            );

            $user->notify(new DebutActiviteStatutNotification('accepte', $dateDebut));
        }

        $debutActivite->save();

        return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
    }


public function show($id)
    {		 $debutActivite = DebutActivite::with([
        'immobilier.utilisateur',
        'immobilier.gouvernorat',
        'statutHistories.fromStatut',
        'statutHistories.toStatut',
        'statutHistories.changer',
    ])->findOrFail($id);
        $immobilier_id = $debutActivite->immobilier_id;
    $statuts = TpStatut::orderBy('id_statut')->get();
        return view('backoffice.investissement.gestion_salle_sport.debut_activite.show', compact('debutActivite', 'immobilier_id','statuts'));
    }




/*public function pdf($id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);
    $data = compact('debutActivite');

    $html = view('backoffice.investissement.gestion_salle_sport.debut_activite.pdf', $data)->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');
    $mpdf->WriteHTML($html);

    return $mpdf->Output('debut_activite.pdf', 'I');
}*/

public function pdf($id)
{
    ini_set('pcre.backtrack_limit', '10000000');
    ini_set('pcre.recursion_limit', '10000000');

    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);
    $data = compact('debutActivite');

    $html = view('backoffice.investissement.gestion_salle_sport.debut_activite.pdf', $data)->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');
    $mpdf->WriteHTML($html);

    return $mpdf->Output('debut_activite.pdf', 'I');
}


/*public function pdf($id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');

    // ⚠️ écrire le HTML en morceaux
    $mpdf->WriteHTML(view(
        'backoffice.investissement.gestion_salle_sport.debut_activite.pdf_header',
        compact('debutActivite')
    )->render());

    $mpdf->WriteHTML(view(
        'backoffice.investissement.gestion_salle_sport.debut_activite.pdf_body',
        compact('debutActivite')
    )->render());

    $mpdf->WriteHTML(view(
        'backoffice.investissement.gestion_salle_sport.debut_activite.pdf_documents',
        compact('debutActivite')
    )->render());

    return $mpdf->Output('debut_activite.pdf', 'I');
}
*/

    public function destroy($id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Liste des fichiers à supprimer
    $files = [
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ];

    foreach ($files as $fileField) {
        if ($debutActivite->$fileField && Storage::disk('public')->exists($debutActivite->$fileField)) {
            Storage::disk('public')->delete($debutActivite->$fileField);
        }
    }

    $debutActivite->delete();

    return redirect()->route('admin.debut_activite.index')->with('success', 'تم حذف الاستمارة بنجاح.');
}



//////////////////////////////////////////******  Front   ******** //////////////////////////////////////////////////////////////

public function index2(Request $request)
    {
        $debutActivites = DebutActivite::with('immobilier.utilisateur')
            ->orderByDesc('created_at')
            ->paginate(10);

        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.index', compact('debutActivites'));
    }

    public function create2(Request $request)
    {
        $immobilier_id = $request->query('immobilier_id', null);
        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.create', compact('immobilier_id'));
    }

    public function store2(Request $request)
    {
        $validated = $request->validate([
            'immobilier_id' => 'required|exists:immobilier,id_imm',
            'date_debut_activite' => 'required|date',            
            'preuve_propriete_location' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'plan_architectural' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'declaration_investissement' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'identification' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'extrait_registre_national_entreprise' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'certificat_prevention' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'contrat_assurance' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'approbation_autorite_minicipale' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);

        $uploads = [];
        foreach ([
            'preuve_propriete_location',
            'plan_architectural',
            'declaration_investissement',
            'identification',
            'extrait_registre_national_entreprise',
            'certificat_prevention',
            'contrat_assurance',
            'approbation_autorite_minicipale',
        ] as $fileField) {
            if ($request->hasFile($fileField)) {
                $uploads[$fileField] = $request->file($fileField)->store('uploads/debut_activite', 'public');
            }
        }

        DebutActivite::create([
            'immobilier_id' => $request->immobilier_id,
            'date_debut_activite' => $request->date_debut_activite,
            'preuve_propriete_location' => $uploads['preuve_propriete_location'] ?? null,
            'plan_architectural' => $uploads['plan_architectural'] ?? null,
            'declaration_investissement' => $uploads['declaration_investissement'] ?? null,
            'identification' => $uploads['identification'] ?? null,
            'extrait_registre_national_entreprise' => $uploads['extrait_registre_national_entreprise'] ?? null,
            'certificat_prevention' => $uploads['certificat_prevention'] ?? null,
            'contrat_assurance' => $uploads['contrat_assurance'] ?? null,
            'approbation_autorite_minicipale' => $uploads['approbation_autorite_minicipale'] ?? null,
        ]);

        return redirect()->route('debut_activite.create2')->with('success', 'تم تسجيل بداية النشاط بنجاح ');
    }

public function verifierIdentite2(Request $request)
{
    $request->validate([
        'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
        'identifiant' => 'required|string',
        'immobilier_id' => 'required|exists:immobilier,id_imm'
    ]);

    $idType = $request->id_type_identite;
    $identifiant = $request->identifiant;
    $immobilier_id = $request->immobilier_id;

    $immobilier = Immobilier::with('utilisateur','gouvernorat')->find($immobilier_id);
    if(!$immobilier) return response()->json(['success' => false]);

    $user = $immobilier->utilisateur;
    $match = false;

    if($idType == 1 && $user->cin == $identifiant) $match = true;
    if($idType == 2 && $user->passport == $identifiant) $match = true;
    if($idType == 3 && $user->num_fiscal == $identifiant) $match = true;

    if($match) {
        return response()->json([
            'success' => true,
            'user' => $user,
            'immobilier' => [
                'id_imm' => $immobilier->id_imm,
                'gouvernorat_nom_ar' => $immobilier->gouvernorat->nom_ar ?? null
            ]
        ]);
    }

    return response()->json(['success' => false]);
}

        public function edit2($id)
    {
        $debutActivite = DebutActivite::with('immobilier.utilisateur', 'immobilier.gouvernorat')->findOrFail($id);
        $immobilier_id = $debutActivite->immobilier_id;

        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.edit', compact('debutActivite', 'immobilier_id'));
    }

    public function update2(Request $request, $id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Validation
    $validated = $request->validate([
        'immobilier_id' => 'required|exists:immobilier,id_imm',
        'date_debut_activite' => 'required|date',
        'id_statut' => 'nullable|in:1,3',
        'commentaire_motif' => 'nullable|string|required_if:id_statut,3|max:255',
        'preuve_propriete_location' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'plan_architectural' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'declaration_investissement' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'identification' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'extrait_registre_national_entreprise' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'certificat_prevention' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'contrat_assurance' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'approbation_autorite_minicipale' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
    ]);

    // Gestion des fichiers uploadés
    $uploads = [];
    foreach ([
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ] as $fileField) {
        if ($request->hasFile($fileField)) {
            if ($debutActivite->$fileField) {
                Storage::disk('public')->delete($debutActivite->$fileField);
            }
            $uploads[$fileField] = $request->file($fileField)->store('uploads/debut_activite', 'public');
        }
    }

    // Mise à jour de l'enregistrement
    $debutActivite->update(array_merge(
        [
            'immobilier_id' => $request->immobilier_id,
            'date_debut_activite' => $request->date_debut_activite,
            'id_statut' => $request->id_statut,                 // <- Ajout du statut
            'commentaire_motif' => $request->commentaire_motif, // <- Ajout du motif
        ],
        $uploads
    ));

    // Envoi du mail selon le statut
    $user = $debutActivite->immobilier->utilisateur;
    if ($request->id_statut == 3 && $request->commentaire_motif) {
        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
        );
    } elseif ($request->id_statut == 1) {
        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('accepte', $user)
        );
    }

    return redirect()->route('debut_activite.index2')
                     ->with('success', 'تم تحديث بيانات بداية النشاط بنجاح');
}


        public function toggleStatut2(Request $request, $id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

    // Supprimer la restriction sur le statut actuel
    $debutActivite->id_statut = $request->id_statut;
    $user = $debutActivite->immobilier->utilisateur;

    if ($request->id_statut == 3 && $request->commentaire_motif) {
        $debutActivite->commentaire_motif = $request->commentaire_motif;

        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
        );

        $user->notify(new DebutActiviteStatutNotification('refuse', $request->commentaire_motif));

    } elseif ($request->id_statut == 1) {
        $dateDebut = Carbon::now()->addDays(15);

        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('accepte', $user, $dateDebut)
        );

        $user->notify(new DebutActiviteStatutNotification('accepte', $dateDebut));
    }

    $debutActivite->save();

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}


public function show2($id)
    {
        $debutActivite = DebutActivite::with('immobilier.utilisateur', 'immobilier.gouvernorat')->findOrFail($id);
        $immobilier_id = $debutActivite->immobilier_id;

        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.show', compact('debutActivite', 'immobilier_id'));
    }

    public function destroy2($id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Liste des fichiers à supprimer
    $files = [
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ];

    foreach ($files as $fileField) {
        if ($debutActivite->$fileField && Storage::disk('public')->exists($debutActivite->$fileField)) {
            Storage::disk('public')->delete($debutActivite->$fileField);
        }
    }

    $debutActivite->delete();

    return redirect()->route('debut_activite.index2')->with('success', 'تم حذف الاستمارة بنجاح.');
}

}
