<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function redirectToForm($formulaire)
    {
        // Vérifier si connecté (admin)
        if (!Auth::guard('admin')->check()) {
            return redirect()->route('login')
                             ->with('error', 'الرجاء تسجيل الدخول للمتابعة.');
        }

        $user = Auth::guard('admin')->user();

        // Vérifier si l'utilisateur a le droit (par ex. rôle_id 1 ou 3)
        if (!in_array($user->role_id, [1, 3])) {
            abort(403, 'غير مسموح لك بالولوج إلى هذا القسم');
        }

        // Rediriger selon formulaire demandé
        switch ($formulaire) {
            case 'salle-sport':
                return redirect()->route('salle-sport.index2');

            default:
                abort(404);
        }
    }
}
