<?php

namespace App\Http\Controllers\Financement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Projet;
use App\Models\TypeFormulaire;
use App\Models\TpTypeDocument;
use App\Models\DocumentsFinancement;
use App\Models\TypeFinancement;
use App\Models\TpStatut;
use App\Models\DocumentsFinancementList;
use App\Mail\Statut2DocumentChanged;
use App\Notifications\Statut2DocumentNotification;
use App\Models\Utilisateur;
use App\Models\DemandeFinancement;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Models\ImmobilierStatutHistory;
class Document2FinancementController extends Controller
{
    public function index(Request $request){    $query = DocumentsFinancementList::with([    
            'statut2',        'projet.association',        'projet.superviseur',        'projet.demande'    ])   
             ->orderBy('id_doc_list', 'desc')	
             ->where('id_statut1', 1)   ;
              if ($request->filled('nom_association')) { 
                       $query->whereHas('projet.association', function($q) use ($request) {   
                                 $q->where('nom_association', 'like', '%' . $request->nom_association . '%');   
                                     });   
                                     }  
                                      if ($request->filled('type_demande')) {      
                                          $query->whereHas('projet.demande', function($q) use ($request) {     
                                                   $q->where('type_financement_id', $request->type_demande);   
                                                     }); 
                                                       }   
                                                        if ($request->filled('nom_projet')) {  
                                                                  $query->whereHas('projet', function($q) use ($request) {   
                                                                             $q->where('nom_projet', 'like', '%' . $request->nom_projet . '%');  
                                                                                  });   
                                                                                 }   
                                                                                  if ($request->filled('nom_superviseur')) {        
                                                                                    $query->whereHas('projet.superviseur', function($q) use ($request) {       
                                                                                             $q->where('nom_prenom', 'like', '%' . $request->nom_superviseur . '%');
                                                                                                    });  
                                                                                                  }    
                                                                                                  $documents = $query->paginate(10)->appends($request->query());  
                                                               
                                                                                                  $type_financement = TypeFinancement::all(); 
                                                                                                     
                                                                                                  return view('backoffice.financement.documents_financement.index2', compact('documents', 'type_financement'));  
                                                                                                  }			
   


    public function edit($id_doc_list)
    {
        $docList = DocumentsFinancementList::with(['projet',
            'projet.superviseur',
            'projet.activites',
            'projet.estimationBudget',
            'projet.estimationBudget.contributeurs',
            'projet.estimationBudget.postesDepense','documents',
            'documents.typeDocument',
            'statut1', 'statut2'
        ])->findOrFail($id_doc_list);

        $formulaire = TypeFormulaire::find(6);
        $formulaire2 = TypeFormulaire::find(7);
        $formulaire3 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();
        $demande_id = $docList->projet->id_demande;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association 
            ? $demande->association->id_association 
            : null;

        $selectedAssociationName = $demande && $demande->association 
            ? $demande->association->nom_association 
            : null;

        $id_projet = $docList->projet->id_projet; 
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();
        $typedocum = TpTypeDocument::all();

        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                            ->pluck('type_financement_id')
                                            ->toArray();

        $documents = $docList->documents;
 $statuts = TpStatut::orderBy('id_statut')->get();
        return view('backoffice.financement.documents_financement.edit2', compact(
            'docList','formulaire','formulaire2','formulaire3','type_financement',
            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',
            'id_projet','typedocum','selectedTypes','docList','statuts'
        ));
    }

    
public function update(Request $request, $id)
    {
        DB::beginTransaction();

        try {
            $rules = [
                
                    // Association
                    'nom_association' => 'required|string|max:255',
                    'adresse' => 'required|string|max:255',
                    'code_postal' => 'required|string|max:20',
                    'tel' => 'required|string|max:50',
                    'fax' => 'required|string|max:50',
                    'date_creation' => 'required|date',
                    'num_visa' => 'required|string|max:100',
                    'date_visa' => 'required|date',
                    'num_identification_fiscale' => 'required|string|max:100',
                    'num_compte_courant' => 'required|string|max:100',
                    'banque' => 'required|string|max:255',
                    'adresse_mail' => 'required|email|max:255',
                    'adresse_site_internet' => 'required|string|max:255',
                    'nom_president_association' => 'required|string|max:255',
                    'tel_personnel' => 'required|string|max:50',
                    'num_membre_bureau_national_a' => 'required|integer',
                    'num_bureaux_regionaux' => 'required|integer',
                    'num_total_membre' => 'required|integer',
                    'types_financement' => 'required|array|min:1',
                    'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',

                    // Superviseur
                    'nom_prenom_sup' => 'required|string|max:100',
                    'profession_sup' => 'required|string|max:100',
                    'role_sup'       => 'required|string|max:100',
                    'tel_sup'        => 'required|string|max:12',
                    'email_sup'      => 'required|email|max:255',

                    // Projet
                    'nom_projet'               => 'required|string|max:255',
                    'justification_realisation'=> 'required|string|max:255',
                    'objectives'               => 'required|string',
                    'public'                   => 'required|string|max:255',
                    'nombre_spectateur'        => 'required|integer|min:1',
                    'tranch_age_min'           => 'required|integer|min:0',
                    'tranch_age_max'           => 'required|integer|gte:tranch_age_min',
                    'parties_realisation'      => 'required|string',
                    'resultat_quantitatif'     => 'required|string',
                    'resultat_qualitatif'      => 'required|string',
                    'perspectives'             => 'required|string',

                    // Phases
                    'phases.*.description'         => 'required|string|max:200',
                    'phases.*.completion_date'     => 'required|date',
                    'phases.*.completion_location' => 'required|string|max:100',

                    // Budget
                    'budget.*.total_cost'      => 'required|numeric|min:0',
                    'budget.*.self_percent'    => 'required|numeric|min:0|max:100',
                    'budget.*.self_amount'     => 'required|numeric|min:0',
                    'budget.*.ministry_amount' => 'required|numeric|min:0',
                    'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',
                    'budget.*.supporters.*.name'   => 'required|string|max:255',
                    'budget.*.supporters.*.amount' => 'required|numeric|min:0',
                    'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',

                    // Dépenses
                    

                    'depenses.*.*.libelle_depense' => 'required|string|max:200',
                    'depenses.*.*.description'     => 'required|string|max:255',
                    'depenses.*.*.cout'            => 'required|numeric|min:0',
                    // Documents
                    'id_statut' => 'nullable|integer|in:1,2,3', 
                    'commentaire_motif2' => 'nullable|string|max:500',
                    'decision_finale' => 'required|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:5120',
                    'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',
                    'doc_fin.*.file' => 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',
                    'doc_fin.*.remarques' => 'nullable|string|max:100',
            ];

            $request->validate($rules);

            $docList = DocumentsFinancementList::findOrFail($id);
            $projet = $docList->projet;
            $association = $projet->association;
            $superviseur = $projet->superviseur;

            $association->update($request->only([
                'nom_association','adresse','code_postal','tel','fax',
                'date_creation','num_visa','date_visa','num_identification_fiscale',
                'num_compte_courant','banque','adresse_mail','adresse_site_internet',
                'nom_president_association','tel_personnel','num_membre_bureau_national_a',
                'num_bureaux_regionaux','num_total_membre','id_formulaire'
            ]));

            $superviseur->update($request->only([
                'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'
            ]));

            $projet->update([
                'id_formulaire'           => $request->id_formulaire,
                'nom_projet'              => $request->nom_projet,
                'justification_realisation'=> $request->justification_realisation,
                'objectives'              => $request->objectives,
                'public'                  => $request->public,
                'id_user' => auth()->id(),
                'nombre_spectateur'       => $request->nombre_spectateur,
                'tranch_age_min'          => $request->tranch_age_min,
                'tranch_age_max'          => $request->tranch_age_max,
                'parties_realisation'     => $request->parties_realisation,
                'resultat_quantitatif'    => $request->resultat_quantitatif,
                'resultat_qualitatif'     => $request->resultat_qualitatif,
                'perspectives'            => $request->perspectives,
            ]);

            $projet->activites()->delete();
            if ($request->has('phases')) {
                foreach ($request->phases as $phase) {
                    if (!empty($phase['description'])) {
                        ActivitePhase::create([
                            'id_projet'           => $projet->id_projet,
                            'description'         => $phase['description'],
                            'completion_date'     => $phase['completion_date'] ?? null,
                            'completion_location' => $phase['completion_location'] ?? null,
                        ]);
                    }
                }
            }

            if ($projet->estimationBudget && $projet->estimationBudget->count() > 0) {
                foreach ($projet->estimationBudget as $estimation) {
                    $estimation->contributeurs()->delete();
                    $estimation->postesDepense()->delete();
                    $estimation->delete();
                }
            }

            if ($request->has('budget')) {
                foreach ($request->budget as $budget) {
                    $estimation = EstimationBudget::create([
                        'projet_id'                      => $projet->id_projet,
                        'cout_total_estime'              => $budget['total_cost'] ?? 0,
                        'financement_propre_pourcentage' => $budget['self_percent'] ?? 0,
                        'financement_propre_montant'     => $budget['self_amount'] ?? 0,
                        'aide_ministere_montant'         => $budget['ministry_amount'] ?? 0,
                        'aide_ministere_pourcentage'     => $budget['ministry_percent'] ?? 0,
                    ]);

                    if (isset($budget['supporters'])) {
                        foreach ($budget['supporters'] as $supporter) {
                            if (!empty($supporter['name'])) {
                                $contributeurs = ContributeurProjet::create([
                                    'id_estimation_budget' => $estimation->id_estimation,
                                    'nom'        => $supporter['name'],
                                    'montant'    => $supporter['amount'] ?? 0,
                                    'pourcentage'=> $supporter['percent'] ?? 0,
                                ]);
                            }
                        }
                    }

                    if ($request->has('depenses')) {
                        foreach ($request->depenses as $depense) {
                            if (!empty($depense['libelle_depense'])) {
                                PosteDepense::create([
                                    'id_estimation_budget' => $estimation->id_estimation,
                                    'libelle_depense'      => $depense['libelle_depense'],
                                    'description'          => $depense['description'] ?? '',
                                    'cout'                 => $depense['cout'] ?? 0,
                                ]);
                            }
                        }
                    }
                }
            }

            // -----------------------------
        // Documents : statut, commentaire et fichier final
        // -----------------------------
        if ($request->filled('id_statut')) {
            $docList->update([
                'id_statut2' => $request->id_statut,
                'commentaire_motif2' => $request->id_statut == 3 ? $request->commentaire_motif2 : null,
            ]);
        }

        if ($request->hasFile('decision_finale')) {
            $file = $request->file('decision_finale');
            $path = $file->store('', 'public');
            $docList->update(['decision_finale' => $path]);
        }

        // Documents individuels
        if ($request->has('doc_fin')) {
            $documentsExistants = $docList->documents;

            foreach ($request->doc_fin as $docData) {
                $document = $documentsExistants->firstWhere('id_doc', $docData['id_doc']);
                $filePath = $document ? $document->file : null;

                if (isset($docData['file']) && $docData['file'] instanceof \Illuminate\Http\UploadedFile) {
                    $file = $docData['file'];
                    $originalName = $file->getClientOriginalName();
                    $file->move(public_path('storage/'), $originalName);
                    $filePath = '/' . $originalName;
                }

                if ($document) {
                    $document->update([
                        'file' => $filePath,
                        'remarques' => $docData['remarques'] ?? null,
                    ]);
                } else {
                    DocumentsFinancement::create([
                        'id_doc'      => $docData['id_doc'],
                        'file'        => $filePath,
                        'remarques'   => $docData['remarques'] ?? null,
                        'id_doc_list' => $docList->id_doc_list,
                    ]);
                }
            }
        }
          $normalizeStat = function($val) {
        $v = is_null($val) ? null : (int) $val;
        return ($v && $v > 0) ? $v : null;
    };
    $origStat2 = $docList->getOriginal('id_statut2'); // قد يكون null أو 0 أو رقم
    $oldStat2 = $normalizeStat($origStat2);

    // اقرأ القيمة المرسلة من الفورم — افتح fallback على الحالة الحالية في الـ model
    $inputStat2 = $request->input('id_statut2', $docList->id_statut2 ?? null);
    $newStat2 = $normalizeStat($inputStat2);

    // تعليق للحفظ في التاريخ (اختياري: اختر الحقل الصحيح من الفورم)
    $commentForHistory = null;
    if ($request->filled('commentaire_refus')) {
        $commentForHistory = trim($request->input('commentaire_refus'));
    } elseif ($request->filled('commentaire_status')) {
        $commentForHistory = trim($request->input('commentaire_status'));
    } elseif ($request->filled('commentaire_motif2')) {
        $commentForHistory = trim($request->input('commentaire_motif2'));
    }

    // تأكد أن projet موجود في الجدول المرجعي قبل تمريره (لتجنّب أخطاء FK)
    $projetIdForHistory = null;
    if (!empty($docList->id_projet)) {
        $existsProject = DB::table('projet_divertissement_jeune_enfant')
                            ->where('id_projet', $docList->id_projet)
                            ->exists();
        if ($existsProject) {
            $projetIdForHistory = $docList->id_projet;
        } else {
            Log::warning("Project referenced by DocumentsFinancementList not found", [
                'docList' => $docList->id_doc_list,
                'projet_id' => $docList->id_projet
            ]);
            // سنمرّر null لـ projet_id كي لا يخرب FK
            $projetIdForHistory = null;
        }
    }

    // إنشاء سجل التاريخ فقط إن تغيّر الـ statut فعلاً (مقارنة old vs new)
    if ($oldStat2 !== $newStat2) {
        ImmobilierStatutHistory::create([
            'documents_financement_list_id' => $docList->id_doc_list,
            'projet_id'                    => $projetIdForHistory,
            'from_statut_id'               => $oldStat2,
            'to_statut_id'                 => $newStat2,
            'changed_by'                   => Auth::id() ?? null,
            'commentaire'                  => $commentForHistory,
        ]);
    }

    // الآن حدّث القيم في DocumentsFinancementList (حفظ النتائج)
    $updateData = [];
    // حدّث فقط الحقول المطلوبة
    if ($request->filled('id_statut2')) {
        $updateData['id_statut2'] = $newStat2;
        // حفظ تعليق الرفض إن كان موجوداً
        $updateData['commentaire_motif2'] = ($newStat2 === 3 && $request->filled('commentaire_motif2'))
            ? trim($request->input('commentaire_motif2'))
            : null;
    }

    // ملفات القرار النهائي
    if ($request->hasFile('decision_finale')) {
        $file = $request->file('decision_finale');
        $path = $file->store('documents/decision_finale', 'public'); // مسار مقترح
        $updateData['decision_finale'] = $path;
    }

    if (!empty($updateData)) {
        $docList->update($updateData);
    }
        DB::commit();

        return redirect()->route('backoffice.financement.documents_financement.index2', $docList->id_doc_list)
            ->with('success', 'تم تحديث الوثيقة بنجاح');
    } catch (\Exception $e) {
        DB::rollBack();
        return back()->withErrors(['error' => 'خطأ أثناء التحديث: ' . $e->getMessage()]);
    }
}

	public function showDecision($id)	{	
        	$doc = DocumentsFinancementList::findOrFail($id);	
            	if (!$doc->decision_finale) {	
                    abort(404, "Aucun fichier.");	
                }		
             return response($doc->decision_finale)->header('Content-Type', $doc->decision_finale_mime)->header('Content-Disposition', 'inline; filename="decision_finale"');
            	}


    public function show($id)
    {
        $docList = DocumentsFinancementList::with([
            'projet.superviseur',
            'projet.activites',
            'projet.estimationBudget',
            'projet.estimationBudget.contributeurs',
            'projet.estimationBudget.postesDepense','documents',
            'documents.typeDocument',
            'statut1', 'statut2'
        ])->findOrFail($id);
        $currentStatus = $docList->id_statut2;
        $formulaire = TypeFormulaire::find(6);
        $formulaire2 = TypeFormulaire::find(7);
        $formulaire3 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();

        $demande_id = $docList->projet->id_demande;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association 
            ? $demande->association->id_association 
            : null;

        $selectedAssociationName = $demande && $demande->association 
            ? $demande->association->nom_association 
            : null;

        $id_projet = $docList->projet->id_projet; 
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();
        $typedocum = TpTypeDocument::all();

        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                            ->pluck('type_financement_id')
                                            ->toArray();

        $documents = $docList->documents;
        $statuts = TpStatut::orderBy('id_statut')->get();
        return view('backoffice.financement.documents_financement.show2', compact(
            'docList','formulaire','formulaire2','formulaire3','type_financement','currentStatus',
            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',
            'id_projet','typedocum','selectedTypes','docList','statuts'
        ));
    }


    public function toggleStatut(Request $request, $id_doc_list)
    {
        $docList = DocumentsFinancementList::with('user')->findOrFail($id_doc_list);
        $user = $docList->user;

        if ($request->filled('id_statut2')) {
            $docList->id_statut2 = $request->id_statut2;
        }

        if ($request->id_statut2 == 3) {
            $docList->commentaire_motif2 = $request->commentaire_motif2 ?? 'سبب غير محدد';
        } else {
            $docList->commentaire_motif2 = null;
        }

        $docList->save();

        if (!$user || empty($user->email)) {
            \Log::warning("Aucun utilisateur avec email trouvé pour le document ID: {$id_doc_list}");
            return redirect()->back()->with('success', 'تم تحديث الحالة بنجاح (بدون إشعار)');
        }

        if ($request->id_statut2 == 1) {
            \Mail::to($user->email)->send(new Statut2DocumentChanged($docList));
            $user->notify(new Statut2DocumentNotification($docList, 1));
        } elseif ($request->id_statut2 == 3) {
            \Mail::to($user->email)->send(new Statut2DocumentChanged($docList));
            $user->notify(new Statut2DocumentNotification($docList, 3, $docList->commentaire_motif2));
        } else {
            $user->notify(new Statut2DocumentNotification($docList, $request->id_statut2));
        }

        return redirect()
            ->route('admin.doc_fin2.index')
            ->with('success', 'تم تحديث حالة الوثيقة بنجاح.');
    }


    public function destroy($id_doc_list)
    {
        $docList = DocumentsFinancementList::with('documents')->findOrFail($id_doc_list);

        foreach ($docList->documents as $doc) {
            if ($doc->file && \Storage::disk('public')->exists($doc->file)) {
                \Storage::disk('public')->delete($doc->file);
            }
            $doc->delete();
        }

        $docList->delete();

        return redirect()
            ->route('admin.doc_fin2.index')
            ->with('success', 'Le document de financement a été supprimé avec succès !');
    }

}
