<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DescGouvr;
use App\Models\Gouvernorat;
use Illuminate\Support\Facades\Auth;

class DescGouvrController extends Controller
{
    public function index(Request $request)
{
    $search = trim((string) $request->input('q', ''));

    // Bloquer les recherches vides ou contenant uniquement des %, _, ou espaces
    if ($search === '' || preg_match('/^[\s%_]+$/', $search)) {
        $search = null;
    }

    $query = DescGouvr::with(['gouvernorat', 'utilisateur'])
                      ->orderBy('id_desc', 'desc');

    if ($search) {
        $words = preg_split('/\s+/', $search);

        $query->where(function ($q) use ($words) {
            foreach ($words as $word) {
                // Échapper % et _ pour LIKE
                $word = str_replace(['\\', '%', '_'], ['\\\\', '\\%', '\\_'], $word);

                $q->whereHas('gouvernorat', function($q2) use ($word) {
                    $q2->where('nom_ar', 'like', "%{$word}%")
                       ->orWhere('nom_fr', 'like', "%{$word}%")
                       ->orWhere('nom_en', 'like', "%{$word}%");
                });
            }
        });
    }

    $desc_gouvr = $query->paginate(10)->withQueryString();

    return view('backoffice.desc_gouvr.index', compact('desc_gouvr', 'search'));
}


    public function create()
    {
        $gouvernorats = Gouvernorat::all();

        return view('backoffice.desc_gouvr.create', compact('gouvernorats'));
    }
    
    public function store(Request $request)
    {
		    $imageRules = 'required|image|mimes:jpg,png,jpeg,webp|max:4096';

        $request->validate([

			'id_gouv'   => 'required|exists:tp_gouvernorat,id_gouver',
			'image_gouv' => $imageRules,
			'image1' => $imageRules,
			'image2' => $imageRules,
			'image3' => $imageRules,
			'desc1'      => 'required|string',
			'desc1_fr'   => 'required|string',
			'desc1_en'   => 'required|string',

			'desc2'      => 'required|string',
			'desc2_fr'   => 'required|string',
			'desc2_en'   => 'required|string',

			'desc3'      => 'required|string',
			'desc3_fr'   => 'required|string',
			'desc3_en'   => 'required|string',

		], [

			'id_gouv.required'     => 'الرجاء اختيار الولاية',
			'image_gouv.required'  => 'الرجاء إضافة صورة الولاية',

			'desc1.required'       => 'الرجاء إدخال الوصف الأول بالعربية',
			'desc1_fr.required'    => 'الرجاء إدخال الوصف الأول بالفرنسية',
			'desc1_en.required'    => 'الرجاء إدخال الوصف الأول بالإنجليزية',
			'image1.required'      => 'الرجاء إضافة الصورة الأولى',

			'desc2.required'       => 'الرجاء إدخال الوصف الثاني بالعربية',
			'desc2_fr.required'    => 'الرجاء إدخال الوصف الثاني بالفرنسية',
			'desc2_en.required'    => 'الرجاء إدخال الوصف الثاني بالإنجليزية',
			'image2.required'      => 'الرجاء إضافة الصورة الثانية',

			'desc3.required'       => 'الرجاء إدخال الوصف الثالث بالعربية',
			'desc3_fr.required'    => 'الرجاء إدخال الوصف الثالث بالفرنسية',
			'desc3_en.required'    => 'الرجاء إدخال الوصف الثالث بالإنجليزية',
			'image3.required'      => 'الرجاء إضافة الصورة الثالثة',

			'id_gouv.exists'       => 'الولاية المختارة غير موجودة',

			'image_gouv.image' => 'يجب أن يكون الملف صورة',
			'image_gouv.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
			'image_gouv.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

			'image1.image' => 'يجب أن يكون الملف صورة',
			'image1.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
			'image1.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

			'image2.image' => 'يجب أن يكون الملف صورة',
			'image2.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
			'image2.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

			'image3.image' => 'يجب أن يكون الملف صورة',
			'image3.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
			'image3.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

		]);
        $desc = new DescGouvr();
        $desc->id_gouv = $request->id_gouv;
        $desc->id_user = Auth::id(); 

        $desc->desc1 = $request->desc1;
        $desc->desc1_fr = $request->desc1_fr;
        $desc->desc1_en = $request->desc1_en;
        
        $desc->desc2 = $request->desc2;
        $desc->desc2_fr = $request->desc2_fr;
        $desc->desc2_en = $request->desc2_en;

        $desc->desc3 = $request->desc3;
        $desc->desc3_fr = $request->desc3_fr;
        $desc->desc3_en = $request->desc3_en;

        

		foreach(['image_gouv','image1','image2','image3'] as $img){
				if($request->hasFile($img)){
					$desc->$img = file_get_contents($request->file($img));
				}
			}
	
        $desc->save();

        return redirect()
            ->route('desc_gouvr.index')
            ->with('success', 'تمت إضافة وصف الولاية بنجاح');
    }

        public function edit(DescGouvr $desc_gouvr)
    {
        $gouvernorats = Gouvernorat::all();

        return view('backoffice.desc_gouvr.edit', compact('desc_gouvr', 'gouvernorats'));
    }

    public function update(Request $request, DescGouvr $desc_gouvr)
{
    $imageRules = 'image|mimes:jpg,png,jpeg,webp|max:4096';
    $request->validate([

        'id_gouv'   => 'required|exists:tp_gouvernorat,id_gouver',

        // images non obligatoires en update
        'image_gouv' => "sometimes|$imageRules",

        'desc1'      => 'required|string',
        'desc1_fr'   => 'required|string',
        'desc1_en'   => 'required|string',
        'image1' => "sometimes|$imageRules",
		
        'desc2'      => 'required|string',
        'desc2_fr'   => 'required|string',
        'desc2_en'   => 'required|string',
        'image2'     => "sometimes|$imageRules",

        'desc3'      => 'required|string',
        'desc3_fr'   => 'required|string',
        'desc3_en'   => 'required|string',
        'image3' => "sometimes|$imageRules",

    ], [

        'id_gouv.required' => 'الرجاء اختيار الولاية',
        'id_gouv.exists'   => 'الولاية المختارة غير موجودة',

        'desc1.required'    => 'الرجاء إدخال الوصف الأول بالعربية',
        'desc1_fr.required' => 'الرجاء إدخال الوصف الأول بالفرنسية',
        'desc1_en.required' => 'الرجاء إدخال الوصف الأول بالإنجليزية',

        'desc2.required'    => 'الرجاء إدخال الوصف الثاني بالعربية',
        'desc2_fr.required' => 'الرجاء إدخال الوصف الثاني بالفرنسية',
        'desc2_en.required' => 'الرجاء إدخال الوصف الثاني بالإنجليزية',

        'desc3.required'    => 'الرجاء إدخال الوصف الثالث بالعربية',
        'desc3_fr.required' => 'الرجاء إدخال الوصف الثالث بالفرنسية',
        'desc3_en.required' => 'الرجاء إدخال الوصف الثالث بالإنجليزية',

        // Messages d’erreur pour les images
        'image_gouv.image' => 'يجب أن يكون الملف صورة',
        'image_gouv.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
        'image_gouv.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

        'image1.image' => 'يجب أن يكون الملف صورة',
        'image1.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
        'image1.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

        'image2.image' => 'يجب أن يكون الملف صورة',
        'image2.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
        'image2.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',

        'image3.image' => 'يجب أن يكون الملف صورة',
        'image3.mimes' => 'يجب أن تكون الصورة بصيغة jpg أو png أو jpeg أو webp',
        'image3.max'   => 'حجم الصورة يجب ألا يتجاوز 4 ميغابايت',
    ]);

    // Champs texte
    $desc_gouvr->id_gouv   = $request->id_gouv;

    $desc_gouvr->desc1     = $request->desc1;
    $desc_gouvr->desc1_fr  = $request->desc1_fr;
    $desc_gouvr->desc1_en  = $request->desc1_en;

    $desc_gouvr->desc2     = $request->desc2;
    $desc_gouvr->desc2_fr  = $request->desc2_fr;
    $desc_gouvr->desc2_en  = $request->desc2_en;

    $desc_gouvr->desc3     = $request->desc3;
    $desc_gouvr->desc3_fr  = $request->desc3_fr;
    $desc_gouvr->desc3_en  = $request->desc3_en;

    // Gestion des images
    foreach(['image_gouv','image1','image2','image3'] as $img){
        if($request->hasFile($img)){
            $desc_gouvr->$img = file_get_contents($request->file($img));
        }
    }

    $desc_gouvr->save();

    return redirect()
        ->route('desc_gouvr.index')
        ->with('success', 'تم تحديث وصف الولاية بنجاح');
}


    public function destroy(DescGouvr $desc_gouvr)
    {
        foreach(['image_gouv','image1','image2','image3'] as $img){
            if($desc_gouvr->$img){
                \Storage::disk('public')->delete($desc_gouvr->$img);
            }
        }

        $desc_gouvr->delete();

        return redirect()->route('desc_gouvr.index')
                        ->with('success','تم حذف الوصف بنجاح');
    }
}
