<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Immobilier;
use App\Models\InstitutionPriveJeunesse;
use App\Models\ProjetDivertissementJeuneEnfant;
use App\Models\InvestissementSport;
use App\Models\DebutActivite;
use App\Models\ActiviteJeuneEnfant;
use App\Models\Reservation;
use App\Models\Auberge;
use App\Models\DemandeManifestation;
use App\Models\DocumentsFinancementList;
use App\Models\Concours;
use App\Models\Candidate;
use App\Models\Gouvernorat;
use App\Models\Delegation;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        if (!auth()->check()) {
            return redirect()->route('admin');
        }
        $userRoleId = auth()->user()->roles->first()->id_roles ?? null;

        // ========== RÉCUPÉRATION DES FILTRES ==========
        $periode = $request->get('periode', 'all'); // all, today, week, month, 3months, 6months, year, custom
        $gouvernoratId = $request->get('gouvernorat_id', 'all');
        $delegationId = $request->get('delegation_id', 'all');
        $statutFilter = $request->get('statut', 'all'); // all, en_cours, accepte, refuse
        $dateDebut = $request->get('date_debut');
        $dateFin = $request->get('date_fin');

        // Calculer les dates selon la période
        $dateStart = null;
        $dateEnd = Carbon::now();

        switch ($periode) {
            case 'today':
                $dateStart = Carbon::today();
                break;
            case 'week':
                $dateStart = Carbon::now()->subWeek();
                break;
            case 'month':
                $dateStart = Carbon::now()->subMonth();
                break;
            case '3months':
                $dateStart = Carbon::now()->subMonths(3);
                break;
            case '6months':
                $dateStart = Carbon::now()->subMonths(6);
                break;
            case 'year':
                $dateStart = Carbon::now()->subYear();
                break;
            case 'custom':
                if ($dateDebut) $dateStart = Carbon::parse($dateDebut);
                if ($dateFin) $dateEnd = Carbon::parse($dateFin);
                break;
        }

        $gouvernorats = Gouvernorat::orderBy('nom_fr')->get();
        
        if ($gouvernoratId !== 'all') {
            $delegations = Delegation::where('gouver_id', $gouvernoratId)
                ->orderBy('nom_fr')
                ->get();
        } else {
            $delegations = collect(); 
        }

        $userRoleId = auth()->user()->roles->first()->id_roles ?? null;

        // ========== KPI INVESTISSEMENT ==========
        
        // 1. Salles de Sport (id_type_formulaire = 1)
        $queryBase = Immobilier::where('id_type_formulaire', 1);
        
        // Appliquer filtre date
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        
        // Appliquer filtre gouvernorat
        if ($gouvernoratId !== 'all') {
            $queryBase = $queryBase->where('gouvernorat_id', $gouvernoratId);
        }
        
        // Appliquer filtre délégation
        if ($delegationId !== 'all') {
            $queryBase = $queryBase->where('delegation_id', $delegationId);
        }
        
        $sallesSport = [
            'accepte' => (clone $queryBase)->where('id_statut', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $sallesSport['en_cours'] = $sallesSport['total'] - $sallesSport['accepte'] - $sallesSport['refuse'];
        
        // Appliquer filtre statut
        if ($statutFilter !== 'all') {
            $sallesSport = $this->applyStatutFilter($sallesSport, $statutFilter);
        }

        // 2. Début d'Activité (Salles de Sport)
        $queryBase = DebutActivite::query();
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $debutActivite = [
            'accepte' => (clone $queryBase)->where('id_statut', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $debutActivite['en_cours'] = $debutActivite['total'] - $debutActivite['accepte'] - $debutActivite['refuse'];
        if ($statutFilter !== 'all') {
            $debutActivite = $this->applyStatutFilter($debutActivite, $statutFilter);
        }

        // 3. Jeunesse - Institutions Privées (formulaire 19)
        $queryBase = InstitutionPriveJeunesse::query();
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $jeunesseInstitutions = [
            'accepte' => (clone $queryBase)->where('id_statut', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $jeunesseInstitutions['en_cours'] = $jeunesseInstitutions['total'] - $jeunesseInstitutions['accepte'] - $jeunesseInstitutions['refuse'];
        if ($statutFilter !== 'all') {
            $jeunesseInstitutions = $this->applyStatutFilter($jeunesseInstitutions, $statutFilter);
        }

        // 4. Jeunesse - Activités Jeune Enfant (formulaire 21)
        $queryBase = ActiviteJeuneEnfant::query();
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        if ($gouvernoratId !== 'all') {
            $queryBase = $queryBase->where('id_gouvernorat', $gouvernoratId);
        }
        if ($delegationId !== 'all') {
            $queryBase = $queryBase->where('delegation_id', $delegationId);
        }
        $jeunesseActivites = [
            'accepte' => (clone $queryBase)->where('id_statut', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $jeunesseActivites['en_cours'] = $jeunesseActivites['total'] - $jeunesseActivites['accepte'] - $jeunesseActivites['refuse'];
        if ($statutFilter !== 'all') {
            $jeunesseActivites = $this->applyStatutFilter($jeunesseActivites, $statutFilter);
        }

        // 5. Jeune Enfant - Projets de Divertissement (formulaire 3)
        $queryBase = ProjetDivertissementJeuneEnfant::query();
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $jeuneEnfant = [
            'accepte' => (clone $queryBase)->where('id_statut', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $jeuneEnfant['en_cours'] = $jeuneEnfant['total'] - $jeuneEnfant['accepte'] - $jeuneEnfant['refuse'];
        if ($statutFilter !== 'all') {
            $jeuneEnfant = $this->applyStatutFilter($jeuneEnfant, $statutFilter);
        }

        // 6. Formation & Stage - Investissement Sportif (formulaire 5)
        $queryBase = InvestissementSport::query();
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $formationStage = [
            'accepte' => (clone $queryBase)->where('id_statut', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $formationStage['en_cours'] = $formationStage['total'] - $formationStage['accepte'] - $formationStage['refuse'];
        if ($statutFilter !== 'all') {
            $formationStage = $this->applyStatutFilter($formationStage, $statutFilter);
        }

        // 7. Réservations d'Auberges
        $queryBase = Reservation::query();
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $reservations = [
            'accepte' => (clone $queryBase)->where('statut_id', 1)->count(),
            'refuse' => (clone $queryBase)->where('statut_id', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $reservations['en_cours'] = $reservations['total'] - $reservations['accepte'] - $reservations['refuse'];
        if ($statutFilter !== 'all') {
            $reservations = $this->applyStatutFilter($reservations, $statutFilter);
        }

        // 8. Auberges et Centres d'Hébergement
        $queryBase = Auberge::query();
        // Note: La table auberge n'a pas de timestamps, donc pas de filtre par date
        if ($gouvernoratId !== 'all') {
            $queryBase = $queryBase->where('gouver_id', $gouvernoratId);
        }
        $auberges = [
            'total' => (clone $queryBase)->count(),
            'epa' => (clone $queryBase)->where('epa', 'EPA')->count(),
            'non_epa' => (clone $queryBase)->where('epa', 'Non EPA')->count(),
            'capacite_totale' => (clone $queryBase)->sum('capacite_batiment'),
        ];

        // 9. Financements (DocumentsFinancementList)
        $queryBase = DocumentsFinancementList::where('brouillon', false);
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $financements = [
            'accepte' => (clone $queryBase)->where('id_statut1', 1)->count(),
            'refuse' => (clone $queryBase)->where('id_statut1', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $financements['en_cours'] = $financements['total'] - $financements['accepte'] - $financements['refuse'];
        if ($statutFilter !== 'all') {
            $financements = $this->applyStatutFilter($financements, $statutFilter);
        }

        // 10. Manifestations Sportives Nationales (type_formulaire_id = 12)
        $queryBase = DemandeManifestation::where('type_formulaire_id', 12);
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $manifestationsNationales = [
            'accepte' => (clone $queryBase)->where('statut_id', 1)->count(),
            'refuse' => (clone $queryBase)->where('statut_id', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $manifestationsNationales['en_cours'] = $manifestationsNationales['total'] - $manifestationsNationales['accepte'] - $manifestationsNationales['refuse'];
        if ($statutFilter !== 'all') {
            $manifestationsNationales = $this->applyStatutFilter($manifestationsNationales, $statutFilter);
        }

        // 11. Manifestations Sportives Internationales (type_formulaire_id = 13)
        $queryBase = DemandeManifestation::where('type_formulaire_id', 13);
        if ($dateStart) {
            $queryBase = $queryBase->whereBetween('created_at', [$dateStart, $dateEnd]);
        }
        $manifestationsInternationales = [
            'accepte' => (clone $queryBase)->where('statut_id', 1)->count(),
            'refuse' => (clone $queryBase)->where('statut_id', 3)->count(),
            'total' => (clone $queryBase)->count(),
        ];
        $manifestationsInternationales['en_cours'] = $manifestationsInternationales['total'] - $manifestationsInternationales['accepte'] - $manifestationsInternationales['refuse'];
        if ($statutFilter !== 'all') {
            $manifestationsInternationales = $this->applyStatutFilter($manifestationsInternationales, $statutFilter);
        }
		
		
			$user = auth()->user();
			
        
			$totaux = [
				'en_cours' => $sallesSport['en_cours'] + $debutActivite['en_cours'] + 
							 $jeunesseInstitutions['en_cours'] + $jeunesseActivites['en_cours'] +
							 $jeuneEnfant['en_cours'] + $formationStage['en_cours'],
				'accepte' => $sallesSport['accepte'] + $debutActivite['accepte'] + 
							$jeunesseInstitutions['accepte'] + $jeunesseActivites['accepte'] +
							$jeuneEnfant['accepte'] + $formationStage['accepte'],
				'refuse' => $sallesSport['refuse'] + $debutActivite['refuse'] + 
						   $jeunesseInstitutions['refuse'] + $jeunesseActivites['refuse'] +
						   $jeuneEnfant['refuse'] + $formationStage['refuse'],
				'total' => $sallesSport['total'] + $debutActivite['total'] + 
						  $jeunesseInstitutions['total'] + $jeunesseActivites['total'] +
						  $jeuneEnfant['total'] + $formationStage['total'],
			];
	
	
	

/*$filterByGouv = $user->roles->pluck('id_roles')->contains(8) && $user->gouvernorat;
$gouvId = $user->gouvernorat->id_gouver ?? null;
function applyFilters($query, $filterByGouv, $gouvId, $dateStart, $dateEnd, $relationGouv = null) {
    if ($filterByGouv && $gouvId) {
        if ($relationGouv) {
            $query->whereHas($relationGouv, function($q) use ($gouvId) {
                $q->where('gouvernorat_id', $gouvId);
            });
        } else {
            $query->where('gouvernorat_id', $gouvId);
        }
    }
    if ($dateStart && $dateEnd) {
        $query->whereBetween('created_at', [$dateStart, $dateEnd]);
    }
    return $query;
}

$sallesSportData = applyFilters(Immobilier::query(), $filterByGouv, $gouvId, $dateStart, $dateEnd)->get();
$debutActiviteData = applyFilters(DebutActivite::query(), $filterByGouv, $gouvId, $dateStart, $dateEnd, 'immobilier')->get();
$jeunesseInstitutionsData = applyFilters(InstitutionPriveJeunesse::query(), $filterByGouv, $gouvId, $dateStart, $dateEnd)->get();
$jeunesseActivitesData = applyFilters(ActiviteJeuneEnfant::query(), $filterByGouv, $gouvId, $dateStart, $dateEnd)->get();
$jeuneEnfantData = applyFilters(ProjetDivertissementJeuneEnfant::query(), $filterByGouv, $gouvId, $dateStart, $dateEnd)->get();
$formationStageData = applyFilters(InvestissementSport::query(), $filterByGouv, $gouvId, $dateStart, $dateEnd)->get();

$totaux = [
    'en_cours' => $sallesSportData->where('status', 'en_cours')->count() +
                  $debutActiviteData->where('status', 'en_cours')->count() +
                  $jeunesseInstitutionsData->where('status', 'en_cours')->count() +
                  $jeunesseActivitesData->where('status', 'en_cours')->count() +
                  $jeuneEnfantData->where('status', 'en_cours')->count() +
                  $formationStageData->where('status', 'en_cours')->count(),

    'accepte' => $sallesSportData->where('status', 'accepte')->count() +
                 $debutActiviteData->where('status', 'accepte')->count() +
                 $jeunesseInstitutionsData->where('status', 'accepte')->count() +
                 $jeunesseActivitesData->where('status', 'accepte')->count() +
                 $jeuneEnfantData->where('status', 'accepte')->count() +
                 $formationStageData->where('status', 'accepte')->count(),

    'refuse' => $sallesSportData->where('status', 'refuse')->count() +
                $debutActiviteData->where('status', 'refuse')->count() +
                $jeunesseInstitutionsData->where('status', 'refuse')->count() +
                $jeunesseActivitesData->where('status', 'refuse')->count() +
                $jeuneEnfantData->where('status', 'refuse')->count() +
                $formationStageData->where('status', 'refuse')->count(),

    'total' => $sallesSportData->count() +
               $debutActiviteData->count() +
               $jeunesseInstitutionsData->count() +
               $jeunesseActivitesData->count() +
               $jeuneEnfantData->count() +
               $formationStageData->count(),
];
*/

			

        // Totaux globaux pour les financements
        $totauxFinancements = [
            'en_cours' => $financements['en_cours'],
            'accepte' => $financements['accepte'],
            'refuse' => $financements['refuse'],
            'total' => $financements['total'],
        ];

        // Totaux globaux pour les manifestations
        $totauxManifestations = [
            'en_cours' => $manifestationsNationales['en_cours'] + $manifestationsInternationales['en_cours'],
            'accepte' => $manifestationsNationales['accepte'] + $manifestationsInternationales['accepte'],
            'refuse' => $manifestationsNationales['refuse'] + $manifestationsInternationales['refuse'],
            'total' => $manifestationsNationales['total'] + $manifestationsInternationales['total'],
        ];

        

        

        if ($user->roles->pluck('id_roles')->contains(7) && $user->auberge) {
            $query = Reservation::where('id_auberge', $user->auberge->id); 
            if ($dateStart) {
                $query->whereBetween('created_at', [$dateStart, $dateEnd]);
            }
            $totauxReservations = [
                'accepte' => (clone $query)->where('statut_id', 1)->count(),
                'refuse' => (clone $query)->where('statut_id', 3)->count(),
                'en_cours' => (clone $query)->count() - (clone $query)->where('statut_id', 1)->count() - (clone $query)->where('statut_id', 3)->count(),
                'total' => (clone $query)->count(),
                'capacite_totale' => $user->auberge->capacite_batiment,
            ];
        } else {
                $totauxReservations = [
                'accepte' => $reservations['accepte'],
                'refuse' => $reservations['refuse'],
                'en_cours' => $reservations['en_cours'],
                'total' => $reservations['total'],
                'total_auberges' => $auberges['total'],
                'capacite_totale' => $auberges['capacite_totale'],
            ];
        }

        // 12. Concours
        $concours = [
            'total_concours' => Concours::count(),
            'concours_publies' => Concours::where('etat', 'published')->count(),
            'concours_clotures' => Concours::where('etat', 'closed')->count(),
            'total_candidats' => Candidate::count(),
            'en_cours' => Candidate::where('etat', 'en_cours')->count(),
            'accepte_primaire' => Candidate::where('etat', 'acceptation_primaire')->count(),
            'accepte_definitif' => Candidate::where('etat', 'acceptation_definitif')->count(),
            'refuse' => Candidate::where('etat', 'refuse')->count(),
        ];

        // Totaux globaux pour les concours
        $totauxConcours = [
            'total_concours' => $concours['total_concours'],
            'concours_publies' => $concours['concours_publies'],
            'total_candidats' => $concours['total_candidats'],
            'en_cours' => $concours['en_cours'],
            'accepte_primaire' => $concours['accepte_primaire'],
            'accepte_definitif' => $concours['accepte_definitif'],
            'refuse' => $concours['refuse'],
        ];

        return view('backoffice.dashboard-content', compact(
            'userRoleId',
            'sallesSport',
            'debutActivite',
            'jeunesseInstitutions',
            'jeunesseActivites',
            'jeuneEnfant',
            'formationStage',
            'reservations',
            'auberges',
            'financements',
            'manifestationsNationales',
            'manifestationsInternationales',
            'concours',
            'totaux',
            'totauxFinancements',
            'totauxManifestations',
            'totauxReservations',
            'totauxConcours',
            'gouvernorats',
            'delegations',
            'periode',
            'gouvernoratId',
            'delegationId',
            'statutFilter',
            'dateDebut',
            'dateFin'
        ));
    }

    
    private function applyStatutFilter($kpi, $statutFilter)
    {
        switch ($statutFilter) {
            case 'en_cours':
                return [
                    'en_cours' => $kpi['en_cours'],
                    'accepte' => 0,
                    'refuse' => 0,
                    'total' => $kpi['en_cours'],
                ];
            case 'accepte':
                return [
                    'en_cours' => 0,
                    'accepte' => $kpi['accepte'],
                    'refuse' => 0,
                    'total' => $kpi['accepte'],
                ];
            case 'refuse':
                return [
                    'en_cours' => 0,
                    'accepte' => 0,
                    'refuse' => $kpi['refuse'],
                    'total' => $kpi['refuse'],
                ];
            default:
                return $kpi;
        }
    }

   
    public function getDelegations($gouvernoratId)
    {
        $delegations = Delegation::where('gouver_id', $gouvernoratId)
            ->orderBy('nom_fr')
            ->get(['id_delegation', 'nom_ar', 'nom_fr']);
        
        return response()->json($delegations);
    }
}
