<?php

namespace App\Http\Controllers;

use App\Models\Avis;
use Illuminate\Http\Request;

class AvisController extends Controller
{
    public function index()
    {
        $avis = Avis::with(['user', 'auberge'])->orderBy('date_avis', 'desc')->paginate(10);
        return view('backoffice.auberges.avis.index', compact('avis'));
    }

    public function show($id)
    {
        $avis = Avis::with(['user', 'auberge'])->findOrFail($id);
        return view('backoffice.auberges.avis.show', compact('avis'));
    }

    public function destroy($id)
    {
        $avis = Avis::findOrFail($id);
        $avis->delete();

        return redirect()->route('avis.index')->with('success', 'تم حذف التقييم بنجاح.');
    }
}
