<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Models\Utilisateur;

class ResetPasswordController extends Controller
{
    public function showResetForm(Request $request, $token)
    {
        return view('FrontOffice.Auth.password.reset-password', [
            'token' => $token,
            'email' => $request->email
        ]);
    }

    /*public function reset(Request $request)
    {
        $request->validate([
            'token' => 'required',
            'email' => 'required|email|unique:utilisateur,email',
            'mdp' => 'required|string|min:6|confirmed',
        ], [
                'mdp.required' => ' الرجاء إدخال كلمة المرور',
                'mdp.min' => 'كلمة المرور يجب أن تحتوي على الأقل 6 حروف',
                'mdp.confirmed' => ' تأكيد كلمة المرور غير متطابق',
        ]);

        $record = DB::table('password_resets')
                    ->where('email', $request->email)
                    ->where('token', $request->token)
                    ->first();

        if (!$record) {
            return back()->withErrors(['email' => 'الرابط غير صالح أو انتهت صلاحيته.']);
        }

        $user = Utilisateur::where('email', $request->email)->first();
        $user->mdp = Hash::make($request->password);
        $user->save();

        DB::table('password_resets')->where('email', $request->email)->delete();

        return redirect()->route('login')->with('success', 'تم إعادة تعيين كلمة المرور بنجاح، يمكنك تسجيل الدخول الآن.');
    }*/

    public function reset(Request $request)
    {
        $request->validate([
            'mdp' => 'required|string|min:6|confirmed',
        ], [
            'mdp.required'  => 'الرجاء إدخال كلمة المرور',
            'mdp.min'       => ' كلمة المرور يجب أن تحتوي على الأقل 6 حروف',
            'mdp.confirmed' => ' تأكيد كلمة المرور غير متطابق',
        ]);

        $record = DB::table('password_resets')
                    ->where('email', $request->email)
                    ->where('token', $request->token)
                    ->first();

        if (!$record) {
            return back()->withErrors([
                'email' => ' الرابط غير صالح أو انتهت صلاحيته.'
            ]);
        }

        $user = Utilisateur::where('email', $request->email)->first();
        if (!$user) {
            return back()->withErrors([
                'email' => 'هذا البريد الإلكتروني غير موجود.'
            ]);
        }

        $user->mdp = Hash::make($request->mdp);
        $user->save();

        DB::table('password_resets')->where('email', $request->email)->delete();

        return redirect()->route('login')->with('success', '✅ تم إعادة تعيين كلمة المرور بنجاح، يمكنك تسجيل الدخول الآن.');
    }

}
