<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MilieuAuberge;
use App\Models\Auberge;
use App\Models\Gouvernorat;
use App\Models\TpSportsAuberge;
use App\Models\TpServiceAuberge;
use App\Models\Delegation;
use App\Models\RestaurationAuberge;
use App\Models\TypeChambre;
use App\Models\ChambreTente;
use App\Models\EspaceAuberge;
use App\Models\TerrainSportifAuberge;
use App\Models\ServiceAuberge;

class AubergesController extends Controller
{
    /*public function index()
	{
		$auberges = Auberge::with(['gouvernorat', 'delegation'])
							->paginate(10); 

		return view('backoffice.auberges.creation_centre.index', compact('auberges'));
	}*/
	
	public function index(Request $request)
	{
		$search = (string) $request->input('q', '');

		// Supprimer les espaces en début/fin
		$search = trim($search);

		// Bloquer les recherches vides, uniquement des %, uniquement des espaces, ou combinaison de % et espaces
		if ($search === '' || preg_match('/^[\s%]+$/', $search)) {
			$search = null;
		}

		$query = Auberge::with(['gouvernorat', 'delegation']);

		if ($search) {
			// Découper la recherche par mots séparés par espace
			$words = preg_split('/\s+/', $search);

			$query->where(function ($q) use ($words) {
				foreach ($words as $word) {
					// Échapper % et _ pour LIKE
					$word = str_replace(['\\', '%', '_'], ['\\\\', '\\%', '\\_'], $word);

					$q->where(function ($qq) use ($word) {
						$qq->where('nom_ar', 'like', "%{$word}%")
						   ->orWhere('nom_fr', 'like', "%{$word}%")
						   ->orWhere('nom_en', 'like', "%{$word}%")
						   ->orWhere('nom_directeur', 'like', "%{$word}%")
						   ->orWhere('adresse', 'like', "%{$word}%");
					});
				}
			});
		}

		$auberges = $query->orderBy('nom_ar')->paginate(10)->withQueryString();

		return view('backoffice.auberges.creation_centre.index', compact('auberges', 'search'));
	}


	
	/*public function index()
	{
		$user = Auth::user(); 

		$user->roles->pluck('id_roles')->contains(7)) {
			$reservations = Reservation::with(['auberge', 'utilisateur'])
				->where('auberge_id', $user->auberge_id)
				->paginate(10);
		} else {
			$reservations = Reservation::with(['auberge', 'utilisateur'])
				->paginate(10);
		}

		return view('backoffice.reservations.index', compact('reservations'));
	}*/
	
	




    public function create()
    {
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.create', compact('milieux','gouvernorats','sports','services','typesChambres'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nom_ar' => 'required|string|max:100',
            'nom_fr' => 'required|string|max:100',
            'nom_en' => 'required|string|max:100',
            'contact_tel' => 'required|string|max:50',
			'fax' => 'required|string|max:12',
            'contact_email' => 'required|email|max:255',
            'gouvernorat_id' => 'required|integer',
            'delegation_id' => 'required|integer',
            'epa' => 'required|string|in:EPA,Non EPA',
            'id_milieu_auberge' => 'required|integer',
            'adresse' => 'required|string|max:255',
			'code_postal' => 'required|string|max:20',
            'nom_directeur' => 'required|string|max:255',
            'tel_directeur' => 'required|string|max:50',
            'espace_boisson' => 'required|boolean',
            'piscine' => 'required|boolean',
            
            'cuisine_fonctionnelle' => 'sometimes|boolean',
            'capacite_batiment' => 'required|integer',
            'nb_chambres' => 'required|integer',
            'nb_chambres_single' => 'nullable|integer',
            'nb_chambres_double' => 'nullable|integer',
            'nb_chambres_triple' => 'nullable|integer',
            'nb_chambres_quadra' => 'nullable|integer',
            'nb_chambres_plus' => 'nullable|integer',
            'nb_salles_de_bain' => 'nullable|integer',
            'nb_salles_de_bain_comm' => 'nullable|integer',
            'nb_chambres_tv' => 'nullable|integer',
            'nb_chambres_clim' => 'nullable|integer',
            'nb_chambres_frigo' => 'nullable|integer',
            'capacite_tentes' => 'nullable|integer',
            'lieux_culturels' => 'nullable|string',
            'autres_services' => 'nullable|string',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            'description_ar' => 'required|string|max:2000',
            'description_fr' => 'required|string|max:2000',
            'description_en' => 'required|string|max:2000',
            'latitude' => 'required|string|max:50',
            'longitude' => 'required|string|max:50',
            'prix_lit' => 'nullable|numeric|min:0',
			'restaurations' => 'nullable|array|min:1',
            'restaurations.*.nom_fr' => 'nullable|string|max:255',
            'restaurations.*.nom_ar' => 'nullable|string|max:255',
            'restaurations.*.nom_en' => 'nullable|string|max:255',
            'restaurations.*.description_fr' => 'nullable|string',
            'restaurations.*.description_ar' => 'nullable|string',
            'restaurations.*.description_en' => 'nullable|string',
            'restaurations.*.tarif' => 'nullable|numeric|min:0',
            'chambres' => 'nullable|array|min:1',
            'chambres.*.type_chambre_id' => 'required|integer|exists:tp_type_chambre,id_type',
            'chambres.*.capacite' => 'required|integer|min:1',
            'chambres.*.num_chambre' => 'required|string|max:11',

            'espaces' => 'nullable|array|min:1',
            'espaces.*.nom_ar' => 'nullable|string|max:150',
            'espaces.*.nom_fr' => 'nullable|string|max:150',
            'espaces.*.nom_en' => 'nullable|string|max:150',

            'terrains' => 'nullable|array|min:1',
            'terrains.*.nom_ar' => 'nullable|string|max:150',
            'terrains.*.nom_fr' => 'nullable|string|max:150',
            'terrains.*.nom_en' => 'nullable|string|max:150',

            'services_auberge' => 'nullable|array|min:1',
            'services_auberge.*.nom_ar' => 'nullable|string|max:150',
            'services_auberge.*.nom_fr' => 'nullable|string|max:150',
            'services_auberge.*.nom_en' => 'nullable|string|max:150',

			'x' => 'required|numeric',
			'y' => 'required|numeric',
             
        ],[
			'nom_ar.required' => 'الرجاء إدخال الاسم بالعربية.',
			'nom_fr.required' => 'الرجاء إدخال الاسم بالفرنسية.',
			'nom_en.required' => 'الرجاء إدخال الاسم بالإنجليزية.',

			'contact_tel.required' => 'الرجاء إدخال رقم الهاتف.',
			'fax.required' => 'الرجاء إدخال رقم الفاكس .',
			'contact_email.required' => 'الرجاء إدخال البريد الإلكتروني.',

			'gouvernorat_id.required' => 'الرجاء اختيار الولاية.',
			'delegation_id.required' => 'الرجاء اختيار المعتمدية.',

			'epa.required' => 'الرجاء تحديد الحالة (EPA أو Non EPA).',

			'id_milieu_auberge.required' => 'الرجاء اختيار وسط النزل.',

			'adresse.required' => 'الرجاء إدخال العنوان.',
			'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',

			'nom_directeur.required' => 'الرجاء إدخال اسم المدير.',
			'tel_directeur.required' => 'الرجاء إدخال رقم هاتف المدير.',

			'espace_boisson.required' => 'الرجاء تحديد توفر فضاء المشروبات.',
			'piscine.required' => 'الرجاء تحديد توفر المسبح.',

			'capacite_batiment.required' => 'الرجاء إدخال طاقة استيعاب المبنى.',

			'nb_chambres.required' => 'الرجاء إدخال عدد الغرف.',
		
			'image.required' => 'الرجاء تحميل صورة.',
			'image.image' => 'الملف يجب أن يكون صورة.',
			'image.mimes' => 'يجب أن تكون صيغة الصورة: jpeg أو png أو jpg أو gif أو webp.',
			'image.max' => 'حجم الصورة كبير جدًا، الحد الأقصى 2 ميغابايت.',

			'description_ar.required' => 'الرجاء إدخال الوصف بالعربية.',
			'description_fr.required' => 'الرجاء إدخال الوصف بالفرنسية.',
			'description_en.required' => 'الرجاء إدخال الوصف بالإنجليزية.',

			'latitude.required' => 'الرجاء إدخال خط العرض.',
			'longitude.required' => 'الرجاء إدخال خط الطول.',

			//'prix_lit.required' => 'الرجاء إدخال سعر السرير.',

			
			// Chambres
			'chambres.required' => 'الرجاء إضافة غرفة واحدة على الأقل.',
			'chambres.*.type_chambre_id.required' => 'الرجاء اختيار نوع الغرفة.',
			'chambres.*.capacite.required' => 'الرجاء إدخال طاقة الغرفة.',
			'chambres.*.num_chambre.required' => 'الرجاء إدخال رقم الغرفة.',

			'x.required' => 'الرجاء إدخال خط العرض.',
			'y.required' => 'الرجاء إدخال خط الطول.',
			
		]);

        $imagePath = null;

        $imageData = null;

        if ($request->hasFile('image')) {
            $imageData = file_get_contents($request->file('image')->getRealPath());
        }
        $auberge = Auberge::create([
            'nom_ar' => $request->nom_ar,
            'nom_fr' => $request->nom_fr,
            'nom_en' => $request->nom_en,
            'contact_tel' => $request->contact_tel,
            'contact_email' => $request->contact_email,
            'gouver_id' => $request->gouvernorat_id,
            'delegation_id' => $request->delegation_id,
            'epa' => $request->epa,
            'id_milieu_auberge' => $request->id_milieu_auberge,
            'fax' => $request->fax,
            'code_postal' => $request->code_postal,
            'adresse' => $request->adresse,
            'nom_directeur' => $request->nom_directeur,
            'tel_directeur' => $request->tel_directeur,
            'espace_boisson' => $request->has('espace_boisson') ? 1 : 0,
            'piscine' => $request->has('piscine') ? 1 : 0,
            
            'capacite_batiment' => $request->capacite_batiment,
            'nb_chambres' => $request->nb_chambres,
            'nb_chambres_single' => $request->nb_chambres_single,
            'nb_chambres_double' => $request->nb_chambres_double,
            'nb_chambres_triple' => $request->nb_chambres_triple,
            'nb_chambres_quadra' => $request->nb_chambres_quadra,
            'nb_chambres_plus' => $request->nb_chambres_plus,
            'nb_salles_de_bain' => $request->nb_salles_de_bain,
            'nb_salles_de_bain_comm' => $request->nb_salles_de_bain_comm,
            'nb_chambres_tv' => $request->nb_chambres_tv,
            'nb_chambres_clim' => $request->nb_chambres_clim,
            'nb_chambres_frigo' => $request->nb_chambres_frigo,
            'capacite_tentes' => $request->capacite_tentes,
            'cuisine_fonct' => $request->has('cuisine_fonctionnelle') ? 1 : 0,
            'lieux_culturels' => $request->lieux_culturels,
            'autres_services' => $request->autres_services,
            'description_ar' => $request->description_ar,
            'description_fr' => $request->description_fr,
            'description_en' => $request->description_en,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'prix_lit'=> $request->prix_lit,
            'image' => $imageData,
			
			'x' => $request->x,
			'y' => $request->y,
			'map_link' => 'https://maps.google.com/?q='.$request->x.','.$request->y,
        ]);
        if ($request->has('restaurations')) {
            foreach ($request->restaurations as $restaurationData) {
                RestaurationAuberge::create([
                    'auberge_id' => $auberge->id,
                    'nom_fr' => $restaurationData['nom_fr'],
                    'nom_ar' => $restaurationData['nom_ar'],
                    'nom_en' => $restaurationData['nom_en'],
                    'description_fr' => $restaurationData['description_fr'] ?? null,
                    'description_ar' => $restaurationData['description_ar'] ?? null,
                    'description_en' => $restaurationData['description_en'] ?? null,
                    'tarif' => $restaurationData['tarif'],
                ]);
            }
        }
        if ($request->has('sports')) {
            $auberge->sports()->sync($request->sports);
        }
        if ($request->has('services')) {
            $auberge->services()->sync($request->services);
        }
        
        if ($request->has('chambres')) {
            foreach ($request->chambres as $chambreData) {
                ChambreTente::create([
                    'auberge_id' => $auberge->id,
                    'type_chambre_id' => $chambreData['type_chambre_id'],
                    'capacite' => $chambreData['capacite'],
                    'num_chambre' => $chambreData['num_chambre'],
                    'type' => 'chambre',
                ]);
            }
        }

        if ($request->has('espaces')) {
            foreach ($request->espaces as $espaceData) {
                EspaceAuberge::create([
                    'id_auberge' => $auberge->id,
                    'nom_ar' => $espaceData['nom_ar'],
                    'nom_fr' => $espaceData['nom_fr'],
                    'nom_en' => $espaceData['nom_en'],
                ]);
            }
        }

        if ($request->has('terrains')) {
            foreach ($request->terrains as $terrainData) {
                TerrainSportifAuberge::create([
                    'id_auberge' => $auberge->id,
                    'nom_ar' => $terrainData['nom_ar'],
                    'nom_fr' => $terrainData['nom_fr'],
                    'nom_en' => $terrainData['nom_en'],
                ]);
            }
        }

        if ($request->has('services_auberge')) {
            foreach ($request->services_auberge as $serviceData) {
                ServiceAuberge::create([
                    'id_auberge' => $auberge->id,
                    'nom_ar' => $serviceData['nom_ar'],
                    'nom_fr' => $serviceData['nom_fr'],
                    'nom_en' => $serviceData['nom_en'],
                ]);
            }
        }

        return redirect()->route('auberges.index')
                        ->with('success', 'تمت إضافة المركب أو مركز الإقامة بنجاح !');
    }

    public function edit($id)
    {
         $auberge = Auberge::with('espaces','terrains','services_auberge')->findOrFail($id);
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.edit', compact(
            'auberge','milieux','gouvernorats','sports','services','delegations','typesChambres'
        ));
    }
	
	public function edit2($id)
    {
         $auberge = Auberge::with('espaces','terrains','services_auberge')->findOrFail($id);
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.edit2', compact(
            'auberge','milieux','gouvernorats','sports','services','delegations','typesChambres'
        ));
    }

    public function update(Request $request, $id)
    {
        $auberge = Auberge::findOrFail($id);
        $request->validate([
            'nom_ar' => 'required|string|max:100',
            'nom_fr' => 'required|string|max:100',
            'nom_en' => 'required|string|max:100',
            'contact_tel' => 'required|string|max:50',
			'fax' => 'required|string|max:12',
            'contact_email' => 'required|email|max:255',
            'gouvernorat_id' => 'required|integer',
            'delegation_id' => 'required|integer',
            'epa' => 'required|string|in:EPA,Non EPA',
            'id_milieu_auberge' => 'required|integer',
            'adresse' => 'required|string|max:255',
			'code_postal' => 'required|string|max:20',
            'nom_directeur' => 'required|string|max:255',
            'tel_directeur' => 'required|string|max:50',
            'espace_boisson' => 'required|boolean',
            'piscine' => 'required|boolean',
            
            'cuisine_fonctionnelle' => 'sometimes|boolean',
            'capacite_batiment' => 'required|integer',
            'nb_chambres' => 'required|integer',
            'nb_chambres_single' => 'nullable|integer',
            'nb_chambres_double' => 'nullable|integer',
            'nb_chambres_triple' => 'nullable|integer',
            'nb_chambres_quadra' => 'nullable|integer',
            'nb_chambres_plus' => 'nullable|integer',
            'nb_salles_de_bain' => 'nullable|integer',
            'nb_salles_de_bain_comm' => 'nullable|integer',
            'nb_chambres_tv' => 'nullable|integer',
            'nb_chambres_clim' => 'nullable|integer',
            'nb_chambres_frigo' => 'nullable|integer',
            'capacite_tentes' => 'nullable|integer',
            'lieux_culturels' => 'nullable|string',
            'autres_services' => 'nullable|string',
            //'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
			'image' => $auberge->image ? 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048' : 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048',

            'description_ar' => 'required|string|max:2000',
            'description_fr' => 'required|string|max:2000',
            'description_en' => 'required|string|max:2000',
            'latitude' => 'required|string|max:50',
            'longitude' => 'required|string|max:50',
            'prix_lit' => 'nullable|numeric|min:0',
			'restaurations' => 'nullable|array|min:1',
            'restaurations.*.nom_fr' => 'nullable|string|max:255',
            'restaurations.*.nom_ar' => 'nullable|string|max:255',
            'restaurations.*.nom_en' => 'nullable|string|max:255',
            'restaurations.*.description_fr' => 'nullable|string',
            'restaurations.*.description_ar' => 'nullable|string',
            'restaurations.*.description_en' => 'nullable|string',
            'restaurations.*.tarif' => 'nullable|numeric|min:0',
            'chambres' => 'nullable|array|min:1',
            'chambres.*.type_chambre_id' => 'required|integer|exists:tp_type_chambre,id_type',
            'chambres.*.capacite' => 'required|integer|min:1',
            'chambres.*.num_chambre' => 'required|string|max:11',

            'espaces' => 'nullable|array|min:1',
            'espaces.*.nom_ar' => 'nullable|string|max:150',
            'espaces.*.nom_fr' => 'nullable|string|max:150',
            'espaces.*.nom_en' => 'nullable|string|max:150',

            'terrains' => 'nullable|array|min:1',
            'terrains.*.nom_ar' => 'nullable|string|max:150',
            'terrains.*.nom_fr' => 'nullable|string|max:150',
            'terrains.*.nom_en' => 'nullable|string|max:150',

            'services_auberge' => 'nullable|array|min:1',
            'services_auberge.*.nom_ar' => 'nullable|string|max:150',
            'services_auberge.*.nom_fr' => 'nullable|string|max:150',
            'services_auberge.*.nom_en' => 'nullable|string|max:150',
'x' => 'required|numeric',
			'y' => 'required|numeric',
              
              
        ],[
			'nom_ar.required' => 'الرجاء إدخال الاسم بالعربية.',
			'nom_fr.required' => 'الرجاء إدخال الاسم بالفرنسية.',
			'nom_en.required' => 'الرجاء إدخال الاسم بالإنجليزية.',

			'contact_tel.required' => 'الرجاء إدخال رقم الهاتف.',
			'fax.required' => 'الرجاء إدخال رقم الفاكس .',
			'contact_email.required' => 'الرجاء إدخال البريد الإلكتروني.',

			'gouvernorat_id.required' => 'الرجاء اختيار الولاية.',
			'delegation_id.required' => 'الرجاء اختيار المعتمدية.',

			'epa.required' => 'الرجاء تحديد الحالة (EPA أو Non EPA).',

			'id_milieu_auberge.required' => 'الرجاء اختيار وسط النزل.',

			'adresse.required' => 'الرجاء إدخال العنوان.',
			'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',

			'nom_directeur.required' => 'الرجاء إدخال اسم المدير.',
			'tel_directeur.required' => 'الرجاء إدخال رقم هاتف المدير.',

			'espace_boisson.required' => 'الرجاء تحديد توفر فضاء المشروبات.',
			'piscine.required' => 'الرجاء تحديد توفر المسبح.',

			'capacite_batiment.required' => 'الرجاء إدخال طاقة استيعاب المبنى.',

			'nb_chambres.required' => 'الرجاء إدخال عدد الغرف.',
		
			'image.required' => 'الرجاء تحميل صورة.',
			'image.image' => 'الملف يجب أن يكون صورة.',
			'image.mimes' => 'يجب أن تكون صيغة الصورة: jpeg أو png أو jpg أو gif أو webp.',
			'image.max' => 'حجم الصورة كبير جدًا، الحد الأقصى 2 ميغابايت.',

			'description_ar.required' => 'الرجاء إدخال الوصف بالعربية.',
			'description_fr.required' => 'الرجاء إدخال الوصف بالفرنسية.',
			'description_en.required' => 'الرجاء إدخال الوصف بالإنجليزية.',

			'latitude.required' => 'الرجاء إدخال خط العرض.',
			'longitude.required' => 'الرجاء إدخال خط الطول.',

			//'prix_lit.required' => 'الرجاء إدخال سعر السرير.',

			
			// Chambres
			'chambres.required' => 'الرجاء إضافة غرفة واحدة على الأقل.',
			'chambres.*.type_chambre_id.required' => 'الرجاء اختيار نوع الغرفة.',
			'chambres.*.capacite.required' => 'الرجاء إدخال طاقة الغرفة.',
			'chambres.*.num_chambre.required' => 'الرجاء إدخال رقم الغرفة.',

			'x.required' => 'الرجاء إدخال خط العرض.',
			'y.required' => 'الرجاء إدخال خط الطول.',
		]);

        $auberge->update([
            'nom_ar' => $request->nom_ar,
            'nom_fr' => $request->nom_fr,
            'nom_en' => $request->nom_en,
            'contact_tel' => $request->contact_tel,
            'contact_email' => $request->contact_email,
            'gouver_id' => $request->gouvernorat_id,
            'delegation_id' => $request->delegation_id,
            'epa' => $request->epa,
            'id_milieu_auberge' => $request->id_milieu_auberge,
            'fax' => $request->fax,
            'code_postal' => $request->code_postal,
            'adresse' => $request->adresse,
            'nom_directeur' => $request->nom_directeur,
            'tel_directeur' => $request->tel_directeur,
            'espace_boisson' => $request->has('espace_boisson') ? 1 : 0,
            'piscine' => $request->has('piscine') ? 1 : 0,
            
            'capacite_batiment' => $request->capacite_batiment,
            'nb_chambres' => $request->nb_chambres,
            'nb_chambres_single' => $request->nb_chambres_single,
            'nb_chambres_double' => $request->nb_chambres_double,
            'nb_chambres_triple' => $request->nb_chambres_triple,
            'nb_chambres_quadra' => $request->nb_chambres_quadra,
            'nb_chambres_plus' => $request->nb_chambres_plus,
            'nb_salles_de_bain' => $request->nb_salles_de_bain,
            'nb_salles_de_bain_comm' => $request->nb_salles_de_bain_comm,
            'nb_chambres_tv' => $request->nb_chambres_tv,
            'nb_chambres_clim' => $request->nb_chambres_clim,
            'nb_chambres_frigo' => $request->nb_chambres_frigo,
            'capacite_tentes' => $request->capacite_tentes,
            'cuisine_fonct' => $request->has('cuisine_fonctionnelle') ? 1 : 0,
            'lieux_culturels' => $request->lieux_culturels,
            'autres_services' => $request->autres_services,
            'description_ar' => $request->description_ar,
            'description_fr' => $request->description_fr,
            'description_en' => $request->description_en,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'prix_lit'=> $request->prix_lit,
			'x' => $request->x,               
			'y' => $request->y,               
			'map_link' => $request->map_link,
        ]);

        

        if ($request->hasFile('image')) {
            $imageData = file_get_contents($request->file('image')->getRealPath());
            $auberge->image = $imageData;
            $auberge->save();
        }


        if ($request->has('restaurations')) {
            foreach ($request->restaurations as $restaurationData) {
                if (!empty($restaurationData['id_rest'])) {
                    RestaurationAuberge::where('id_rest', $restaurationData['id_rest'])
                        ->update([
                            'nom_fr' => $restaurationData['nom_fr'],
                            'nom_ar' => $restaurationData['nom_ar'],
                            'nom_en' => $restaurationData['nom_en'],
                            'description_fr' => $restaurationData['description_fr'] ?? null,
                            'description_ar' => $restaurationData['description_ar'] ?? null,
                            'description_en' => $restaurationData['description_en'] ?? null,
                            'tarif' => $restaurationData['tarif'],
                        ]);
                } 
                else {
                    RestaurationAuberge::create([
                        'auberge_id' => $auberge->id,
                        'nom_fr' => $restaurationData['nom_fr'],
                        'nom_ar' => $restaurationData['nom_ar'],
                        'nom_en' => $restaurationData['nom_en'],
                        'description_fr' => $restaurationData['description_fr'] ?? null,
                        'description_ar' => $restaurationData['description_ar'] ?? null,
                        'description_en' => $restaurationData['description_en'] ?? null,
                        'tarif' => $restaurationData['tarif'],
                    ]);
                }

            }
        }

        if ($request->has('chambres')) {

            foreach ($request->chambres as $ch) {

                if (!empty($ch['id_chambre_tente'])) {
                    chambreTente::where('id_chambre_tente', $ch['id_chambre_tente'])
                        ->update([
                            'type_chambre_id' => $ch['type_chambre_id'],
                            'capacite' => $ch['capacite'],
                            'num_chambre' => $ch['num_chambre'],
                        ]);
                }
                else {
                    ChambreTente::create([
                        'auberge_id' => $auberge->id,
                        'type_chambre_id' => $ch['type_chambre_id'],
                        'capacite' => $ch['capacite'],
                        'num_chambre' => $ch['num_chambre'],
                        'type' => 'chambre',
                    ]);
                }
            }
        }


        if ($request->has('sports')) {
            $auberge->sports()->sync($request->sports);
        } else {
            $auberge->sports()->sync([]);
        }

        if ($request->has('services')) {
            $auberge->services()->sync($request->services);
        } else {
            $auberge->services()->sync([]);
        }

            



            if ($request->has('espaces')) {
                foreach ($request->espaces as $espaceData) {
                    if (!empty($espaceData['id_espace'])) {
                        EspaceAuberge::where('id_espace', $espaceData['id_espace'])->update([
                            'nom_ar' => $espaceData['nom_ar'],
                            'nom_fr' => $espaceData['nom_fr'],
                            'nom_en' => $espaceData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    } else {
                        EspaceAuberge::create([
                            'nom_ar' => $espaceData['nom_ar'],
                            'nom_fr' => $espaceData['nom_fr'],
                            'nom_en' => $espaceData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    }
                }
            }


            if ($request->has('terrains')) {
                foreach ($request->terrains as $terrainsData) {
                    if (!empty($terrainsData['id_terrain'])) {
                        TerrainSportifAuberge::where('id_terrain', $terrainsData['id_terrain'])->update([
                            'nom_ar' => $terrainsData['nom_ar'],
                            'nom_fr' => $terrainsData['nom_fr'],
                            'nom_en' => $terrainsData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    } else {
                        TerrainSportifAuberge::create([
                            'nom_ar' => $terrainsData['nom_ar'],
                            'nom_fr' => $terrainsData['nom_fr'],
                            'nom_en' => $terrainsData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    }
                }
            }

            if ($request->has('services_auberge')) {
                foreach ($request->services_auberge as $services_aubergeData) {
                    if (!empty($services_aubergeData['id_service'])) {
                        ServiceAuberge::where('id_service', $services_aubergeData['id_service'])->update([
                            'nom_ar' => $services_aubergeData['nom_ar'],
                            'nom_fr' => $services_aubergeData['nom_fr'],
                            'nom_en' => $services_aubergeData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    } else {
                        ServiceAuberge::create([
                            'nom_ar' => $services_aubergeData['nom_ar'],
                            'nom_fr' => $services_aubergeData['nom_fr'],
                            'nom_en' => $services_aubergeData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    }
                }
            }

        return redirect()->route('auberges.index')
                        ->with('success', 'تم تحديث بيانات المركب أو مركز الإقامة بنجاح !');
    }
	
	
	public function update2(Request $request, $id)
    {
        $auberge = Auberge::findOrFail($id);
        $request->validate([
            'nom_ar' => 'required|string|max:100',
            'nom_fr' => 'required|string|max:100',
            'nom_en' => 'required|string|max:100',
            'contact_tel' => 'required|string|max:50',
			'fax' => 'required|string|max:12',
            'contact_email' => 'required|email|max:255',
            'gouvernorat_id' => 'required|integer',
            'delegation_id' => 'required|integer',
            'epa' => 'required|string|in:EPA,Non EPA',
            'id_milieu_auberge' => 'required|integer',
            'adresse' => 'required|string|max:255',
			'code_postal' => 'required|string|max:20',
            'nom_directeur' => 'required|string|max:255',
            'tel_directeur' => 'required|string|max:50',
            'espace_boisson' => 'required|boolean',
            'piscine' => 'required|boolean',
            
            'cuisine_fonctionnelle' => 'sometimes|boolean',
            'capacite_batiment' => 'required|integer',
            'nb_chambres' => 'required|integer',
            'nb_chambres_single' => 'nullable|integer',
            'nb_chambres_double' => 'nullable|integer',
            'nb_chambres_triple' => 'nullable|integer',
            'nb_chambres_quadra' => 'nullable|integer',
            'nb_chambres_plus' => 'nullable|integer',
            'nb_salles_de_bain' => 'nullable|integer',
            'nb_salles_de_bain_comm' => 'nullable|integer',
            'nb_chambres_tv' => 'nullable|integer',
            'nb_chambres_clim' => 'nullable|integer',
            'nb_chambres_frigo' => 'nullable|integer',
            'capacite_tentes' => 'nullable|integer',
            'lieux_culturels' => 'nullable|string',
            'autres_services' => 'nullable|string',
            //'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
			'image' => $auberge->image ? 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048' : 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048',

            'description_ar' => 'required|string|max:2000',
            'description_fr' => 'required|string|max:2000',
            'description_en' => 'required|string|max:2000',
            'latitude' => 'required|string|max:50',
            'longitude' => 'required|string|max:50',
            'prix_lit' => 'nullable|numeric|min:0',
			'restaurations' => 'nullable|array|min:1',
            'restaurations.*.nom_fr' => 'nullable|string|max:255',
            'restaurations.*.nom_ar' => 'nullable|string|max:255',
            'restaurations.*.nom_en' => 'nullable|string|max:255',
            'restaurations.*.description_fr' => 'nullable|string',
            'restaurations.*.description_ar' => 'nullable|string',
            'restaurations.*.description_en' => 'nullable|string',
            'restaurations.*.tarif' => 'nullable|numeric|min:0',
            'chambres' => 'nullable|array|min:1',
            'chambres.*.type_chambre_id' => 'required|integer|exists:tp_type_chambre,id_type',
            'chambres.*.capacite' => 'required|integer|min:1',
            'chambres.*.num_chambre' => 'required|string|max:11',

            'espaces' => 'nullable|array|min:1',
            'espaces.*.nom_ar' => 'nullable|string|max:150',
            'espaces.*.nom_fr' => 'nullable|string|max:150',
            'espaces.*.nom_en' => 'nullable|string|max:150',

            'terrains' => 'nullable|array|min:1',
            'terrains.*.nom_ar' => 'nullable|string|max:150',
            'terrains.*.nom_fr' => 'nullable|string|max:150',
            'terrains.*.nom_en' => 'nullable|string|max:150',

            'services_auberge' => 'nullable|array|min:1',
            'services_auberge.*.nom_ar' => 'nullable|string|max:150',
            'services_auberge.*.nom_fr' => 'nullable|string|max:150',
            'services_auberge.*.nom_en' => 'nullable|string|max:150',

              
        ],[
			'nom_ar.required' => 'الرجاء إدخال الاسم بالعربية.',
			'nom_fr.required' => 'الرجاء إدخال الاسم بالفرنسية.',
			'nom_en.required' => 'الرجاء إدخال الاسم بالإنجليزية.',

			'contact_tel.required' => 'الرجاء إدخال رقم الهاتف.',
			'fax.required' => 'الرجاء إدخال رقم الفاكس .',
			'contact_email.required' => 'الرجاء إدخال البريد الإلكتروني.',

			'gouvernorat_id.required' => 'الرجاء اختيار الولاية.',
			'delegation_id.required' => 'الرجاء اختيار المعتمدية.',

			'epa.required' => 'الرجاء تحديد الحالة (EPA أو Non EPA).',

			'id_milieu_auberge.required' => 'الرجاء اختيار وسط النزل.',

			'adresse.required' => 'الرجاء إدخال العنوان.',
			'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',

			'nom_directeur.required' => 'الرجاء إدخال اسم المدير.',
			'tel_directeur.required' => 'الرجاء إدخال رقم هاتف المدير.',

			'espace_boisson.required' => 'الرجاء تحديد توفر فضاء المشروبات.',
			'piscine.required' => 'الرجاء تحديد توفر المسبح.',

			'capacite_batiment.required' => 'الرجاء إدخال طاقة استيعاب المبنى.',

			'nb_chambres.required' => 'الرجاء إدخال عدد الغرف.',
		
			'image.required' => 'الرجاء تحميل صورة.',
			'image.image' => 'الملف يجب أن يكون صورة.',
			'image.mimes' => 'يجب أن تكون صيغة الصورة: jpeg أو png أو jpg أو gif أو webp.',
			'image.max' => 'حجم الصورة كبير جدًا، الحد الأقصى 2 ميغابايت.',

			'description_ar.required' => 'الرجاء إدخال الوصف بالعربية.',
			'description_fr.required' => 'الرجاء إدخال الوصف بالفرنسية.',
			'description_en.required' => 'الرجاء إدخال الوصف بالإنجليزية.',

			'latitude.required' => 'الرجاء إدخال خط العرض.',
			'longitude.required' => 'الرجاء إدخال خط الطول.',

			//'prix_lit.required' => 'الرجاء إدخال سعر السرير.',

			
			// Chambres
			'chambres.required' => 'الرجاء إضافة غرفة واحدة على الأقل.',
			'chambres.*.type_chambre_id.required' => 'الرجاء اختيار نوع الغرفة.',
			'chambres.*.capacite.required' => 'الرجاء إدخال طاقة الغرفة.',
			'chambres.*.num_chambre.required' => 'الرجاء إدخال رقم الغرفة.',

			
		]);

        $auberge->update([
            'nom_ar' => $request->nom_ar,
            'nom_fr' => $request->nom_fr,
            'nom_en' => $request->nom_en,
            'contact_tel' => $request->contact_tel,
            'contact_email' => $request->contact_email,
            'gouver_id' => $request->gouvernorat_id,
            'delegation_id' => $request->delegation_id,
            'epa' => $request->epa,
            'id_milieu_auberge' => $request->id_milieu_auberge,
            'fax' => $request->fax,
            'code_postal' => $request->code_postal,
            'adresse' => $request->adresse,
            'nom_directeur' => $request->nom_directeur,
            'tel_directeur' => $request->tel_directeur,
            'espace_boisson' => $request->has('espace_boisson') ? 1 : 0,
            'piscine' => $request->has('piscine') ? 1 : 0,
            
            'capacite_batiment' => $request->capacite_batiment,
            'nb_chambres' => $request->nb_chambres,
            'nb_chambres_single' => $request->nb_chambres_single,
            'nb_chambres_double' => $request->nb_chambres_double,
            'nb_chambres_triple' => $request->nb_chambres_triple,
            'nb_chambres_quadra' => $request->nb_chambres_quadra,
            'nb_chambres_plus' => $request->nb_chambres_plus,
            'nb_salles_de_bain' => $request->nb_salles_de_bain,
            'nb_salles_de_bain_comm' => $request->nb_salles_de_bain_comm,
            'nb_chambres_tv' => $request->nb_chambres_tv,
            'nb_chambres_clim' => $request->nb_chambres_clim,
            'nb_chambres_frigo' => $request->nb_chambres_frigo,
            'capacite_tentes' => $request->capacite_tentes,
            'cuisine_fonct' => $request->has('cuisine_fonctionnelle') ? 1 : 0,
            'lieux_culturels' => $request->lieux_culturels,
            'autres_services' => $request->autres_services,
            'description_ar' => $request->description_ar,
            'description_fr' => $request->description_fr,
            'description_en' => $request->description_en,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'prix_lit'=> $request->prix_lit,
        ]);

        

        if ($request->hasFile('image')) {
            $imageData = file_get_contents($request->file('image')->getRealPath());
            $auberge->image = $imageData;
            $auberge->save();
        }


        if ($request->has('restaurations')) {
            foreach ($request->restaurations as $restaurationData) {
                if (!empty($restaurationData['id_rest'])) {
                    RestaurationAuberge::where('id_rest', $restaurationData['id_rest'])
                        ->update([
                            'nom_fr' => $restaurationData['nom_fr'],
                            'nom_ar' => $restaurationData['nom_ar'],
                            'nom_en' => $restaurationData['nom_en'],
                            'description_fr' => $restaurationData['description_fr'] ?? null,
                            'description_ar' => $restaurationData['description_ar'] ?? null,
                            'description_en' => $restaurationData['description_en'] ?? null,
                            'tarif' => $restaurationData['tarif'],
                        ]);
                } 
                else {
                    RestaurationAuberge::create([
                        'auberge_id' => $auberge->id,
                        'nom_fr' => $restaurationData['nom_fr'],
                        'nom_ar' => $restaurationData['nom_ar'],
                        'nom_en' => $restaurationData['nom_en'],
                        'description_fr' => $restaurationData['description_fr'] ?? null,
                        'description_ar' => $restaurationData['description_ar'] ?? null,
                        'description_en' => $restaurationData['description_en'] ?? null,
                        'tarif' => $restaurationData['tarif'],
                    ]);
                }

            }
        }

        if ($request->has('chambres')) {

            foreach ($request->chambres as $ch) {

                if (!empty($ch['id_chambre_tente'])) {
                    chambreTente::where('id_chambre_tente', $ch['id_chambre_tente'])
                        ->update([
                            'type_chambre_id' => $ch['type_chambre_id'],
                            'capacite' => $ch['capacite'],
                            'num_chambre' => $ch['num_chambre'],
                        ]);
                }
                else {
                    ChambreTente::create([
                        'auberge_id' => $auberge->id,
                        'type_chambre_id' => $ch['type_chambre_id'],
                        'capacite' => $ch['capacite'],
                        'num_chambre' => $ch['num_chambre'],
                        'type' => 'chambre',
                    ]);
                }
            }
        }


        if ($request->has('sports')) {
            $auberge->sports()->sync($request->sports);
        } else {
            $auberge->sports()->sync([]);
        }

        if ($request->has('services')) {
            $auberge->services()->sync($request->services);
        } else {
            $auberge->services()->sync([]);
        }

            



            if ($request->has('espaces')) {
                foreach ($request->espaces as $espaceData) {
                    if (!empty($espaceData['id_espace'])) {
                        EspaceAuberge::where('id_espace', $espaceData['id_espace'])->update([
                            'nom_ar' => $espaceData['nom_ar'],
                            'nom_fr' => $espaceData['nom_fr'],
                            'nom_en' => $espaceData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    } else {
                        EspaceAuberge::create([
                            'nom_ar' => $espaceData['nom_ar'],
                            'nom_fr' => $espaceData['nom_fr'],
                            'nom_en' => $espaceData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    }
                }
            }


            if ($request->has('terrains')) {
                foreach ($request->terrains as $terrainsData) {
                    if (!empty($terrainsData['id_terrain'])) {
                        TerrainSportifAuberge::where('id_terrain', $terrainsData['id_terrain'])->update([
                            'nom_ar' => $terrainsData['nom_ar'],
                            'nom_fr' => $terrainsData['nom_fr'],
                            'nom_en' => $terrainsData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    } else {
                        TerrainSportifAuberge::create([
                            'nom_ar' => $terrainsData['nom_ar'],
                            'nom_fr' => $terrainsData['nom_fr'],
                            'nom_en' => $terrainsData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    }
                }
            }

            if ($request->has('services_auberge')) {
                foreach ($request->services_auberge as $services_aubergeData) {
                    if (!empty($services_aubergeData['id_service'])) {
                        ServiceAuberge::where('id_service', $services_aubergeData['id_service'])->update([
                            'nom_ar' => $services_aubergeData['nom_ar'],
                            'nom_fr' => $services_aubergeData['nom_fr'],
                            'nom_en' => $services_aubergeData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    } else {
                        ServiceAuberge::create([
                            'nom_ar' => $services_aubergeData['nom_ar'],
                            'nom_fr' => $services_aubergeData['nom_fr'],
                            'nom_en' => $services_aubergeData['nom_en'],
                            'id_auberge' => $auberge->id,
                        ]);
                    }
                }
            }

			return redirect()->route('auberges2.show', ['id' => $auberge->id])
				->with('success', 'تم تحديث بيانات ' . $auberge->nom_ar . ' بنجاح');
		}

    public function show($id)
    {
        $auberge = Auberge::findOrFail($id);
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.show', compact(
            'auberge','milieux','gouvernorats','sports','services','delegations','typesChambres'
        ));
    }
	
	public function showauberge($id)
	{
		$auberge = Auberge::with(['gouvernorat', 'delegation'])->findOrFail($id);

		return view('backoffice.auberges.creation_centre.show2', compact('auberge'));
	}


    public function destroy($id)
    {
        $auberge = Auberge::findOrFail($id);

        try {
            $auberge->delete();
            return redirect()->route('auberges.index')->with('success', 'تم الحذف بنجاح');
        } catch (\Exception $e) {
            return redirect()->route('auberges.index')->with('error', 'حدث خطأ أثناء الحذف');
        }
    }
	
	
	public function getDelegations_auberge($gouvernoratId)

    {

        $delegations = Delegation::where('gouver_id', $gouvernoratId)->get();

        return response()->json($delegations);

    }


}