<?php $__env->startSection('title', 'قائمة المشتركين في النشرة'); ?>

<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between align-items-center">
                    <h2 class="widget-title m-0">قائمة المشتركين في النشرة</h2>

                </div>
				
				
				<div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="<?php echo e(route('newsletters.index')); ?>">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input 
                                    type="text" 
                                    name="q" 
                                    class="form-control" 
                                    placeholder="بحث بالبريد/تاريخ (YYYY-MM-DD)"
                                    value="<?php echo e($search ?? ''); ?>"
                                >
                            </div>
                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                                    بحث
                                </button>
                                <a href="<?php echo e(route('newsletters.index')); ?>"
                                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
				
                <div class="block-card-body">
                    <?php if(session('ok')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('ok')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                        <table class="table align-items-center table-flush mb-0 table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th style="width:70px">المعرف</th>
                                    <th>البريد الإلكتروني</th>
                                    <th style="width:180px">تاريخ التسجيل</th>
                                    <th style="width:160px">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $subscribers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($item->id); ?></td>
                                        <td class="text-end" style="direction: ltr;">
                                            <?php echo e($item->email); ?>

                                        </td>
                                        <td><?php echo e(optional($item->created_at)->format('Y-m-d H:i')); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <button type="button"
                                                        class="btn-icon btn-icon--warning"
                                                        onclick="window.location='<?php echo e(route('newsletters.edit', $item)); ?>'"
                                                        title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                <form action="<?php echo e(route('newsletters.destroy', $item)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا المشترك؟', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="py-4 text-muted">لا يوجد مشتركين حالياً.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <?php echo e($subscribers->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-news th,
.table-news td {
    vertical-align: middle;
    text-align: center;
}

.table-news td:nth-child(2) {
    text-align: right !important;
    direction: ltr;
}
.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
</style>

<?php else: ?>
<script>window.location.href = "<?php echo e(route('admin')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/newsletter_contact/newsletter_index.blade.php ENDPATH**/ ?>