<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تحديث حالة الطلب</title>
</head>
<body>
    <div style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 680px; margin: 20px auto; border: 1px solid #eee; padding: 22px; border-radius: 8px; color: #222;">
        <h3 style="text-align:center; margin-top:0;">مرحبًا <?php echo e($user->nom_prenom ?? ($user->name ?? 'المستخدم')); ?>،</h3>

        <p>نود إعلامك بأنه تم تحديث حالة ملفك المتعلق بالتمويل العمومي. التفاصيل أدناه:</p>

        <p>
            <strong>الحالة الجديدة:</strong>
            <?php
                $labels = [
                    'accepted' => 'مقبول',
                    'rejected' => 'مرفوض',
                    'incomplete' => 'غير مكتمل',
                    'deferred' => 'مؤجل',
                    'status_changed' => 'تغيير في الحالة'
                ];
                $label = $labels[$type] ?? $labels['status_changed'];
            ?>
            <?php echo e($label); ?>

        </p>

        
        <?php if($type === 'rejected' && !empty($params['reason'])): ?>
            <p><strong>سبب الرفض:</strong> <?php echo e($params['reason']); ?></p>
        <?php endif; ?>

        
        <?php if($type === 'incomplete' && !empty($params['missing'])): ?>
            <p><strong>المعلومات/المستندات الناقصة:</strong> <?php echo e($params['missing']); ?></p>
        <?php endif; ?>

        
        <?php if($type === 'deferred' && !empty($params['note'])): ?>
            <p><strong>ملاحظة:</strong> <?php echo e($params['note']); ?></p>
        <?php endif; ?>

        
        <?php if($type === 'accepted' && !empty($params['date'])): ?>
            <p><strong>تاريخ القبول:</strong> <?php echo e($params['date']); ?></p>
        <?php endif; ?>

        
        <?php if(!empty($params['comment']) && empty($params['reason']) && empty($params['missing']) && empty($params['note'])): ?>
            <p><strong>ملاحظة:</strong> <?php echo e($params['comment']); ?></p>
        <?php endif; ?>

       

        <p>شكرًا لتعاونك.</p>
        <p>اللجنة الفنية للنظر في مطالب التمويل العمومي</p>

        <hr style="margin: 18px 0; border: none; border-top: 1px solid #eee;">
        <div style="text-align:center; font-size:12px; color:#666;">
            وزارة الشباب والرياضة
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/emails/statut2_document_changed.blade.php ENDPATH**/ ?>