<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0"> الأدوار </h2>
                    <a class="btn btn-success font-weight-medium" href="<?php echo e(route('roles.create')); ?>">
                        <i class="la la-plus mr-1"> إضافة دور</i>
                    </a>
                </div>

                <?php if(session('ok')): ?>
                    <div class="alert alert-success"><?php echo e(session('ok')); ?></div>
                <?php endif; ?>

                <div class="block-card-body">
                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th width="30%">المعرف</th>
                                    <th width="40%">الاسم (ar)</th>
                                    <th width="40%"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($role->id_roles); ?></td>
                                        <td><?php echo e($role->nom_ar); ?></td>
                                        <td class="btn-group">
                                            <a class="btn btn-orange btn-sm mr-2"
                                            onclick="return confirmAction('هل تريد حقًا تعديل هذا الدور ؟', '<?php echo e(route('roles.edit', $role->id_roles)); ?>', null)">
                                                <i class="la la-edit mr-1"> تعديل</i>
                                            </a>
                                            
                                            <a class="btn btn-info btn-sm mr-2"
                                            href="<?php echo e(route('admin.roles.permissions.edit', $role->id_roles)); ?>">
                                                <i class="la la-key mr-1"> صلاحيات</i>
                                            </a>

                                            <form action="<?php echo e(route('roles.destroy', $role->id_roles)); ?>"
                                                method="POST"
                                                style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="button"
                                                        onclick="return confirmAction('هل تريد حقًا حذف هذا الدور ؟', null, this.closest('form'))"
                                                        class="btn bg-rgb-primary1 font-weight-medium">
                                                    <i class="la la-trash mr-1"> حذف</i>
                                                </button>
                                            </form>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center">لا يوجد أدوار.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="mt-3">
                        <?php echo e($roles->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('admin')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dell\Desktop\projet MJS\back\back\resources\views/backoffice/role-permission/role/index.blade.php ENDPATH**/ ?>