<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>إشعار حول حالة طلب الاستثمار</title>
</head>
<body>
    <div class="email-wrapper" style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 600px; margin: 20px auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px;">

        <!-- Header -->
        <div class="header" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center;">
            إشعار رسمي بخصوص حالة طلب الاستثمار
        </div>

        <!-- Content -->
        <div class="content" style="line-height: 1.6; color: #222;">

            <p>
                مرحباً <strong><?php echo e($user->nom_prenom ?? 'مستخدم'); ?></strong>،
            </p>

            <?php if(isset($type) && $type === 'accepte'): ?>
                <p>
                    يسرّنا إعلامكم بأنه تمت <strong>الموافقة</strong> على طلب الاستثمار الخاص بكم
                    ضمن قطاع الشباب والأطفال.
                </p>
                <p>
                    نتمنى لكم التوفيق والنجاح في مشروعكم.
                </p>

            <?php elseif(isset($type) && $type === 'refuse'): ?>
                <p>
                    نأسف لإعلامكم بأنه تم <strong>رفض</strong> طلب الاستثمار الخاص بكم
                    ضمن قطاع الشباب والأطفال.
                </p>

                <?php if(!empty($motif)): ?>
                    <div style="margin-top:10px;">
                        <strong>سبب الرفض:</strong>
                        <div style="margin-top:6px;"><?php echo e($motif); ?></div>
                    </div>
                <?php endif; ?>

            <?php elseif(isset($type) && $type === 'incomplete'): ?>
                <p>
                    نعلمكم أن طلب الاستثمار الخاص بكم تم تصنيفه كـ
                    <strong>ملف غير مكتمل</strong>.
                </p>
                <p>
                    يرجى استكمال النواقص أو الملاحظات التالية من أجل مواصلة دراسة ملفكم:
                </p>

                <?php if(!empty($motif)): ?>
                    <div style="margin-top:10px;"><?php echo e($motif); ?></div>
                <?php endif; ?>

            <?php elseif(isset($type) && $type === 'deferred'): ?>
                <p>
                    نعلمكم أن طلب الاستثمار الخاص بكم قد تم
                    <strong>إرجاء البت فيه مؤقتًا</strong>
                    إلى حين استكمال إجراءات إبداء الرأي.
                </p>

                <?php if(!empty($motif)): ?>
                    <p style="margin-top:10px;">
                        <strong>ملاحظة توضيحية:</strong><br>
                        <?php echo e($motif); ?>

                    </p>
                <?php endif; ?>

            <?php else: ?>
                <p>
                    نعلمكم بأنه قد تم تحديث حالة طلب الاستثمار الخاص بكم.
                    يرجى الولوج إلى حسابكم الشخصي للاطلاع على مزيد من التفاصيل.
                </p>
            <?php endif; ?>

            <p style="margin-top: 20px;">
                نشكركم على تعاونكم واهتمامكم.<br>
            </p>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #eee;">

        <!-- Footer -->
        <div class="footer" style="text-align: center; font-size: 12px; color: #555;">
            <div class="app-name">
                وزارة الشباب والرياضة
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/emails/jeune_enfant/statut.blade.php ENDPATH**/ ?>