<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($direction); ?>">
<head>
<meta charset="utf-8">

<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: <?php echo e($direction); ?>;
    text-align: <?php echo e($direction == 'rtl' ? 'right' : 'left'); ?>;
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* TITRES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-<?php echo e($direction == 'rtl' ? 'right' : 'left'); ?>: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARQUES */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
}
</style>
</head>

<body>


<div class="header">
    <table width="100%" style="border:none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="<?php echo e(public_path('storage/logo.png')); ?>" style="width:90px;">
            </td>
            <td style="text-align:center; border:none;">
                <h3><?php echo e($formulaire->type_ar); ?></h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>


<h4>المستثمر</h4>
<div class="section">
<?php
    $user = $formation->investissements->first()?->utilisateur;
?>

    <div class="row">
        <div class="field">
            <span class="label">الاسم و اللقب</span>
            <span class="value"><?php echo e($user->nom_prenom ?? '-'); ?></span>
        </div>

       <div class="row">
            <div class="field">
                <span class="label">مكان الولادة</span>
                <span class="value"><?php echo e($user->lieu_naissance ?? '-'); ?></span>
            </div>

            <div class="field">
                <span class="label">
تاريخ الولادة</span>
                <span class="value"><?php echo e($user->date_naissance ?? '-'); ?></span>
            </div>
        </div>


        
        <div class="field">
            <span class="label">العنوان الشخصي</span>
            <span class="value"><?php echo e($user->adresse ?? '-'); ?></span>
        </div>
    </div>

    <div class="row">
        

        

    <div class="field">
                <span class="label">المستوى التعليمي</span>
                <span class="value"><?php echo e($user->niveau_etude ?? '-'); ?></span>
            </div>
 <div class="field">
                <span class="label">آخر شهادة متحصل عليها</span>
                <span class="value"><?php echo e($user->dernier_diplome ?? '-'); ?></span>
            </div>

    <div class="field">
                <span class="label">الاقدمية في تعاطي النشاط</span>
                <span class="value"><?php echo e($user->experience ?? '-'); ?></span>
            </div>

            

        
    </div>
</div>


<h4>خاصيات المشروع</h4>

<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">المكونات</span>
        </div>

        <div class="field">
            <span class="label">الرجاء الاختيار</span>
            <span class="value"><?php echo e($types_espace_es->firstWhere('id_type_es', $formation->type_espace_s_id)?->type_ar ?? __('site.formation.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">مميزات الفضاء</span>
        </div>
        <div class="field">
            <span class="label">عدد الغرف</span>
            <span class="value"><?php echo e($formation->nbr_chambre ?? __('site.formation.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">
عدد القاعات</span>
            <span class="value"><?php echo e($formation->nbr_salles ?? __('site.formation.table.no_value')); ?></span>
        </div>
        <div class="field">
            <span class="label">عدد الملاعب</span>
            <span class="value"><?php echo e($formation->nbr_stade ?? __('site.formation.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">عدد حجرات الملابس</span>
            <span class="value"><?php echo e($formation->nbr_vestiaire ?? __('site.formation.table.no_value')); ?></span>
        </div>
        <div class="field">
            <span class="label">عدد مسالك الرياضية</span>
            <span class="value"><?php echo e($formation->nbr_stages_sportifs ?? __('site.formation.table.no_value')); ?></span>
        </div>
        <div class="field">
            <span class="label">قاعة تقوية العضلات</span>
            <span class="value"><?php echo e($formation->nbr_salle_renforcement_musculaire ?? __('site.formation.table.no_value')); ?></span>
        </div>
        <div class="field">
            <span class="label">طاقة الاستعاب</span>
        </div>

        <div class="field">
            <span class="label">بالمبيت</span>
            <span class="value"><?php echo e($formation->capacite_accueil_foyer ?? __('site.formation.table.no_value')); ?></span>
        </div>
        <div class="field">
            <span class="label">الملاعب و فضاءات التنشيط</span>
            <span class="value"><?php echo e($formation->capacite_accueil_stade ?? __('site.formation.table.no_value')); ?></span>
        </div>
        





    <div class="field">
            <span class="label">الاسم التجاري للمشروع</span>
            <span class="value"> <?php echo e($formation->nom_projet ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">
طبيعة المشروع</span>
            <span class="value">  <?php echo e($types_espace_es->firstWhere('id_type_es', $formation->type_espace_s_id)?->type_ar ?? 'غير محدد'); ?></span>
        </div>
       
    
       

        <div class="field">
            <span class="label">طبيعة المشروع</span>
            <span class="value"> <?php echo e($nature_projet->firstWhere('id_nature_p', $formation->nature_projet_id)?->nature_ar ?? 'غير محدد'); ?></span>
        </div>
<div class="field">
            <span class="label">>عدد مواطن الشغل</span>
            <span class="value"><?php echo e($formation->nbr_emplois ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>
</div>


<h4>مدير المؤسسة</h4>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">>الاسم و اللقب</span>
            <span class="value"><?php echo e($formation->directeur->nom_prenom_d ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">رقم بطاقة التعريف الوطنية</span>
            <span class="value"><?php echo e($formation->directeur->num_cin ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">تاريخ إصدار البطاقة</span>
            <span class="value"><?php echo e($formation->directeur->date_delivrance ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">مكان الإصدار</span>
            <span class="value"><?php echo e($formation->directeur->lieu_delivrance ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">المستوى التعليمي</span>
            <span class="value"><?php echo e($formation->directeur->niveau_etude ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label">آخر شهادة متحصل عليها</span>
            <span class="value"><?php echo e($formation->directeur->dernier_diplome_obtenu ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

    </div>
</div>










<h4><?php echo e(__('site.investment_finance_title')); ?></h4>
<div class="section">
<table>
    <thead>
        <tr>
            <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $formation->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td> <?php echo e($secteurs->firstWhere('id_secteur', $inv->secteur_invest_id)?->secteur_ar ?? 'غير محدد'); ?></td>
            <td><?php echo e(number_format($inv->montant_inv,2)); ?></td>
            <td> <?php echo e($source_fin->firstWhere('id_source', $inv->id_source_financement)?->source_ar ?? 'غير محدد'); ?></td>
            <td><?php echo e(number_format($inv->montant_fin, 2) ?? __('site.jeunesse.table.no_value')); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</div>


<div class="section">
    <strong>تصريح على الشرف</strong><br>
    إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
</div>
<div class="remarks-block">
        <strong>ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</strong><br>
        <?php echo e(old('remarques', $formation->remarques) ?? ''); ?>

    </div>

</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_formation_stage/pdf.blade.php ENDPATH**/ ?>