<?php $__env->startSection('content'); ?>

<?php if(session('ok')): ?>
    <div class="alert alert-success"><?php echo e(session('ok')); ?></div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
<?php endif; ?>

<?php if(Auth::check()): ?>
<link rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
                        <h2 class="widget-title">تعديل الملف الشخصي</h2>
                        <div class="stroke-shape"></div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="input-box">
                                <!-- Added id="profileForm" so client-side validation can use it -->
                                <form id="profileForm"   method="POST" action="<?php echo e(route('utilisateurs.updateprofil', auth()->user()->id)); ?>" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>الاسم الكامل</th>
                                                <td>
                                                    <input type="text" name="nom_prenom" class="form-control" 
                                                           value="<?php echo e(old('nom_prenom', auth()->user()->nom_prenom)); ?>" 
                                                           required minlength="3" maxlength="255">
                                                </td>
                                            </tr>

                                        <!--    <th>رقم البطاقة</th>
                                                <td>
                                                    <input type="text" class="form-control"  pattern="[0-9]{8}"  maxlength="8" inputmode="numeric" style="background-color: #ffffff;"
                                                        value="<?php echo e(old('cin', auth()->user()->cin)); ?>" 
                                                        disabled>
                                                    <input type="hidden" name="cin" value="<?php echo e(auth()->user()->cin); ?>">
                                                </td>
                                            </tr> -->

                                            <tr>
                                                <th>البريد الإلكتروني</th>
                                                <td>
                                                    <input type="email" class="form-control" style="background-color: #ffffff;"
                                                        value="<?php echo e(old('email', auth()->user()->email)); ?>"  maxlength="150"
                                                        disabled>
                                                    <input type="hidden" name="email" value="<?php echo e(auth()->user()->email); ?>">
                                                </td>
                                            </tr>

                                         <tr>
										<th>رقم الهاتف</th>
										<td>
											<input type="text" id="tel" name="tel" class="form-control" pattern="[0-9]{8}" maxlength="8" inputmode="numeric"
												   value="<?php echo e(old('tel', auth()->user()->tel)); ?>">
											<div id="telError" class="text-danger small mt-1" style="display:none;">
												رقم الهاتف يجب أن يحتوي على 8 أرقام.
											</div>
										</td>
									</tr>


                                         <!--   <tr>
                                                <th>العنوان</th>
                                                <td>
                                                    <input type="text" name="adresse" class="form-control" maxlength="150"
                                                           value="<?php echo e(old('adresse', auth()->user()->adresse)); ?>">
                                                </td>
                                            </tr> -->

                                            <!-- Password -->
                                            <tr>
                                                <th>كلمة المرور</th>
                                                <td>
                                                    <div class="position-relative">
                                                        <input
                                                            type="password"
                                                            id="password"
                                                            name="password"
                                                            minlength="8"
															maxlength="150"
                                                            pattern="(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}"
                                                            class="form-control"
                                                            placeholder="أدخل كلمة المرور الجديدة"
                                                            style="padding-left: 3.5rem;"
                                                        >
                                                        <!-- eye button inside the input (LEFT side) -->
                                                        <button type="button"
                                                                id="togglePwdBtn"
                                                                class="btn"
                                                                style="position:absolute; top:50%; left:0.5rem; right:auto; transform:translateY(-50%); background:transparent; border:0; padding:0.25rem; line-height:1; cursor:pointer;"
                                                                aria-label="إظهار كلمة المرور">
                                                            <i id="togglePwdIcon" class="bi bi-eye" style="font-size:1.05rem;"></i>
                                                        </button>
                                                    </div>

                                                    <!-- Arabic checklist with rules -->
                                                    <div id="passwordRules" class="small mt-2" style="line-height:1.5; display:none;">
                                                        <div id="pr_len" class="invalid">✖ الحد الأدنى 8 أحرف</div>
                                                        <div id="pr_upper" class="invalid">✖ حرف كبير واحد على الأقل (A-Z)</div>
                                                        <div id="pr_lower" class="invalid">✖ حرف صغير واحد على الأقل (a-z)</div>
                                                        <div id="pr_digit" class="invalid">✖ رقم واحد على الأقل (0-9)</div>
                                                        <div id="pr_special" class="invalid">✖ رمز خاص واحد على الأقل (مثل !@#$%^&*)</div>
                                                    </div>

                                              <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <div class="alert alert-danger mt-2"><?php echo e($message); ?></div>
    <script>
        // show JS rules panel if server returned a password error
        document.addEventListener('DOMContentLoaded', function(){
            const panel = document.getElementById('passwordRules');
            if (panel) panel.style.display = 'block';
        });
    </script>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                </td>
                                            </tr>

                                            <!-- Password confirmation -->
                                            <tr>
                                                <th>تأكيد كلمة المرور</th>
                                                <td>
                                                    <div class="position-relative">
                                                        <input
                                                            type="password"
                                                            id="password_confirmation"
                                                            name="password_confirmation"
                                                            minlength="8"
															maxlength="150"
                                                            class="form-control"
                                                            placeholder="أكد كلمة المرور"
                                                            style="padding-left: 3.5rem;"
                                                        >
                                                        <button type="button"
                                                                id="togglePwdConfBtn"
                                                                class="btn"
                                                                style="position:absolute; top:50%; left:0.5rem; right:auto; transform:translateY(-50%); background:transparent; border:0; padding:0.25rem; line-height:1; cursor:pointer;"
                                                                aria-label="إظهار تأكيد كلمة المرور">
                                                            <i id="togglePwdConfIcon" class="bi bi-eye" style="font-size:1.05rem;"></i>
                                                        </button>
                                                    </div>

                                                    <!-- Client-side confirmation error (Arabic) -->
                                                    <div id="passwordConfirmationError" class="text-danger small mt-1" style="display:none;">
                                                        تأكيد كلمة المرور غير مطابق.
                                                    </div>

                                                    <!-- Replace server-side french message with Arabic if present -->
                                                    <?php if($errors->has('password_confirmation')): ?>
                                                        <div class="alert alert-danger mt-2">تأكيد كلمة المرور غير مطابق.</div>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>

                                        </tbody>
                                    </table>

                                    <div class="text-center mt-4 d-flex justify-content-between">
                                        <button type="submit" class="btn btn-success btn-custom">
                                            <i class="fas fa-save"></i> تحديث
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('admin')); ?>";
    </script>
<?php endif; ?>

<style>
    /* simple valid/invalid styling */
    #passwordRules .valid { color: #28a745; }   /* green */
    #passwordRules .invalid { color: #dc3545; } /* red */
</style>

<script>

    // Password regex parts
    const re_len = /.{8,}/;
    const re_upper = /[A-Z]/;
    const re_lower = /[a-z]/;
    const re_digit = /[0-9]/;
    const re_special = /[\W_]/;

    // Elements
    const form = document.getElementById('profileForm');

    const pwdInput = document.getElementById('password');
    const pwdToggleBtn = document.getElementById('togglePwdBtn');
    const pwdToggleIcon = document.getElementById('togglePwdIcon');

    const confInput = document.getElementById('password_confirmation');
    const confToggleBtn = document.getElementById('togglePwdConfBtn');
    const confToggleIcon = document.getElementById('togglePwdConfIcon');

    const passwordRules = document.getElementById('passwordRules');
    const pr_len = document.getElementById('pr_len');
    const pr_upper = document.getElementById('pr_upper');
    const pr_lower = document.getElementById('pr_lower');
    const pr_digit = document.getElementById('pr_digit');
    const pr_special = document.getElementById('pr_special');

    const passwordConfirmationError = document.getElementById('passwordConfirmationError');

    const telInput = document.getElementById('tel');
    const telError = document.getElementById('telError');

    // helper to toggle eye icons
    function toggleInputVisibility(input, icon) {
        if (!input || !icon) return;
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('bi-eye');
            icon.classList.add('bi-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('bi-eye-slash');
            icon.classList.add('bi-eye');
        }
    }

    // password rule state
    function validatePasswordRules(pwd) {
        return {
            len: re_len.test(pwd),
            upper: re_upper.test(pwd),
            lower: re_lower.test(pwd),
            digit: re_digit.test(pwd),
            special: re_special.test(pwd)
        };
    }

    function updateRulesUI(state) {
        if (!passwordRules) return;
        passwordRules.style.display = 'block';
        pr_len.className = state.len ? 'valid' : 'invalid';
        pr_len.textContent = (state.len ? '✔ ' : '✖ ') + 'الحد الأدنى 8 أحرف';

        pr_upper.className = state.upper ? 'valid' : 'invalid';
        pr_upper.textContent = (state.upper ? '✔ ' : '✖ ') + 'حرف كبير واحد على الأقل (A-Z)';

        pr_lower.className = state.lower ? 'valid' : 'invalid';
        pr_lower.textContent = (state.lower ? '✔ ' : '✖ ') + 'حرف صغير واحد على الأقل (a-z)';

        pr_digit.className = state.digit ? 'valid' : 'invalid';
        pr_digit.textContent = (state.digit ? '✔ ' : '✖ ') + 'رقم واحد على الأقل (0-9)';

        pr_special.className = state.special ? 'valid' : 'invalid';
        pr_special.textContent = (state.special ? '✔ ' : '✖ ') + 'رمز خاص واحد على الأقل (مثل !@#$%^&*)';
    }

    // attach toggles
    pwdToggleBtn && pwdToggleBtn.addEventListener('click', function(e) {
        e.preventDefault();
        toggleInputVisibility(pwdInput, pwdToggleIcon);
        pwdInput.focus();
    });

    confToggleBtn && confToggleBtn.addEventListener('click', function(e) {
        e.preventDefault();
        toggleInputVisibility(confInput, confToggleIcon);
        confInput.focus();
    });

    // Show/hide rules live
    pwdInput && pwdInput.addEventListener('input', function() {
        const pwd = pwdInput.value || '';
        if (pwd.length === 0) {
            if (passwordRules) passwordRules.style.display = 'none';
        } else {
            updateRulesUI(validatePasswordRules(pwd));
        }
        if (passwordConfirmationError) passwordConfirmationError.style.display = 'none';
        // clear any browser custom validity
        if (typeof pwdInput.setCustomValidity === 'function') pwdInput.setCustomValidity('');
    });

    pwdInput && pwdInput.addEventListener('focus', function() {
        if (pwdInput.value.length === 0 && passwordRules) {
            passwordRules.style.display = 'block';
            updateRulesUI({len:false,upper:false,lower:false,digit:false,special:false});
        }
    });

    pwdInput && pwdInput.addEventListener('blur', function() {
        if (pwdInput.value.length === 0 && passwordRules) passwordRules.style.display = 'none';
    });

    // tel input live validation
    telInput && telInput.addEventListener('input', function() {
        if (!telError) return;
        if (telInput.validity.patternMismatch || telInput.value.trim().length > 0 && telInput.value.trim().length !== 8) {
            telError.style.display = 'block';
            // also set customValidity so checkValidity() will fail
            if (typeof telInput.setCustomValidity === 'function') {
                telInput.setCustomValidity('رقم الهاتف يجب أن يحتوي على 8 أرقام.');
            }
        } else {
            telError.style.display = 'none';
            if (typeof telInput.setCustomValidity === 'function') telInput.setCustomValidity('');
        }
    });

    // clear confirmation error while typing
    confInput && confInput.addEventListener('input', function() {
        if (passwordConfirmationError) passwordConfirmationError.style.display = 'none';
        if (typeof confInput.setCustomValidity === 'function') confInput.setCustomValidity('');
    });

    // prevent native tooltip and show inline Arabic messages instead
    if (form) {
        // prevent default native bubble
        form.addEventListener('invalid', function(e) {
            e.preventDefault();
        }, true);

        // final validation on submit (client-side), will show Arabic inline messages
        form.addEventListener('submit', function(e) {
            // clear previous custom validity messages
            if (telInput && typeof telInput.setCustomValidity === 'function') telInput.setCustomValidity('');
            if (pwdInput && typeof pwdInput.setCustomValidity === 'function') pwdInput.setCustomValidity('');
            if (confInput && typeof confInput.setCustomValidity === 'function') confInput.setCustomValidity('');

            // handle password: if provided, check rules and show rules panel if invalid
            const pwd = pwdInput ? pwdInput.value.trim() : '';
            const conf = confInput ? confInput.value.trim() : '';

            if (pwd.length > 0) {
                const state = validatePasswordRules(pwd);
                updateRulesUI(state);
                const allOk = state.len && state.upper && state.lower && state.digit && state.special;

                if (!allOk) {
                    // show descriptive Arabic message and block submit
                    if (passwordRules) passwordRules.style.display = 'block';
                    // set custom validity to prevent form from being considered valid by browser, although we use e.preventDefault()
                    if (typeof pwdInput.setCustomValidity === 'function') {
                        pwdInput.setCustomValidity('صيغة كلمة المرور غير صحيحة. يجب أن تحتوي على 8 أحرف على الأقل، حرف كبير، حرف صغير، رقم ورمز خاص.');
                    }
                    pwdInput.focus();
                    e.preventDefault();
                    return;
                }

                // confirmation match
                if (pwd !== conf) {
                    if (passwordConfirmationError) passwordConfirmationError.style.display = 'block';
                    if (typeof confInput.setCustomValidity === 'function') {
                        confInput.setCustomValidity('تأكيد كلمة المرور غير مطابق.');
                    }
                    confInput.focus();
                    e.preventDefault();
                    return;
                }
            }

            // phone final check
            if (telInput) {
                const telVal = telInput.value.trim();
                if (telVal.length > 0 && telVal.length !== 8) {
                    if (telError) telError.style.display = 'block';
                    if (typeof telInput.setCustomValidity === 'function') {
                        telInput.setCustomValidity('رقم الهاتف يجب أن يحتوي على 8 أرقام.');
                    }
                    telInput.focus();
                    e.preventDefault();
                    return;
                } else {
                    if (telError) telError.style.display = 'none';
                }
            }

            // If we reach here, client-side checks passed — submission continues to server (server still validates too)
        });
    }

    // If server returned a password error, show rules panel on load
    document.addEventListener('DOMContentLoaded', function() {
        <?php if($errors->has('password')): ?>
            if (passwordRules) {
                passwordRules.style.display = 'block';
                updateRulesUI({len:false,upper:false,lower:false,digit:false,special:false});
            }
        <?php endif; ?>

        <?php if($errors->has('password_confirmation')): ?>
            if (passwordConfirmationError) passwordConfirmationError.style.display = 'block';
        <?php endif; ?>

        <?php if($errors->has('tel')): ?>
            if (telError) {
                telError.style.display = 'block';
            }
        <?php endif; ?>
    });


</script>



<script>
  // disable native tooltips and ensure custom messages are shown
  (function(){
    const form = document.getElementById('profileForm');
    if (!form) return;

    // prevent browser from showing its own validation bubble on 'invalid'
    form.addEventListener('invalid', function(e){
      e.preventDefault(); // stop native tooltip
    }, true);

    // when user types, clear any customValidity so browser won't block us
    Array.from(form.querySelectorAll('input, textarea, select')).forEach(function(el){
      el.addEventListener('input', function(){
        // clear browser custom validity (if any)
        if (typeof el.setCustomValidity === 'function') el.setCustomValidity('');
      });
    });

    // optional: on submit still use your JS checks (you already have them)
    // we keep server-side validation as authoritative; server messages will come from resources/lang/ar/validation.php
  })();
</script>
 
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/role-permission/user/editProfile.blade.php ENDPATH**/ ?>