<?php $__env->startSection('content'); ?>

<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>

<?php if(Auth::check()): ?>

<div class="container">
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">

                <form method="POST" action="<?php echo e(route('chambres.update', $chambre->id_chambre_tente)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <input type="hidden" name="auberge_id" value="<?php echo e($chambre->auberge_id); ?>">

                    <div class="block-card mb-4">

                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل غرفة / خيمة</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="row">
                                <!-- التصنيف -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>التصنيف</label>
                                        <select name="type" class="form-control" required>
                                            <option value=""> اختر</option>
                                            <option value="chambre" <?php echo e($chambre->type == 'chambre' ? 'selected' : ''); ?>>غرفة</option>
                                            <option value="tente" <?php echo e($chambre->type == 'tente' ? 'selected' : ''); ?>>خيمة</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- رقم الغرفة -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>رقم الغرفة / الخيمة</label>
                                        <input type="text" name="num_chambre" class="form-control"
                                            value="<?php echo e(old('num_chambre', $chambre->num_chambre)); ?>" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- نوع الغرفة -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>نوع الغرفة</label>
                                        <select name="type_chambre_id" class="form-control" required>
                                            <option value="">-- اختر نوع الغرفة --</option>
                                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($type->id_type); ?>" 
                                                    <?php echo e($chambre->type_chambre_id == $type->id_type ? 'selected' : ''); ?>>
                                                    <?php echo e($type->type_ar); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <!-- الطاقة الاستيعابية -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>الطاقة الاستيعابية</label>
                                        <input type="number" name="capacite" class="form-control"
                                            value="<?php echo e(old('capacite', $chambre->capacite)); ?>" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                            <i class="la la-save mr-1"></i> حفظ
                        </button>

                        <a href="<?php echo e(route('chambres.index', $chambre->auberge_id)); ?>"
                           class="btn bg-rgb-primary1 font-weight-medium">
                            <i class="la la-times mr-1"></i> إلغاء
                        </a>

                    </div>

                </form>

            </div>
        </div>
    </div>
</section>
</div>

<?php else: ?>
    <script> window.location.href = "<?php echo e(route('admin')); ?>"; </script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/chambres/edit.blade.php ENDPATH**/ ?>