

<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">

<style>

    @media print {

    body * {

        visibility: hidden;

    }
    .container, .container * {

        visibility: visible; 

    }
    .no-print {

        display: none !important;

    }
    .container {

        position: absolute;

        left: 0;

        top: 0;

        width: 100%;

    }
}
</style>

<?php if($errors->any()): ?>

    <ul class="alert alert-warning">

        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <li><?php echo e($error); ?></li>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </ul>

<?php endif; ?>

<?php if(Auth::check()): ?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pO6Faa4sdB7Z3K/ZzF8O1NjcZk7CjJmUjeF3fXxOZbq1dsm7GJxSFeWmyt3E5kzZ+vHVH3K2Yv/Vs1QY7PZ3UQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />



<div class="container printable-content">

    <form action="<?php echo e(route('salle-sport.update', $immobilier->id_imm)); ?>" method="POST" enctype="multipart/form-data" lang="ar">

        <?php echo csrf_field(); ?>

        <?php echo method_field('PUT'); ?>



        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">



        <div class="header-print-container">

    <div class="header-side header-left">

        <span class="delegation-print">

            المندوبية الجهوية للشباب و الرياضة : 

            <?php echo e($delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-'); ?>


        </span>

    </div>



    <div class="header-center">

        <h1 class="title-main">الجمهورية التونسية</h1>

        <h2 class="title-sub">وزارة الشباب و الرياضة</h2>

        <h3 class="title-form">استمارة إيداع كراس الشروط لإحداث قاعة خاصة للرياضة</h3>

        <h4 class="title-request">اطلاع على المطلب</h4>

    </div>

<a href="<?php echo e(route('salle-sport.pdf', $immobilier->id_imm)); ?>" target="_blank"
   class="btn btn-danger">
    <i class="fa fa-file-pdf"></i> تحميل PDF
</a>


    

</div>

        <div>

            <div class="d-flex align-items-center mb-3">

                <h5 class="mb-0 fw-bold me-2">   الوضعية الحالية: </h5>

                <?php if($immobilier->id_statut == 1): ?>

                    <span><strong> قبول </strong></span>

                <?php elseif($immobilier->id_statut == 3): ?>

                    <span><strong> رفض </strong></span>

                <?php else: ?>

                    <span><strong> في الانتظار </strong></span>

                <?php endif; ?>

            </div>



            <?php if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif)): ?>

                <div class="d-flex align-items-center mb-3">

                    <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>

                    <p class="mb-0 border p-2 rounded shadow-sm text-muted"><?php echo e($immobilier->commentaire_motif); ?></p>

                </div>

            <?php endif; ?>

        </div>



        <div class="form-section">

            <h4 class="mb-3 fw-bold">هوية الباعث</h4>   

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الاسم و اللقب أو الاسم التجاري</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->nom_prenom ?? '-'); ?></span>

                </div>

            </div>  

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الهوية الشخصية</label>  

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first()->type_ar ?? '-'); ?>


                    </span>

                </div>

                <div class="col-sm-6 pt-2">

                    <?php if($immobilier->utilisateur->cin): ?>

                        <span>بطاقة تعريف: <?php echo e($immobilier->utilisateur->cin); ?></span>

                    <?php elseif($immobilier->utilisateur->passport): ?>

                        <span>جواز سفر: <?php echo e($immobilier->utilisateur->passport); ?></span>

                    <?php elseif($immobilier->utilisateur->num_fiscal): ?>

                        <span>معرّف جبائي: <?php echo e($immobilier->utilisateur->num_fiscal); ?></span>

                    <?php else: ?>

                        <span>-</span>

                    <?php endif; ?>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">رقم الهاتف الشخصي</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->tel ?? '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">البريد الالكتروني</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->email ?? '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">العنوان الشخصي</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->adresse ?? '-'); ?></span>

                </div>

            </div>



            <h4 class="mb-3 fw-bold">هوية العقار</h4> 

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">عنوان العقار</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->adresse_imm ?? '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الولاية</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first()->nom_ar ?? '-'); ?>


                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">البلدية</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-'); ?>


                    </span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">صيغة العقار</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first()->type_ar ?? '-'); ?>


                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">المساحة الجملية للعقار بالم2</label>

                <div class="col-sm-4 pt-2">

                    <span><?php echo e($immobilier->superfici_m2 ? $immobilier->superfici_m2.' م²' : '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">صيغة استغلال العقار</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first()->usage_ar ?? '-'); ?>


                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">نسخة العقد/الملكية</label>

                <div class="col-sm-4 pt-2">

                    <?php if($immobilier->document_propriete): ?>

                        <a href="<?php echo e(asset('storage/'.$immobilier->document_propriete)); ?>" target="_blank" class="btn btn-link p-0">📄 عرض</a>

                    <?php else: ?>

                        <span>-</span>

                    <?php endif; ?>

                </div>

            </div>



            <h4 class="mb-3 fw-bold">مكونات العقار</h4>



<table class="table table-bordered text-center align-middle">

    <thead class="table-light">

        <tr>

            <th>المكوّن</th>

            <th>نعم / لا</th>

            <th>العدد</th>

            <th>المساحة</th>

        </tr>

    </thead>

    <tbody>

        <?php

            $components = [

                'salle_exercice'   => 'قاعة التمارين',

                'piscine'          => 'حوض مائي',

                'vestiaire'        => 'حجرات ملابس',

                'unitaires_sanitaire' => 'وحدات صحية',

                'stockage_conser'  => 'فضاء للخزن وحفظ الأثاث والمعدات',

                'espace_exterieur' => 'فضاء خارجي',

                'garage'           => 'مأوى سيارات'

            ];

        ?>



        <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <tr>

                

                <td><?php echo e($label); ?></td>



                

                <td>

                    <?php if($immobilier->$comp == 1): ?>

                        نعم

                    <?php elseif($immobilier->$comp == 0): ?>

                        لا

                    <?php else: ?>

                        -

                    <?php endif; ?>

                </td>



                

<td>

    <?php if($immobilier->$comp == 1): ?>

        <?php if(in_array($comp, ['salle_exercice','piscine','vestiaire'])): ?>

            <?php echo e($immobilier->{'nbr_'.$comp} ?? '-'); ?>


        <?php else: ?>

            -

        <?php endif; ?>

    <?php else: ?>

        -

    <?php endif; ?>

</td>





<td>

    <?php if($immobilier->$comp == 1): ?>

        <?php echo e($immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : '-'); ?>


    <?php else: ?>

        -

    <?php endif; ?>

</td>



            </tr>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody>

</table>





            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">مساحات اخرى</label>

                <div class="col-sm-10 pt-2">

                   <span><?php echo e($immobilier->autres_surfaces ?? '-'); ?> م²</span>



                </div>

            </div>

        </div>

        <div class="form-group no-print" style="display: flex; justify-content: center; margin-top: 20px;">

            <div class="d-flex" style="gap: 20px; align-items: center;">

                <a href="<?php echo e(route('salle-sport.index')); ?>" class="btn btn-primary" style="width:120px; height:40px; display:flex; align-items:center; justify-content:center;">

                    <i class="bi bi-arrow-left" style="margin-right:5px;"></i> رجوع

                </a>

                <a href="<?php echo e(route('salle-sport.pdf', $immobilier->id_imm)); ?>" target="_blank"
                    class="btn btn-danger">
                        <i class="fa fa-file-pdf"></i> تحميل PDF
                    </a>


            </div>

        </div>



    </form>

</div>



<?php else: ?>

    <script>

        window.location.href = "<?php echo e(route('admin')); ?>";

    </script>

<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\DELL\Desktop\preprod mjs\back\resources\views/backoffice/investissement/gestion_salle_sport/salle_sport/show.blade.php ENDPATH**/ ?>