<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                <div class="block-card-header d-flex justify-content-between align-items-center px-4 py-3 border-bottom bg-light">
                    <h2 class="widget-title m-0">🔒 الأذونات</h2>
                    <a class="btn btn-success btn-sm px-3" href="<?php echo e(route('permissions.create')); ?>">
                        <i class="la la-plus me-1"></i> إضافة إذن
                    </a>
                </div>

                <?php if(session('ok')): ?>
                    <div class="alert alert-success mx-4 mt-3"><?php echo e(session('ok')); ?></div>
                <?php endif; ?>

                <div class="block-card-body p-3">
                    <div class="table-responsive" dir="rtl">
                        <table class="table table-striped table-bordered table-hover align-middle text-center mb-0 shadow-sm rounded">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-center" style="width:10%">#</th>
                                    <th class="text-center" style="width:50%">الإذن</th>
                                    <th class="text-center" style="width:40%">الإجراءات</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        
                                        <td class="text-center fw-bold align-middle"><?php echo e($permission->id_perm); ?></td>

                                        
                                        <td class="text-end align-middle" style="direction: rtl;">
                                            <?php echo e($permission->nom_ar); ?>

                                        </td>

                                        
                                        <td class="text-center align-middle">
                                            <div class="d-flex justify-content-center align-items-center gap-2">

                                                
                                                <button type="button"
                                                        class="btn btn-warning btn-sm px-3"
                                                        onclick="return confirmAction('هل تريد تعديل هذا الإذن؟', '<?php echo e(route('permissions.edit', $permission->id_perm)); ?>')"
                                                        title="تعديل">
                                                    <i class="la la-edit"></i> تعديل
                                                </button>

                                                
                                                <form action="<?php echo e(route('permissions.destroy', $permission->id_perm)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا الإذن؟', null, this.closest('form'))"
                                                            class="btn btn-danger btn-sm px-3"
                                                            title="حذف">
                                                        <i class="la la-trash"></i> حذف
                                                    </button>
                                                </form>

                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="py-4 text-muted text-center">لا توجد أذونات حالياً.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>


                    
                    <div class="mt-3">
                        <?php echo e($permissions->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table th, .table td {
    vertical-align: middle;
    text-align: center;
}

.table td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

</style>

<?php else: ?>
<script>window.location.href = "<?php echo e(route('admin')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>







<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/role-permission/permission/index.blade.php ENDPATH**/ ?>