<?php $__env->startSection('content'); ?>
<div class="dashboard-content p-4">
    <!-- Header -->
	

    <div class="stats-widgets">
        <div class="row g-3">
            <!-- Widget 1 - New Orders -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-purple">
                    <div class="widget-content">
                        <h3 class="widget-title">المستخدمين</h3>
                        <div class="widget-value">40</div>
                        <div class="widget-progress">
                            <div class="progress-bar"></div>
                            <span class="progress-value">+12.5%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-team-line"></i>
                    </div>
                </div>
            </div>

            <!-- Widget 2 - Customers -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-blue">
                    <div class="widget-content">
                        <h3 class="widget-title">تظاهرات</h3>
                        <div class="widget-value">6</div>
                        <div class="widget-progress">
                            <div class="progress-bar"></div>
                            <span class="progress-value">+9.23%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-calendar-event-line"></i>
                    </div>
                </div>
            </div>

            <!-- Widget 3 - Tickets Resolved -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-green">
                    <div class="widget-content">
                        <h3 class="widget-title">طلبات التمويل</h3>
                        <div class="widget-value">33</div>
                        <div class="widget-progress">
                            <div class="progress-bar"></div>
                            <span class="progress-value">+10%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-money-dollar-circle-line"></i>
                    </div>
                </div>
            </div>

            <!-- Widget 4 - Revenue -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-orange">
                    <div class="widget-content">
                        <h3 class="widget-title">قاعات رياضية</h3>
                        <div class="widget-value">8</div>
                        <div class="widget-progress">
                            <div class="progress-bar"></div>
                            <span class="progress-value">+2.5%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-building-4-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
    .stats-widgets {
        padding: 1rem 0;
    }

    .stat-widget {
        position: relative;
        padding: 1.5rem;
        border-radius: 16px;
        overflow: hidden;
        color: white;
        min-height: 140px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
    }

    .gradient-purple {
        background: linear-gradient(135deg, #e42125, #ff6b6b);
    }

    .gradient-blue {
        background: linear-gradient(135deg, #1a237e, #3f51b5);
    }

    .gradient-green {
        background: linear-gradient(135deg, #e42125, #ff6b6b);
    }

    .gradient-orange {
        background: linear-gradient(135deg, #1a237e, #3f51b5);
    }

    .widget-content {
        position: relative;
        z-index: 1;
    }

    .widget-title {
        font-size: 1rem;
        font-weight: 500;
        margin-bottom: 1rem;
		color:#ffffff !important;
		font-family:'Cairo' !important;
        opacity: 0.9;
    }

    .widget-value {
        font-size: 2rem;
        font-weight: 600;
        margin-bottom: 1rem;
    }

    .widget-progress {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .widget-progress .progress-bar {
        flex: 1;
        height: 4px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 2px;
        position: relative;
    }

    .widget-progress .progress-bar::after {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        width: 65%;
        background: white;
        border-radius: 2px;
    }

    .widget-progress .progress-value {
        font-size: 0.875rem;
        font-weight: 500;
    }

    .widget-icon {
        position: absolute;
        left: 1.5rem;
        bottom: 1.5rem;
        font-size: 3rem;
        opacity: 0.2;
    }

    .stat-widget::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at top right, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 60%);
    }
    </style>

    <style>
    .modern-stats-section {
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 20px;
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        gap: 1.5rem;
        padding: 1rem;
    }

    .stat-card {
        position: relative;
        border-radius: 12px;
        overflow: hidden;
        height: 120px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        padding: 1rem;
        background: #e42125;
    }

    .stat-card:nth-child(even) {
        background: #1a237e;
    }
.stat-card:nth-child(even):hover .stat-icon {
    background: var(--navy-blue);
    color: white;
    box-shadow: 0 6px 20px rgba(26, 35, 126, 0.2);
}
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .stat-card:nth-child(1) {
        background: #e42125;
        color: white;
    }

    .stat-card:nth-child(2) {
        background: #1a237e;
        color: white;
    }

    .stat-card:nth-child(3) {
        background: #e42125;
        color: white;
    }

    .stat-card:nth-child(4) {
        background: #1a237e;
        color: white;
    }

    .stat-card-inner {
        position: relative;
        height: 100%;
        width: 100%;
    }

    .stat-icon {
        position: absolute;
        top: 1rem;
        right: 1rem;
        width: 35px;
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        background: #1a237e;
        border-radius: 8px;
        color: #ffffff;
    }

    .stat-card:nth-child(even) .stat-icon {
        background: #e42125;
    }

    .stat-number {
        font-size: 2.5rem;
        font-weight: 600;
        line-height: 1;
        color: #ffffff;
        position: absolute;
        left: 1rem;
        bottom: 2.5rem;
    }

    .stat-label {
        font-size: 1.5rem;
        font-weight: 700;
        color: #ffffff;
        position: absolute;
        left: 1rem;
        bottom: 1rem;
    }

    .stat-wave {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 40px;
        color: rgba(255, 255, 255, 0.2);
    }

    @media (max-width: 768px) {
        .stats-row {
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        }

        .stat-card {
            height: 140px;
        }

        .stat-number {
            font-size: 2rem;
        }
    }
    </style>

    <style>
    .stats-dashboard {
        margin-top: 1rem;
    }

    .main-stats-card,
    .quick-stats-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        height: 100%;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.04);
    }

    .stats-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }

    .stats-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .stats-period {
        display: flex;
        gap: 0.5rem;
        background: #f5f5f5;
        padding: 0.3rem;
        border-radius: 8px;
    }

    .stats-period span {
        padding: 0.4rem 0.8rem;
        font-size: 0.9rem;
        color: #666;
        cursor: pointer;
        border-radius: 6px;
        transition: all 0.3s ease;
    }

    .stats-period span.active {
        background: white;
        color: var(--primary-red);
        box-shadow: 0 2px 8px rgba(228, 33, 37, 0.1);
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
    }

    .stat-item {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 1.2rem;
        display: flex;
        align-items: flex-start;
        gap: 1rem;
        transition: all 0.3s ease;
    }

    .stat-item:hover {
        transform: translateY(-2px);
    }

    .stat-icon-wrapper {
        width: 42px;
        height: 42px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.3rem;
    }

    .stat-icon-wrapper.red {
        background: var(--light-red);
        color: var(--primary-red);
    }

    .stat-icon-wrapper.blue {
        background: rgba(26, 35, 126, 0.1);
        color: var(--navy-blue);
    }

    .stat-icon-wrapper.green {
        background: rgba(72, 187, 120, 0.1);
        color: #48bb78;
    }

    .stat-icon-wrapper.gray {
        background: rgba(160, 174, 192, 0.1);
        color: #a0aec0;
    }

    .stat-info {
        flex: 1;
    }



    .stat-value {
        font-size: 1.5rem;
        font-weight: 600;
        color: #333;
        line-height: 1;
        margin-bottom: 0.5rem;
    }

    .stat-change {
        font-size: 0.85rem;
        display: flex;
        align-items: center;
        gap: 0.2rem;
    }

    .stat-change.positive {
        color: #48bb78;
    }

    .stat-change.negative {
        color: var(--primary-red);
    }

    .stat-change.neutral {
        color: #a0aec0;
    }

    /* Quick Stats Styles */
    .quick-stats-card {
        display: flex;
        flex-direction: column;
        gap: 1.2rem;
    }

    .quick-stat {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 1rem;
    }

    .stat-header {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 0.8rem;
        color: #555;
        font-size: 0.95rem;
    }

    .stat-progress {
        height: 6px;
        background: #edf2f7;
        border-radius: 3px;
        margin-bottom: 0.8rem;
    }

    .stat-progress .progress-bar {
        height: 100%;
        border-radius: 3px;
        background: var(--primary-red);
        transition: width 0.3s ease;
    }

    .stat-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 0.9rem;
    }

    .stat-footer .value {
        font-weight: 600;
        color: #333;
    }

    .stat-footer .label {
        color: #666;
    }
    </style>

    <!-- Charts Section -->
    <div class="row g-4 mb-4">
        <!-- Monthly Requests Chart -->
        <div class="col-lg-8 col-md-12">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title mb-0" style="direction: rtl; text-align: right;">إحصائيات الطلبات الشهرية</h5>
                        <div class="chart-options">
                            <select class="form-select form-select-sm" id="yearSelect">
                                <option value="2025">2025</option>
                                <option value="2024">2024</option>
                                <option value="2023">2023</option>
                            </select>
                        </div>
                    </div>
                    <div style="width: 100%; height: 300px;">
                        <canvas id="monthlyRequestsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Request Types Distribution -->
        <div class="col-lg-4 col-md-12">
            <div class="card h-100">
                <div class="card-body">
                    <h5 class="card-title mb-4" style="direction: rtl; text-align: right;">توزيع الطلبات حسب النوع</h5>
                    <div style="width: 100%; height: 300px;">
                        <canvas id="requestTypesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Timeline -->
    <div class="card mb-4">
        <div class="card-body">
            <h5 class="card-title mb-4" style="direction: rtl; text-align: right;">تطور حالة الطلبات</h5>
            <div style="width: 100%; height: 150px;">
                <canvas id="statusTimelineChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Recent Activity Table -->
    <div class="card" style="direction: rtl; text-align: right;">
        <div class="card-body">
            <h5 class="card-title mb-4">آخر النشاطات</h5>
            <div class="table-responsive">
                <table class="table dashboard-table" style="direction: rtl; text-align: right;">
                    <thead>
                        <tr>
                            <th>النوع</th>
                            <th>العنوان</th>
                            <th>الحالة</th>
                            <th>التاريخ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $recentActivities = collect()
                                ->merge(\App\Models\Immobilier::latest()->take(5)->get()->map(function($item) {
                                    return [
                                        'type' => 'قاعة رياضة',
                                        'title' => $item->adresse_imm,
                                        'status' => $item->statut->statut_ar ?? '-',
                                        'date' => $item->created_at
                                    ];
                                }))
                                ->merge(\App\Models\DemandeFinancement::latest()->take(5)->get()->map(function($item) {
                                    return [
                                        'type' => 'طلب تمويل',
                                        'title' => $item->titre ?? '-',
                                        'status' => $item->statut ?? '-',
                                        'date' => $item->created_at
                                    ];
                                }))
                                ->sortByDesc('date')
                                ->take(5);
                        ?>

                        <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($activity['type']); ?></td>
                                <td><?php echo e($activity['title']); ?></td>
                                <td>
                                    <span class="badge <?php echo e($activity['status'] == 'مقبول' ? 'bg-success' : 'bg-warning'); ?>">
                                        <?php echo e($activity['status']); ?>

                                    </span>
                                </td>
                                <td><?php echo e($activity['date']->format('Y-m-d')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<style>
    .dashboard-content {
        max-width: 1400px;
        margin: 0 auto;
    }
    
    .header-section {
        background: linear-gradient(to left, rgba(255,255,255,0.95), rgba(255,255,255,0.8));
        padding: 2rem;
        border-radius: 20px;
        margin-bottom: 2rem;
        backdrop-filter: blur(10px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .stat-card {
        transition: all 0.3s ease;
        border: none;
        border-radius: 15px;
        overflow: hidden;
        background: linear-gradient(145deg, rgba(255,255,255,0.95), rgba(255,255,255,0.9));
        backdrop-filter: blur(10px);
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }

    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .stat-icon i {
        font-size: 24px;
    }

    .bg-danger-light {
        background: rgba(228, 33, 37, 0.1);
    }

    .bg-success-light {
        background: rgba(40, 167, 69, 0.1);
    }

    .bg-warning-light {
        background: rgba(255, 193, 7, 0.1);
    }

    .bg-info-light {
        background: rgba(23, 162, 184, 0.1);
    }

    .progress {
        background: rgba(0,0,0,0.05);
        border-radius: 10px;
        height: 6px;
    }

    .progress-bar {
        border-radius: 10px;
        transition: all 0.5s ease;
    }

    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        background: linear-gradient(145deg, rgba(255,255,255,0.95), rgba(255,255,255,0.9));
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .card-body {
        padding: 1.5rem;
    }

    .card-title {
        color: #333;
        font-weight: 600;
        margin-bottom: 1.5rem;
    }

    .dashboard-table th {
        font-weight: 600;
        color: #333;
        background: rgba(228, 33, 37, 0.05);
        padding: 1rem;
    }

    .dashboard-table td {
        vertical-align: middle;
    }

    .badge {
        padding: 6px 12px;
        border-radius: 30px;
        font-weight: 500;
    }

    /* Chart Styles */
    .chart-options {
        background: rgba(255, 255, 255, 0.9);
        padding: 0.5rem;
        border-radius: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .chart-options .form-select {
        border: none;
        background-color: transparent;
        padding-left: 1.5rem;
        padding-right: 0.5rem;
        font-size: 0.9rem;
        color: #666;
        cursor: pointer;
    }

    .chart-options .form-select:focus {
        box-shadow: none;
    }

    .card-title {
        color: #333;
        font-size: 1.1rem;
        font-weight: 600;
    }

    canvas {
        filter: drop-shadow(0 4px 6px rgba(0,0,0,0.02));
    }

    /* Animation for charts */
    @keyframes chartFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .card canvas {
        animation: chartFadeIn 0.6s ease-out forwards;
    }

    /* Hover effect for chart cards */
    .card:hover canvas {
        filter: drop-shadow(0 8px 12px rgba(0,0,0,0.05));
        transition: filter 0.3s ease;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Configuration simple pour les graphiques
    const ctx1 = document.getElementById('monthlyRequestsChart').getContext('2d');
    const ctx2 = document.getElementById('requestTypesChart').getContext('2d');
    const ctx3 = document.getElementById('statusTimelineChart').getContext('2d');
    // Graphique 1 : Demandes mensuelles
    new Chart(ctx1, {
        type: 'doughnut',
        data: {
            labels: ['قاعات رياضية', 'تظاهرات', 'تمويلات'],
            datasets: [{
                data: [40, 35, 25],
                backgroundColor: [
                    '#e42125',
                    '#1a237e',
                    'rgba(228, 33, 37, 0.7)'
                ],
                borderWidth: 0,
                hoverOffset: 15,
                spacing: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '75%',
            radius: '90%',
            plugins: {
                legend: {
                    position: 'bottom',
                    rtl: true,
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        pointStyle: 'circle',
                        font: {
                            size: 13,
                            family: 'Cairo',
                            weight: '500'
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(255, 255, 255, 0.95)',
                    titleColor: '#333',
                    bodyColor: '#666',
                    bodyFont: {
                        family: 'Cairo'
                    },
                    titleFont: {
                        family: 'Cairo',
                        weight: 'bold'
                    },
                    padding: 12,
                    boxPadding: 8,
                    borderColor: '#e1e1e1',
                    borderWidth: 1,
                    displayColors: true,
                    usePointStyle: true,
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ' + context.parsed + '%';
                        }
                    },
                    rtl: true
                }
            },
            layout: {
                padding: 20
            },
            animation: {
                animateScale: true,
                animateRotate: true
            }
        }
    });

    // Graphique 2 : Distribution des types
    new Chart(ctx2, {
        type: 'pie',
        data: {
            labels: ['قاعات رياضية', 'تظاهرات', 'تمويلات'],
            datasets: [{
                data: [30, 20, 15],
                backgroundColor: [
                    '#e42125',
                    'rgba(228, 33, 37, 0.8)',
                    '#1a237e'
                ],
                borderWidth: 2,
                borderColor: '#ffffff',
                hoverBorderColor: '#ffffff',
                hoverOffset: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    rtl: true,
                    labels: {
                        padding: 20,
                        font: {
                            size: 13,
                            family: 'Cairo'
                        },
                        color: '#333'
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(255, 255, 255, 0.95)',
                    titleColor: '#333',
                    bodyColor: '#666',
                    bodyFont: {
                        family: 'Cairo'
                    },
                    titleFont: {
                        family: 'Cairo',
                        weight: 'bold'
                    },
                    padding: 12,
                    boxPadding: 8,
                    borderColor: '#e1e1e1',
                    borderWidth: 1,
                    displayColors: true,
                    rtl: true
                }
            },
            cutout: '75%',
            radius: '90%'
        }
    });

    // Graphique 3 : Timeline des statuts
    new Chart(ctx3, {
        type: 'bar',
        data: {
            labels: ['<?php echo e(now()->format('F')); ?>', '<?php echo e(now()->subMonth(1)->format('F')); ?>', '<?php echo e(now()->subMonth(2)->format('F')); ?>', '<?php echo e(now()->subMonth(3)->format('F')); ?>'],
            datasets: [{
                label: 'قيد المراجعة',
                data: [15, 12, 10, 8],
                backgroundColor: '#e42125',
                borderRadius: 6,
                borderSkipped: false
            }, {
                label: 'مقبولة',
                data: [20, 25, 30, 35],
                backgroundColor: 'rgba(228, 33, 37, 0.7)',
                borderRadius: 6,
                borderSkipped: false
            }, {
                label: 'مرفوضة',
                data: [5, 3, 2, 1],
                backgroundColor: 'rgba(228, 33, 37, 0.4)',
                borderRadius: 6,
                borderSkipped: false
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                    rtl: true,
                    labels: {
                        padding: 20,
                        font: {
                            size: 13,
                            family: 'Cairo'
                        },
                        color: '#333'
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(255, 255, 255, 0.95)',
                    titleColor: '#333',
                    bodyColor: '#666',
                    bodyFont: {
                        family: 'Cairo'
                    },
                    titleFont: {
                        family: 'Cairo',
                        weight: 'bold'
                    },
                    padding: 12,
                    boxPadding: 8,
                    borderColor: '#e1e1e1',
                    borderWidth: 1,
                    displayColors: true,
                    rtl: true
                }
            },
            scales: {
                x: {
                    stacked: true,
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: {
                            family: 'Cairo',
                            size: 12
                        },
                        color: '#666'
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        drawBorder: false,
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        font: {
                            family: 'Cairo',
                            size: 12
                        },
                        color: '#666'
                    }
                }
            }
        }
    });
});
</script>

    </div>
</div>

<style>
/* Styles des mini-stats */
.mini-stat-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    transition: all 0.3s ease;
    height: 100%;
    border: 1px solid #f0f0f0;
}

.mini-stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(228, 33, 37, 0.1);
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    transition: all 0.3s ease;
    background: var(--light-red);
    color: var(--primary-red);
    box-shadow: 0 4px 15px rgba(228, 33, 37, 0.1);
}

.mini-stat-card:hover .stat-icon {
    background: var(--primary-red);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(228, 33, 37, 0.2);
}

.stat-content {
    flex-grow: 1;
    text-align: left;
}

.stat-value {
    font-size: 22px;
    font-weight: 600;
    color: var(--primary-red);
    margin: 0;
    line-height: 1.2;
}



[data-theme='dark'] .mini-stat-card {
    background: #1a1a1a;
}

[data-theme='dark'] .stat-value {
    color: white;
}

[data-theme='dark'] .stat-label {
    color: #888;
}

/* Styles des cartes statistiques */
.stat-card {
    position: relative;
    overflow: hidden;
}

.stat-card .stat-icon {
    width: 54px;
    height: 54px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 15px;
    font-size: 1.6rem;
    background: var(--navy-blue);
    color: #ffffff;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(228, 33, 37, 0.1);
}

.stat-card:hover .stat-icon {
    background: var(--primary-red);
    color: white;
    transform: scale(1.1) translateY(-2px);
    box-shadow: 0 6px 20px rgba(228, 33, 37, 0.2);
}

.stat-card h3 {
    font-size: 2rem;
    font-weight: 600;
    color: var(--primary-red);
    margin: 1rem 0;
}

.stat-card .progress {
    height: 8px;
    border-radius: 4px;
    background: var(--light-red);
    overflow: hidden;
}

.stat-card .progress-bar {
    border-radius: 4px;
    background: var(--primary-red);
}

.stat-card:nth-child(3n-1) .stat-icon {
     background: #e42125;
    color: #ffffff;
    box-shadow: 0 4px 15px rgba(26, 35, 126, 0.1);
}

.stat-card:nth-child(3n-1):hover .stat-icon {
    background: var(--navy-blue);
    color: white;
    box-shadow: 0 6px 20px rgba(26, 35, 126, 0.2);
}

.stat-card:nth-child(3n-1) h3 {
    color: var(--navy-blue);
}

:root {
    --primary-red: #e42125;
    --light-red: rgba(228, 33, 37, 0.1);
    --navy-blue: #1a237e;
    --light-navy: rgba(26, 35, 126, 0.1);
}

.dashboard-content {
    padding: 2rem;
}

.card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(26, 35, 126, 0.1);
}

.stat-card .stat-icon {
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 12px;
    font-size: 1.5rem;
}

.stat-card .progress {
    height: 6px;
    border-radius: 3px;
    background: var(--light-navy);
}

.stat-card .progress-bar {
    border-radius: 3px;
}

.bg-danger-light {
    background: var(--light-red) !important;
}

.bg-navy-light {
    background: var(--light-navy) !important;
}

.text-navy {
    color: var(--navy-blue) !important;
}

.text-danger {
    color: var(--primary-red) !important;
}

.card-title {
    color: var(--navy-blue);
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 1.5rem;
}

/* Styles spécifiques aux graphiques */
.chart-container {
    position: relative;
    padding: 1rem;
    border-radius: 15px;
    background: white;
}

.chart-container canvas {
    margin: 1rem 0;
}

[data-theme='dark'] .card {
    background: #1a1a1a;
    box-shadow: 0 8px 25px rgba(0,0,0,0.2);
}

[data-theme='dark'] .card-title {
    color: white;
}

[data-theme='dark'] .stat-card .progress {
    background: rgba(255,255,255,0.1);
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/dashboard-content.blade.php ENDPATH**/ ?>