<?php echo csrf_field(); ?>
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; }
  .form-required::after { content: " *"; color: #d9534f; }
</style>

<div class="block-card mb-4">
  <div class="block-card-header">
    <h2 class="widget-title"><?php echo e($formTitle ?? 'نموذج السلايدر'); ?></h2>
    <div class="stroke-shape"></div>
  </div>

  <div class="block-card-body">

    
    <div class="form-group row mb-3">
        <div class="col-md-4">
            <label class="form-required">العنوان بالعربية</label>
            <input type="text"
                name="titre_ar"
                class="form-control js-text required-field"
                value="<?php echo e(old('titre_ar', $slider->titre_ar ?? '')); ?>"
                maxlength="100"
                data-max="100"
                required>
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-4">
            <label class="form-required">العنوان بالفرنسية</label>
            <input type="text"
                name="titre_fr"
                class="form-control js-text required-field"
                value="<?php echo e(old('titre_fr', $slider->titre_fr ?? '')); ?>"
                maxlength="100"
                data-max="100"
                required>
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-4">
            <label class="form-required">العنوان بالإنجليزية</label>
            <input type="text"
                name="titre_en"
                class="form-control js-text required-field"
                value="<?php echo e(old('titre_en', $slider->titre_en ?? '')); ?>"
                maxlength="100"
                data-max="100"
                required>
            <span class="field-error"></span>
        </div>
    </div>

    
    <div class="form-group row mb-3">
        <div class="col-md-4">
            <label>العنوان الفرعي بالعربية</label>
            <input type="text"
                name="soustitre_ar"
                class="form-control js-text"
                value="<?php echo e(old('soustitre_ar', $slider->soustitre_ar ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-4">
            <label>العنوان الفرعي بالفرنسية</label>
            <input type="text"
                name="soustitre_fr"
                class="form-control js-text"
                value="<?php echo e(old('soustitre_fr', $slider->soustitre_fr ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-4">
            <label>العنوان الفرعي بالإنجليزية</label>
            <input type="text"
                name="soustitre_en"
                class="form-control js-text"
                value="<?php echo e(old('soustitre_en', $slider->soustitre_en ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
    </div>

    
    <label style="color:black; font-weight:bold;">الزر 1 :</label>
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 1 بالعربية</label>
            <input type="text"
                name="titre_bouton_ar"
                class="form-control js-text"
                value="<?php echo e(old('titre_bouton_ar', $slider->titre_bouton_ar ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
       
        <div class="col-md-6">
            <label>رابط الزر 1 بالعربية</label>
            <input type="text"
                name="lien_bouton_ar"
                class="form-control js-url url-field"
                value="<?php echo e(old('lien_bouton_ar', $slider->lien_bouton_ar ?? '')); ?>"
                maxlength="255"
                data-max="255">
            <span class="field-error"></span>
        </div>
    </div>

    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 1 بالفرنسية</label>
            <input type="text"
                name="titre_bouton_fr"
                class="form-control js-text"
                value="<?php echo e(old('titre_bouton_fr', $slider->titre_bouton_fr ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-6">
            <label>رابط الزر 1 بالفرنسية</label>
            <input type="text"
                name="lien_bouton_fr"
                class="form-control js-url url-field"
                value="<?php echo e(old('lien_bouton_fr', $slider->lien_bouton_fr ?? '')); ?>"
                maxlength="255"
                data-max="255">
            <span class="field-error"></span>
        </div>
    </div>
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 1 بالإنجليزية</label>
            <input type="text"
                name="titre_bouton_en"
                class="form-control js-text"
                value="<?php echo e(old('titre_bouton_en', $slider->titre_bouton_en ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-6">
            <label>رابط الزر 1 بالإنجليزية</label>
            <input type="text"
                name="lien_bouton_en"
                class="form-control js-url url-field"
                value="<?php echo e(old('lien_bouton_en', $slider->lien_bouton_en ?? '')); ?>"
                maxlength="255"
                data-max="255">
            <span class="field-error"></span>
        </div>
    </div>

    
    <label style="color:black; font-weight:bold;">الزر 2 :</label>
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 2 بالعربية</label>
            <input type="text"
                name="titre_bouton2_ar"
                class="form-control js-text"
                value="<?php echo e(old('titre_bouton2_ar', $slider->titre_bouton2_ar ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-6">
            <label>رابط الزر 2 بالعربية</label>
            <input type="text"
                name="lien_bouton2_ar"
                class="form-control js-url url-field"
                value="<?php echo e(old('lien_bouton2_ar', $slider->lien_bouton2_ar ?? '')); ?>"
                maxlength="255"
                data-max="255">
            <span class="field-error"></span>
        </div>
    </div>

    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 2 بالفرنسية</label>
            <input type="text"
                name="titre_bouton2_fr"
                class="form-control js-text"
                value="<?php echo e(old('titre_bouton2_fr', $slider->titre_bouton2_fr ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
         
        <div class="col-md-6">
            <label>رابط الزر 2 بالفرنسية</label>
            <input type="text"
                name="lien_bouton2_fr"
                class="form-control js-url url-field"
                value="<?php echo e(old('lien_bouton2_fr', $slider->lien_bouton2_fr ?? '')); ?>"
                maxlength="255"
                data-max="255">
            <span class="field-error"></span>
        </div>
    </div>

    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 2 بالإنجليزية</label>
            <input type="text"
                name="titre_bouton2_en"
                class="form-control js-text"
                value="<?php echo e(old('titre_bouton2_en', $slider->titre_bouton2_en ?? '')); ?>"
                maxlength="100"
                data-max="100">
            <span class="field-error"></span>
        </div>
        
        <div class="col-md-6">
            <label>رابط الزر 2 بالإنجليزية</label>
            <input type="text"
                name="lien_bouton2_en"
                class="form-control js-url url-field"
                value="<?php echo e(old('lien_bouton2_en', $slider->lien_bouton2_en ?? '')); ?>"
                maxlength="255"
                data-max="255">
            <span class="field-error"></span>
        </div>
    </div>

    
    <div class="form-group mb-3">
        <label class="<?php echo e(empty($slider->image) ? 'form-required' : ''); ?>">
            صورة السلايدر
        </label>

        <input type="file"
            name="image"
            class="form-control js-file image-field"
            accept="image/*"
            <?php if(empty($slider->image)): ?> required <?php endif; ?>>

        <?php if(!empty($slider->imageSrc)): ?>
            <div class="mt-2">
                <img src="<?php echo e($slider->imageSrc); ?>"
                     alt="صورة السلايدر"
                     style="height:100px;border-radius:8px; object-fit:cover;">
            </div>
        <?php else: ?>
            <span class="text-muted">—</span>
        <?php endif; ?>

        <span class="field-error"></span>

        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

  </div>

  <div class="block-card-footer mt-3 mb-3 text-center">
    <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" id="submitBtn">
      <i class="la la-save mr-1"></i> حفظ
    </button>
    <a href="<?php echo e(route('sliders.index')); ?>" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-times mr-1"></i> إلغاء
    </a>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    let isFormSubmitted = false;
    let hasValidationErrors = false;
    const submitBtn = document.getElementById('submitBtn');
    const form = document.querySelector('form');

    // إدارة حالة زر الإرسال
    function setSubmitButtonState(isDisabled) {
        submitBtn.disabled = isDisabled;
        submitBtn.innerHTML = isDisabled 
            ? '<i class="la la-spinner la-spin mr-1"></i> جاري التحقق...'
            : '<i class="la la-save mr-1"></i> حفظ';
    }

    function showError(input, message) {
        hasValidationErrors = true;
        input.classList.add('is-invalid');
        let error = input.parentNode.querySelector('.field-error');
        if (!error) {
            error = document.createElement('div');
            error.className = 'field-error';
            input.parentNode.appendChild(error);
        }
        error.innerText = message;
        error.style.display = 'block';
    }

    function clearError(input) {
        input.classList.remove('is-invalid');
        let error = input.parentNode.querySelector('.field-error');
        if (error) error.style.display = 'none';
    }

    // دالة محسنة للتحقق من صحة الرابط - مقبولة لكل من create و edit
    function isValidUrl(url) {
        const value = url.trim();
        
        if (value === '') {
            return true; // رابط فارغ مقبول
        }

        // 1. قبول الروابط الداخلية (anchors): #contactForm, #section, #about-us
        if (value.startsWith('#')) {
            // يجب أن يحتوي على حرف واحد على الأقل بعد #
            return value.length > 1 && /^#[a-zA-Z0-9\-_]+$/.test(value);
        }
        
        // 2. قبول المسارات النسبية: /page, ./file, ../parent, /about-us
        if (value.startsWith('/') || value.startsWith('./') || value.startsWith('../')) {
            // يجب أن يحتوي على حرف واحد على الأقل بعد الشرطة المائلة
            const pathWithoutPrefix = value.replace(/^(\/|\.\/|\.\.\/)/, '');
            return pathWithoutPrefix.length > 0;
        }
        
        // 3. قبول أسماء الصفحات البسيطة: contact, about-us, home_page
        if (/^[a-zA-Z0-9\-_]+$/.test(value)) {
            return true;
        }
        
        // 4. قبول الروابط الكاملة: https://example.com, http://site.com/page
        // 5. قبول الروابط بدون بروتوكول: example.com, www.site.com/page
        
        try {
            // إضافة https:// إذا لم يكن هناك بروتوكول
            const urlToCheck = value.includes('://') ? value : 'https://' + value;
            const urlObj = new URL(urlToCheck);
            
            // أنماط النطاقات المقبولة
            const domainPatterns = [
                /^[a-zA-Z0-9\-]+(\.[a-zA-Z0-9\-]+)*\.[a-zA-Z]{2,}$/, // example.com, sub.example.com
                /^[a-zA-Z0-9\-]+$/, // localhost (بدون نقطة)
                /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/, // IP addresses
                /^\[[a-fA-F0-9:]+\]$/ // IPv6 addresses
            ];
            
            // التحقق من أن النطاق صالح
            const hostname = urlObj.hostname;
            const isValidHostname = domainPatterns.some(pattern => pattern.test(hostname));
            
            return isValidHostname;
            
        } catch (error) {
            // إذا فشل تحليل URL، قد يكون الرابط غير كامل ولكن صحيح
            // مثل: example (بدون .com) أو رابط غير مكتمل
            
            // قبول الروابط غير المكتملة التي تحتوي على مسار فقط
            if (/^[a-zA-Z0-9\-_\/.]+$/.test(value)) {
                return true;
            }
            
            return false;
        }
    }

    // التحقق من جميع الحقول المطلوبة
    function validateRequiredFields() {
        let hasError = false;
        
        // الحقول المطلوبة
        document.querySelectorAll('.required-field').forEach(input => {
            if (!input.value.trim()) {
                showError(input, 'هذا الحقل مطلوب');
                hasError = true;
            }
        });

        // حقل الصورة المطلوب في حالة الإنشاء
        const imageInput = document.querySelector('.image-field');
        const hasExistingImage = document.querySelector('img[src*="sliders"]') || document.querySelector('img[alt="صورة السلايدر"]');
        
        if (imageInput.hasAttribute('required') && !imageInput.files.length && !hasExistingImage) {
            showError(imageInput, 'هذا الحقل مطلوب');
            hasError = true;
        }

        return !hasError;
    }

    // التحقق من صحة الروابط
    function validateUrls() {
        let hasError = false;
        
        document.querySelectorAll('.url-field').forEach(input => {
            const value = input.value.trim();
            if (value && !isValidUrl(value)) {
                showError(input, 'الرابط غير صالح. أمثلة مقبولة: #contactForm, /about, contact, about-us, https://site.com');
                hasError = true;
            }
        });

        return !hasError;
    }

    // التحقق من الحد الأقصى للأحرف
    function validateMaxLength() {
        let hasError = false;
        
        document.querySelectorAll('.js-text').forEach(input => {
            const max = parseInt(input.dataset.max || input.maxLength);
            if (input.value.length > max) {
                showError(input, `الحد الأقصى ${max} حرف`);
                hasError = true;
            }
        });

        document.querySelectorAll('.url-field').forEach(input => {
            const max = parseInt(input.dataset.max || input.maxLength);
            if (input.value.length > max) {
                showError(input, `الحد الأقصى ${max} حرف`);
                hasError = true;
            }
        });

        return !hasError;
    }

    // التحقق من نوع وحجم الملف
    function validateFile() {
        const imageInput = document.querySelector('.image-field');
        if (imageInput.files.length === 0) return true;

        let hasError = false;
        const file = imageInput.files[0];
        const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        const maxSize = 5 * 1024 * 1024; // 5MB
        
        if (!validTypes.includes(file.type)) {
            showError(imageInput, 'الرجاء اختيار صورة (JPEG, PNG, GIF, WebP)');
            hasError = true;
        } else if (file.size > maxSize) {
            showError(imageInput, 'حجم الصورة كبير جداً (الحد الأقصى 5MB)');
            hasError = true;
        }

        return !hasError;
    }

    // التحقق الكامل للنموذج
    function validateForm() {
        hasValidationErrors = false;
        
        // مسح جميع الأخطاء السابقة
        document.querySelectorAll('.field-error').forEach(error => {
            error.style.display = 'none';
        });
        document.querySelectorAll('.is-invalid').forEach(input => {
            input.classList.remove('is-invalid');
        });

        // تنفيذ جميع عمليات التحقق
        const isRequiredValid = validateRequiredFields();
        const isUrlValid = validateUrls();
        const isLengthValid = validateMaxLength();
        const isFileValid = validateFile();

        // إرجاع النتيجة النهائية
        return isRequiredValid && isUrlValid && isLengthValid && isFileValid;
    }

    /* ===== TEXT LIMIT CONTROL ===== */
    document.querySelectorAll('.js-text').forEach(input => {
        const max = parseInt(input.dataset.max || input.maxLength);

        input.addEventListener('input', function () {
            if (this.value.length > max) {
                this.value = this.value.slice(0, max);
                showError(this, `الحد الأقصى ${max} حرف`);
                return;
            }
            clearError(this);
        });

        input.addEventListener('paste', function (e) {
            e.preventDefault();
            let paste = (e.clipboardData || window.clipboardData).getData('text');
            paste = paste.slice(0, max);
            this.value = paste;
            showError(this, `الحد الأقصى ${max} حرف`);
        });
    });

    /* ===== URL VALIDATION ===== */
    document.querySelectorAll('.js-url').forEach(input => {
        function validateUrlInput() {
            const value = this.value.trim();
            
            if (value === '') {
                clearError(this);
                return;
            }

            if (!isValidUrl(value)) {
                showError(this, 'الرابط غير صالح. أمثلة مقبولة: #contactForm, /about, contact, about-us, https://site.com');
            } else {
                clearError(this);
            }
        }

        input.addEventListener('input', validateUrlInput);
        input.addEventListener('blur', validateUrlInput);
        input.addEventListener('change', validateUrlInput);
        
        // التحقق التلقائي للقيم الموجودة عند تحميل الصفحة (للمرة الأولى)
        if (input.value.trim()) {
            // تأخير بسيط لضمان تحميل DOM بالكامل
            setTimeout(() => {
                validateUrlInput.call(input);
            }, 100);
        }
    });

    /* ===== FILE VALIDATION ===== */
    document.querySelectorAll('.js-file').forEach(input => {
        input.addEventListener('change', function() {
            clearError(this);
            
            // التحقق من نوع الملف
            if (this.files.length) {
                const file = this.files[0];
                const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
                const maxSize = 5 * 1024 * 1024; // 5MB
                
                if (!validTypes.includes(file.type)) {
                    showError(this, 'الرجاء اختيار صورة (JPEG, PNG, GIF, WebP)');
                } else if (file.size > maxSize) {
                    showError(this, 'حجم الصورة كبير جداً (الحد الأقصى 5MB)');
                }
            }
        });
    });

    // التحقق عند فقدان التركيز من الحقول المطلوبة
    document.querySelectorAll('.required-field').forEach(input => {
        input.addEventListener('blur', function() {
            if (isFormSubmitted && !this.value.trim()) {
                showError(this, 'هذا الحقل مطلوب');
            }
        });
    });

    // التحقق قبل الإرسال
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // تعطيل زر الإرسال أثناء التحقق
        setSubmitButtonState(true);
        
        // إجراء التحقق
        const isValid = validateForm();
        
        if (isValid) {
            // إذا كان كل شيء صحيحاً، أرسل النموذج
            isFormSubmitted = true;
            form.submit();
        } else {
            // إذا كان هناك أخطاء، أظهرها وعدّل زر الإرسال
            setSubmitButtonState(false);
            isFormSubmitted = true;
            
            // التمرير إلى أول خطأ
            const firstError = document.querySelector('.is-invalid');
            if (firstError) {
                firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                firstError.focus();
            }
        }
    });

    // التحقق الفوري بعد محاولة الإرسال الأولى
    document.querySelectorAll('.js-url').forEach(input => {
        input.addEventListener('input', function() {
            if (isFormSubmitted) {
                const value = this.value.trim();
                if (value && !isValidUrl(value)) {
                    showError(this, 'الرابط غير صالح');
                } else {
                    clearError(this);
                }
            }
        });
    });

    // التحقق من الحقول المطلوبة بعد محاولة الإرسال الأولى
    document.querySelectorAll('.required-field').forEach(input => {
        input.addEventListener('input', function() {
            if (isFormSubmitted && !this.value.trim()) {
                showError(this, 'هذا الحقل مطلوب');
            }
        });
    });

    // التحقق التلقائي للروابط الموجودة عند تحميل الصفحة (بشكل مباشر)
    function validateInitialUrls() {
        document.querySelectorAll('.js-url').forEach(input => {
            if (input.value.trim()) {
                const value = input.value.trim();
                if (!isValidUrl(value)) {
                    showError(input, 'الرابط غير صالح. أمثلة مقبولة: #contactForm, /about, contact, about-us, https://site.com');
                }
            }
        });
    }

    // تنفيذ التحقق التلقائي عند تحميل الصفحة
    setTimeout(validateInitialUrls, 300);
});
</script><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/sliders/form.blade.php ENDPATH**/ ?>