<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<style>
    .dir-rtl { direction: rtl; text-align: right; }
    .block-card { border-radius:12px; box-shadow:0 6px 18px rgba(0,0,0,0.06); background:#fff; }
    .block-card-header { padding:20px; border-bottom:1px solid #eee; }
    .block-card-body { padding:20px; }
    .small-muted { color:#6c757d; font-size:.9rem; }
    .room-box { border:1px solid #eee; border-radius:10px; padding:15px; transition:.2s; }
    .room-box:hover { box-shadow:0 4px 15px rgba(0,0,0,0.08); }
    .btn-choose { border-radius:8px; padding:8px; }
    .room-disabled { border: 2px solid #dc3545 !important; background: #ffe5e5 !important; opacity: 0.85;}
    .room-disabled:hover {box-shadow: 0 0 10px rgba(220,53,69,0.6) !important;}
    .btn-disabled {background: #dc3545 !important;border: none;cursor: not-allowed !important;opacity: 0.9;}
    .progress-bar.bg-pink {background-color: #ff6b81;}
    .assigned-rooms .badge {font-size: 0.85rem;}
</style>

<div class="container dir-rtl mt-4">
    <div class="row mt-4">
        <div class="col-lg-9">
            <div class="block-card mb-4">
                    <?php
                        $affectations = \App\Models\ReservationChambreTente::where('reservation_id', $reservation->id_reserv)->get();
                        $total_aff_male = $affectations->sum('male_personnes');
                        $total_aff_female = $affectations->sum('female_personnes');
                        $allAssigned = ($total_aff_male >= $male) && ($total_aff_female >= $female);
                    ?>
                <div class="block-card-header">
                    <div class="row align-items-start">
                        <div class="col-md-6">
                            <h3 class="mb-1">
                                تعيين غرفة للحجز رقم:
                                <strong class="text-danger"><?php echo e($reservation->id_reserv); ?></strong>
                            </h3>
                            <div class="small-muted">
                                المركب:
                                <strong><?php echo e($reservation->auberge->nom_ar); ?></strong>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="block-card-body">
                    <div class="mb-4">
                        <p class="mb-1">
                            <strong>تاريخ الوصول:</strong> <?php echo e($reservation->date_arrive); ?> —
                            <strong>تاريخ المغادرة:</strong> <?php echo e($reservation->date_depart); ?>

                        </p>
                        <p class="mb-1">
                            <strong>عدد الذكور:</strong> <?php echo e($male); ?>

                            <strong>عدد الاناث:</strong> <?php echo e($female); ?>

                            <strong>المجموع:</strong> <?php echo e($reservation->nbr_personnes); ?>

                        </p>
                        <small class="small-muted">اختر غرفة مناسبة من القائمة التالية.</small>
                    </div>
                    <div class="row g-3">
                        <?php $__empty_1 = true; $__currentLoopData = $chambres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $aff = \App\Models\ReservationChambreTente::where('chambre_tente_id',$ch->id_chambre_tente)->sum('total_personnes');
                            $reste = $ch->capacite - $aff;
                        ?>

                        <div class="col-md-4">
                            <div class="room-box <?php echo e($reste == 0 ? 'room-disabled' : ''); ?>">

                                <h5 class="mb-2">الغرفة رقم: <strong><?php echo e($ch->num_chambre); ?></strong></h5>
                                <p class="small-muted">الطاقة الإجمالية: <?php echo e($ch->capacite); ?></p>
                                <p class="small-muted <?php echo e($reste == 0 ? 'text-danger' : 'text-success'); ?>">
                                    الطاقة المتبقية: <?php echo e($reste); ?>

                                </p>

                                <?php
                                    $disabledRoom = ($reste == 0) || $allAssigned;
                                ?>

                                <button class="btn w-100 btn-choose
                                    <?php echo e($disabledRoom ? 'btn-disabled' : 'bg-rgb-primary1 text-white'); ?>"
                                    <?php echo e($disabledRoom ? 'disabled' : ''); ?>

                                    onclick="<?php echo e($disabledRoom ? '' : 'showForm('.$ch->id_chambre_tente.')'); ?>">
                                    اختيار هذه الغرفة
                                </button>

                                <form id="form-<?php echo e($ch->id_chambre_tente); ?>"
                                      action="<?php echo e(route('reservation.assignChambre', $reservation->id_reserv)); ?>"
                                      method="POST"
                                      class="mt-3 d-none"
                                      data-reste="<?php echo e($reste); ?>"
                                      onsubmit="return validateForm(this, <?php echo e($male); ?>, <?php echo e($female); ?>)">

                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="chambre_id" value="<?php echo e($ch->id_chambre_tente); ?>">

                                    <div class="mb-2">
                                        <label>اختيار الجنس:</label>

                                        <?php
                                            $remainMale = $male - $total_aff_male;
                                            $remainFemale = $female - $total_aff_female;
                                            $defaultSex = '';

                                            if ($remainMale == 0 && $remainFemale > 0) {
                                                $defaultSex = 'female';
                                            } elseif ($remainFemale == 0 && $remainMale > 0) {
                                                $defaultSex = 'male';
                                            }
                                        ?>

                                        <select class="form-control sexe-select"
                                                name="sexe"
                                                onchange="toggleInputs(this)"
                                                data-remaining-male="<?php echo e($remainMale); ?>"
                                                data-remaining-female="<?php echo e($remainFemale); ?>">

                                            <?php if($defaultSex == ''): ?>
                                                <option value="">-- اختر --</option>
                                                <option value="male">ذكور</option>
                                                <option value="female">إناث</option>
                                            <?php elseif($defaultSex == 'male'): ?>
                                                <option value="male" selected>ذكور</option>
                                            <?php elseif($defaultSex == 'female'): ?>
                                                <option value="female" selected>إناث</option>
                                            <?php endif; ?>

                                        </select>
                                    </div>
                                    <div class="mb-2 input-male d-none">
                                        <label>عدد الذكور:</label>
                                        <input type="number" name="male_personnes" class="form-control" min="0" value="0">
                                    </div>

                                    <div class="mb-2 input-female d-none">
                                        <label>عدد الاناث:</label>
                                        <input type="number" name="female_personnes" class="form-control" min="0" value="0">
                                    </div>
                                    <button class="btn bg-rgb-primary1 text-white w-100 mt-2">
                                        تأكيد التعيين
                                    </button>
                                </form>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12 text-center text-danger">
                            لا توجد غرف متاحة حاليا في هذا المركب.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="block-card p-3">

                <h5 class="mb-4" style="color:#c51b01;"><i class="la la-list-check me-2"></i>ملخص التعيينات</h5>

                <div class="mb-4 d-flex justify-content-around text-center">
                    <div>
                        <div class="h5" style="color:#1a237e;"><?php echo e($total_aff_male); ?>/<?php echo e($male); ?></div>
                        <small class="small-muted d-block">ذكور</small>
                        <div class="progress rounded-pill" style="height: 10px; width: 80px; margin: auto;">
                            <div class="progress-bar" role="progressbar" 
                                style="background-color:#1a237e; width: <?php echo e($total_aff_male / max($male,1) * 100); ?>%">
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="h5" style="color:#c51b01;"><?php echo e($total_aff_female); ?>/<?php echo e($female); ?></div>
                        <small class="small-muted d-block">إناث</small>
                        <div class="progress rounded-pill" style="height: 10px; width: 80px; margin: auto;">
                            <div class="progress-bar bg-pink" role="progressbar"
                                style="background-color:#c51b01;width: <?php echo e($total_aff_female / max($female,1) * 100); ?>%">
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <h6 class="mb-2" style="color:#c51b01;"><i class="la la-bed me-1"></i>الغرف المعيّنة</h6>
                <div class="assigned-rooms" style="max-height: 400px; overflow-y: auto;">
                    <?php $__empty_1 = true; $__currentLoopData = $affectations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="mb-2 p-2 rounded shadow-sm d-flex justify-content-between align-items-center bg-light">
                            <div>
                                <strong>الغرفة <?php echo e($aff->chambre->num_chambre ?? 'غير معروف'); ?></strong>
                                <div class="small text-muted mt-1">
                                    👨 <?php echo e($aff->male_personnes); ?> — 👩 <?php echo e($aff->female_personnes); ?>

                                </div>
                            </div>
                            <span class="btn bg-rgb-primary1 text-white"><?php echo e($aff->total_personnes); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-muted text-center py-3">لا توجد تعيينات بعد.</div>
                    <?php endif; ?>

                    <div class="text-center mt-3">
                        <a href="<?php echo e(route('reservation.index')); ?>" style="background-color:#1a237e;" class="btn btn-primary w-100">
                            <i class="la la-arrow-right me-1"></i> العودة
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function showForm(id) {
        document.querySelectorAll("form[id^='form-']").forEach(f => f.classList.add('d-none'));
        document.getElementById('form-' + id).classList.remove('d-none');
    }
    function toggleInputs(select) {
        let form = select.closest("form");
        let maleRemain = parseInt(select.dataset.remainingMale);
        let femaleRemain = parseInt(select.dataset.remainingFemale);

        let maleInput = form.querySelector(".input-male");
        let femaleInput = form.querySelector(".input-female");

        maleInput.classList.add("d-none");
        femaleInput.classList.add("d-none");

        if (select.value === "male") {
            maleInput.classList.remove("d-none");
            form.male_personnes.max = maleRemain;
        }

        if (select.value === "female") {
            femaleInput.classList.remove("d-none");
            form.female_personnes.max = femaleRemain;
        }
    }
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".sexe-select").forEach(sel => {
            if (sel.value === "male" || sel.value === "female") {
                toggleInputs(sel);
            }
        });
    });

    function validateForm(form, maxMale, maxFemale) {

        let sexe = form.sexe.value;
        let male = parseInt(form.male_personnes?.value || 0);
        let female = parseInt(form.female_personnes?.value || 0);
        let total = male + female;
        let errors = [];

        if (!sexe) errors.push("❗ الرجاء اختيار الجنس");
        if (total === 0) errors.push("❗ الرجاء إدخال عدد الأشخاص");

        let capaciteRestante = parseInt(form.getAttribute("data-reste"));
        if (total > capaciteRestante)
            errors.push("⚠️ العدد يتجاوز الطاقة المتبقية (" + capaciteRestante + ")");

        if (male > maxMale)
            errors.push("⚠️ عدد الرجال يتجاوز العدد المتبقي (" + maxMale + ")");

        if (female > maxFemale)
            errors.push("⚠️ عدد النساء يتجاوز العدد المتبقي (" + maxFemale + ")");

        if (errors.length > 0) {
            Swal.fire({
                icon: 'error',
                title: "خطأ",
                html: errors.join("<br>"),
            });
            return false;
        }

        return true;
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/reservation/affecter_chambres.blade.php ENDPATH**/ ?>