

<?php $__env->startSection('content'); ?>
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">استثمارات رياضية</h2>
                    <a class="btn btn-success font-weight-medium" href="<?php echo e(route('admin.formation.create')); ?>">
                        <i class="la la-plus mr-1"></i> إضافة استثمار رياضي
                    </a>
                </div>

                <div class="block-card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>الاسم و اللقب</th>
                                    <th>طبيعة المشروع</th>
                                    <th width="15%">وضعية الطلب</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $formations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($formation->id_inv_sport); ?></td>
                                    <td><?php echo e($formation->investissements->first()?->utilisateur?->nom_prenom ?? '---'); ?></td>
                                    <td><?php echo e($formation->natureProjet?->nature_ar ?? '---'); ?></td>
                                    <td>
                                        <span class="badge 
                                            <?php echo e($formation->id_statut == 1 ? 'badge-success' : ($formation->id_statut == 3 ? 'badge-danger' : 'badge-secondary')); ?>">
                                            <?php echo e($formation->statut?->statut_ar ?? 'في الانتظار'); ?>

                                        </span>
                                    </td>

                                    <td class="btn-group">
                                        <a class="btn btn-info btn-sm mr-2" href="<?php echo e(route('admin.formation.show', $formation->id_inv_sport)); ?>">
                                            <i class="la la-eye mr-1"></i> عرض
                                        </a>

                                        <?php if($formation->id_statut == 2): ?>
                                            <a class="btn btn-orange btn-sm mr-2" style="color:white;"
                                               onclick="return confirmAction('هل تريد حقًا تعديل هذا الاستثمار؟', '<?php echo e(route('admin.formation.edit', $formation->id_inv_sport)); ?>')">
                                                <i class="la la-edit mr-1"></i> تعديل
                                            </a>

                                            <form action="<?php echo e(route('admin.formation.toggle_statut', $formation->id_inv_sport)); ?>" 
                                                method="POST" 
                                                class="form-modifier-statut mr-2" 
                                                style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>

                                                <button type="button" 
                                                    onclick="confirmStatusChange(this.closest('form'), '<?php echo e($formation->statut?->statut_ar); ?>')" 
                                                    class="btn btn-sm btn-secondary">
                                                    <i class="la la-toggle-on mr-1"></i>
                                                    تغيير الحالة
                                                </button>
                                            </form>
                                            <form action="<?php echo e(route('admin.formation.destroy', $formation->id_inv_sport)); ?>" 
                                                  method="POST" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="button" 
                                                        onclick="return confirmAction('هل تريد حذف هذا الاستثمار؟', null, this.closest('form'))" 
                                                        class="btn btn-danger btn-sm mr-2">
                                                    <i class="la la-trash mr-1"></i> حذف
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">لا توجد استثمارات رياضية</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <?php echo e($formations->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\mounir pc\projet MJS\back\resources\views/backoffice/investissement/gestion_formation_stage/index.blade.php ENDPATH**/ ?>