<?php $__env->startSection('title', 'قائمة الأخبار'); ?>

<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">       
				<div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title m-0"> قائمة التتويجات الرياضية</h2>
                    <a class="btn btn-success btn-sm px-3" href="<?php echo e(route('trophee_sportif.create')); ?>">
                        <i class="la la-plus me-1"></i> إضافة تتويج رياضي
                    </a>
                </div>
				<div class="block-card-header px-4 border-bottom-0 pb-3">
					<form method="GET" action="<?php echo e(route('trophee_sportif.index')); ?>">
						<div class="form-row align-items-center" style="direction: rtl;">
							<div class="col-auto" style="width: 250px;">
								<input 
									type="text" 
									class="form-control" 
									name="search" 
									placeholder="بحث بالعربية أو الإنجليزية أو الفرنسية" 
									value="<?php echo e(request('search')); ?>"
								>
							</div>

							<div class="col d-flex">
								<button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
									بحث
								</button>
								<a href="<?php echo e(route('trophee_sportif.index')); ?>"
								   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
								   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
									<i class="fa-solid fa-rotate-right"></i>
								</a>
							</div>
						</div>
					</form>
				</div>

								   <div class="block-card-body">          
				   <?php if(session('success')): ?>            
					   <div class="alert alert-success alert-dismissible fade show" role="alert">        
                              <?php echo e(session('success')); ?>             
                               <button type="button" class="btn-close" data-bs-dismiss="alert"></button>      
                                  </div>          
                                  <?php endif; ?>         
                        <div class="my-table table-responsive" style="direction: rtl; text-align: right;">        
                        <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">           
                                   <thead class="thead-light">          
                                 <tr>                     
                                   <th>المعرف</th>
                                    <th style="width: 25%">تمت الإضافة بواسطة</th>
                                    <th style="width: 25%">العنوان</th>
                                    <th style="width: 20%">الصورة / YouTube</th>
                                    <th style="width: 10%">منشور</th>
                                    <th style="width: 15%">التاريخ</th>
                                    <th style="width: 20%">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $trophee_sportif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($item->id_sport); ?></td>
                                        <td><?php echo e($item->utilisateur ? $item->utilisateur->nom_prenom : 'غير محدد'); ?></td>
                                        <td class="text-end">
                                            <p
                                               class="text-decoration-none text-primary fw-bold" 
                                               style="direction: ltr; display: inline-block;">
                                                <?php echo e($item->title); ?>

                                            </p>
                                        </td>

                                       <td>
    <?php if(!empty($item->imageSrc)): ?>
        <img src="<?php echo e($item->imageSrc); ?>"
            alt="صورة الخبر"
            class="rounded shadow-sm border"
            style="width: 80px; height: 60px; object-fit: cover;">
    <?php elseif($item->youtube_url): ?>
        <?php
            if (preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $item->youtube_url, $m)) {
                $youtubeId = $m[2];
            } else {
                $youtubeId = null;
            }
        ?>

        <?php if($youtubeId): ?>
            <a href="https://www.youtube.com/watch?v=<?php echo e($youtubeId); ?>" target="_blank">
                <img src="https://img.youtube.com/vi/<?php echo e($youtubeId); ?>/hqdefault.jpg"
                    alt="معاينة الفيديو"
                    class="rounded shadow-sm border"
                    style="width: 80px; height: 60px; object-fit: cover;">
            </a>
        <?php else: ?>
            <span class="badge bg-danger"><i class="la la-youtube"></i> YouTube</span>
        <?php endif; ?>
    <?php else: ?>
        
        <span class="text-muted">—</span>
    <?php endif; ?>
</td>



                                        <td>
                                            <span class="status-badge 
                                                <?php echo e($item->published ? 'status-badge--success' : 'status-badge--danger'); ?>">
                                                <?php echo e($item->published ? 'نعم' : 'لا'); ?>

                                            </span>
                                        </td>


                                        <td><?php echo e($item->date); ?></td>

                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <button type="button"
                                                          class="btn-icon btn-icon--warning"
														  onclick="window.location='<?php echo e(route('trophee_sportif.edit', $item)); ?>'"
                                                        
                                                        title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                <form action="<?php echo e(route('trophee_sportif.destroy', $item)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا التتويج الرياضي', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="py-4 text-muted">لا توجد أخبار حالياً.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                 
					 
                  					 <div class="d-flex justify-content-between align-items-center mt-3">
                      <?php echo e($trophee_sportif->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-trophee_sportif th, 
.table-trophee_sportif td {
    vertical-align: middle;
    text-align: center;
}

.table-trophee_sportif th:nth-child(2),
.table-trophee_sportif td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.status-badge--success {
    background-color: #e8f9ee; 
    color: #27ae60;           
}

.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}


</style>

<?php else: ?>
<script>window.location.href = "<?php echo e(route('admin')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/trophee_sportif/index.blade.php ENDPATH**/ ?>